<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSummaryUsageReport StructType
 * @subpackage Structs
 */
class CustomerSummaryUsageReport extends AbstractStructBase
{
    /**
     * The Last10Days
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\Last10DaysReport
     */
    public $Last10Days;
    /**
     * The MonthlyReports
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\MonthlyReportItem[]
     */
    public $MonthlyReports;
    /**
     * Constructor method for CustomerSummaryUsageReport
     * @uses CustomerSummaryUsageReport::setLast10Days()
     * @uses CustomerSummaryUsageReport::setMonthlyReports()
     * @param \Mnm\Last10DaysReport $last10Days
     * @param \Mnm\MonthlyReportItem[] $monthlyReports
     */
    public function __construct(\Mnm\Last10DaysReport $last10Days = null, array $monthlyReports = array())
    {
        $this
            ->setLast10Days($last10Days)
            ->setMonthlyReports($monthlyReports);
    }
    /**
     * Get Last10Days value
     * @return \Mnm\Last10DaysReport|null
     */
    public function getLast10Days()
    {
        return $this->Last10Days;
    }
    /**
     * Set Last10Days value
     * @param \Mnm\Last10DaysReport $last10Days
     * @return \Mnm\CustomerSummaryUsageReport
     */
    public function setLast10Days(\Mnm\Last10DaysReport $last10Days = null)
    {
        $this->Last10Days = $last10Days;
        return $this;
    }
    /**
     * Get MonthlyReports value
     * @return \Mnm\MonthlyReportItem[]|null
     */
    public function getMonthlyReports()
    {
        return $this->MonthlyReports;
    }
    /**
     * Set MonthlyReports value
     * @param \Mnm\MonthlyReportItem[] $monthlyReports
     * @return \Mnm\CustomerSummaryUsageReport
     */
    public function setMonthlyReports(array $monthlyReports = array())
    {
        $this->MonthlyReports = $monthlyReports;
        return $this;
    }
    /**
     * Add item to MonthlyReports value
     * @throws \InvalidArgumentException
     * @param \Mnm\MonthlyReportItem $item
     * @return \Mnm\CustomerSummaryUsageReport
     */
    public function addToMonthlyReports(\Mnm\MonthlyReportItem $item)
    {
        $this->MonthlyReports[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\CustomerSummaryUsageReport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
