<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInvoiceInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfInvoiceInfo extends AbstractStructArrayBase
{
    /**
     * The InvoiceInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Mnm\InvoiceInfo[]
     */
    public $InvoiceInfo;
    /**
     * Constructor method for ArrayOfInvoiceInfo
     * @uses ArrayOfInvoiceInfo::setInvoiceInfo()
     * @param \Mnm\InvoiceInfo[] $invoiceInfo
     */
    public function __construct(array $invoiceInfo = array())
    {
        $this
            ->setInvoiceInfo($invoiceInfo);
    }
    /**
     * Get InvoiceInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Mnm\InvoiceInfo[]|null
     */
    public function getInvoiceInfo()
    {
        return isset($this->InvoiceInfo) ? $this->InvoiceInfo : null;
    }
    /**
     * Set InvoiceInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Mnm\InvoiceInfo[] $invoiceInfo
     * @return \Mnm\ArrayOfInvoiceInfo
     */
    public function setInvoiceInfo(array $invoiceInfo = array())
    {
        if (is_null($invoiceInfo) || (is_array($invoiceInfo) && empty($invoiceInfo))) {
            unset($this->InvoiceInfo);
        } else {
            $this->InvoiceInfo = $invoiceInfo;
        }
        return $this;
    }
    /**
     * Add item to InvoiceInfo value
     * @throws \InvalidArgumentException
     * @param \Mnm\InvoiceInfo $item
     * @return \Mnm\ArrayOfInvoiceInfo
     */
    public function addToInvoiceInfo(\Mnm\InvoiceInfo $item)
    {
        $this->InvoiceInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Mnm\InvoiceInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Mnm\InvoiceInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Mnm\InvoiceInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Mnm\InvoiceInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Mnm\InvoiceInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InvoiceInfo
     */
    public function getAttributeName()
    {
        return 'InvoiceInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\ArrayOfInvoiceInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
