<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WhoAmIInfo StructType
 * @subpackage Structs
 */
class WhoAmIInfo extends AbstractStructBase
{
    /**
     * The User
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\UserShortInfo
     */
    public $User;
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\CustomerWithoutServiceInformation
     */
    public $Customer;
    /**
     * Constructor method for WhoAmIInfo
     * @uses WhoAmIInfo::setUser()
     * @uses WhoAmIInfo::setCustomer()
     * @param \Mnm\UserShortInfo $user
     * @param \Mnm\CustomerWithoutServiceInformation $customer
     */
    public function __construct(\Mnm\UserShortInfo $user = null, \Mnm\CustomerWithoutServiceInformation $customer = null)
    {
        $this
            ->setUser($user)
            ->setCustomer($customer);
    }
    /**
     * Get User value
     * @return \Mnm\UserShortInfo|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param \Mnm\UserShortInfo $user
     * @return \Mnm\WhoAmIInfo
     */
    public function setUser(\Mnm\UserShortInfo $user = null)
    {
        $this->User = $user;
        return $this;
    }
    /**
     * Get Customer value
     * @return \Mnm\CustomerWithoutServiceInformation|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \Mnm\CustomerWithoutServiceInformation $customer
     * @return \Mnm\WhoAmIInfo
     */
    public function setCustomer(\Mnm\CustomerWithoutServiceInformation $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\WhoAmIInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
