<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportMeansType StructType
 * @subpackage Structs
 */
class TransportMeansType extends AbstractStructBase
{
    /**
     * The JourneyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q197:JourneyID
     * @var \Mnm\JourneyIDType
     */
    public $JourneyID;
    /**
     * The RegistrationNationalityID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q198:RegistrationNationalityID
     * @var \Mnm\RegistrationNationalityIDType
     */
    public $RegistrationNationalityID;
    /**
     * The RegistrationNationality
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q199:RegistrationNationality
     * @var \Mnm\RegistrationNationalityType[]
     */
    public $RegistrationNationality;
    /**
     * The DirectionCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q200:DirectionCode
     * @var \Mnm\DirectionCodeType
     */
    public $DirectionCode;
    /**
     * The TransportMeansTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q201:TransportMeansTypeCode
     * @var \Mnm\TransportMeansTypeCodeType
     */
    public $TransportMeansTypeCode;
    /**
     * The TradeServiceCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q202:TradeServiceCode
     * @var \Mnm\TradeServiceCodeType
     */
    public $TradeServiceCode;
    /**
     * The Stowage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\StowageType
     */
    public $Stowage;
    /**
     * The AirTransport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\AirTransportType
     */
    public $AirTransport;
    /**
     * The RoadTransport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\RoadTransportType
     */
    public $RoadTransport;
    /**
     * The RailTransport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\RailTransportType
     */
    public $RailTransport;
    /**
     * The MaritimeTransport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\MaritimeTransportType
     */
    public $MaritimeTransport;
    /**
     * The OwnerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\PartyType
     */
    public $OwnerParty;
    /**
     * The MeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\DimensionType[]
     */
    public $MeasurementDimension;
    /**
     * Constructor method for TransportMeansType
     * @uses TransportMeansType::setJourneyID()
     * @uses TransportMeansType::setRegistrationNationalityID()
     * @uses TransportMeansType::setRegistrationNationality()
     * @uses TransportMeansType::setDirectionCode()
     * @uses TransportMeansType::setTransportMeansTypeCode()
     * @uses TransportMeansType::setTradeServiceCode()
     * @uses TransportMeansType::setStowage()
     * @uses TransportMeansType::setAirTransport()
     * @uses TransportMeansType::setRoadTransport()
     * @uses TransportMeansType::setRailTransport()
     * @uses TransportMeansType::setMaritimeTransport()
     * @uses TransportMeansType::setOwnerParty()
     * @uses TransportMeansType::setMeasurementDimension()
     * @param \Mnm\JourneyIDType $journeyID
     * @param \Mnm\RegistrationNationalityIDType $registrationNationalityID
     * @param \Mnm\RegistrationNationalityType[] $registrationNationality
     * @param \Mnm\DirectionCodeType $directionCode
     * @param \Mnm\TransportMeansTypeCodeType $transportMeansTypeCode
     * @param \Mnm\TradeServiceCodeType $tradeServiceCode
     * @param \Mnm\StowageType $stowage
     * @param \Mnm\AirTransportType $airTransport
     * @param \Mnm\RoadTransportType $roadTransport
     * @param \Mnm\RailTransportType $railTransport
     * @param \Mnm\MaritimeTransportType $maritimeTransport
     * @param \Mnm\PartyType $ownerParty
     * @param \Mnm\DimensionType[] $measurementDimension
     */
    public function __construct(\Mnm\JourneyIDType $journeyID = null, \Mnm\RegistrationNationalityIDType $registrationNationalityID = null, array $registrationNationality = array(), \Mnm\DirectionCodeType $directionCode = null, \Mnm\TransportMeansTypeCodeType $transportMeansTypeCode = null, \Mnm\TradeServiceCodeType $tradeServiceCode = null, \Mnm\StowageType $stowage = null, \Mnm\AirTransportType $airTransport = null, \Mnm\RoadTransportType $roadTransport = null, \Mnm\RailTransportType $railTransport = null, \Mnm\MaritimeTransportType $maritimeTransport = null, \Mnm\PartyType $ownerParty = null, array $measurementDimension = array())
    {
        $this
            ->setJourneyID($journeyID)
            ->setRegistrationNationalityID($registrationNationalityID)
            ->setRegistrationNationality($registrationNationality)
            ->setDirectionCode($directionCode)
            ->setTransportMeansTypeCode($transportMeansTypeCode)
            ->setTradeServiceCode($tradeServiceCode)
            ->setStowage($stowage)
            ->setAirTransport($airTransport)
            ->setRoadTransport($roadTransport)
            ->setRailTransport($railTransport)
            ->setMaritimeTransport($maritimeTransport)
            ->setOwnerParty($ownerParty)
            ->setMeasurementDimension($measurementDimension);
    }
    /**
     * Get JourneyID value
     * @return \Mnm\JourneyIDType|null
     */
    public function getJourneyID()
    {
        return $this->JourneyID;
    }
    /**
     * Set JourneyID value
     * @param \Mnm\JourneyIDType $journeyID
     * @return \Mnm\TransportMeansType
     */
    public function setJourneyID(\Mnm\JourneyIDType $journeyID = null)
    {
        $this->JourneyID = $journeyID;
        return $this;
    }
    /**
     * Get RegistrationNationalityID value
     * @return \Mnm\RegistrationNationalityIDType|null
     */
    public function getRegistrationNationalityID()
    {
        return $this->RegistrationNationalityID;
    }
    /**
     * Set RegistrationNationalityID value
     * @param \Mnm\RegistrationNationalityIDType $registrationNationalityID
     * @return \Mnm\TransportMeansType
     */
    public function setRegistrationNationalityID(\Mnm\RegistrationNationalityIDType $registrationNationalityID = null)
    {
        $this->RegistrationNationalityID = $registrationNationalityID;
        return $this;
    }
    /**
     * Get RegistrationNationality value
     * @return \Mnm\RegistrationNationalityType[]|null
     */
    public function getRegistrationNationality()
    {
        return $this->RegistrationNationality;
    }
    /**
     * Set RegistrationNationality value
     * @param \Mnm\RegistrationNationalityType[] $registrationNationality
     * @return \Mnm\TransportMeansType
     */
    public function setRegistrationNationality(array $registrationNationality = array())
    {
        $this->RegistrationNationality = $registrationNationality;
        return $this;
    }
    /**
     * Add item to RegistrationNationality value
     * @throws \InvalidArgumentException
     * @param \Mnm\RegistrationNationalityType $item
     * @return \Mnm\TransportMeansType
     */
    public function addToRegistrationNationality(\Mnm\RegistrationNationalityType $item)
    {
        $this->RegistrationNationality[] = $item;
        return $this;
    }
    /**
     * Get DirectionCode value
     * @return \Mnm\DirectionCodeType|null
     */
    public function getDirectionCode()
    {
        return $this->DirectionCode;
    }
    /**
     * Set DirectionCode value
     * @param \Mnm\DirectionCodeType $directionCode
     * @return \Mnm\TransportMeansType
     */
    public function setDirectionCode(\Mnm\DirectionCodeType $directionCode = null)
    {
        $this->DirectionCode = $directionCode;
        return $this;
    }
    /**
     * Get TransportMeansTypeCode value
     * @return \Mnm\TransportMeansTypeCodeType|null
     */
    public function getTransportMeansTypeCode()
    {
        return $this->TransportMeansTypeCode;
    }
    /**
     * Set TransportMeansTypeCode value
     * @param \Mnm\TransportMeansTypeCodeType $transportMeansTypeCode
     * @return \Mnm\TransportMeansType
     */
    public function setTransportMeansTypeCode(\Mnm\TransportMeansTypeCodeType $transportMeansTypeCode = null)
    {
        $this->TransportMeansTypeCode = $transportMeansTypeCode;
        return $this;
    }
    /**
     * Get TradeServiceCode value
     * @return \Mnm\TradeServiceCodeType|null
     */
    public function getTradeServiceCode()
    {
        return $this->TradeServiceCode;
    }
    /**
     * Set TradeServiceCode value
     * @param \Mnm\TradeServiceCodeType $tradeServiceCode
     * @return \Mnm\TransportMeansType
     */
    public function setTradeServiceCode(\Mnm\TradeServiceCodeType $tradeServiceCode = null)
    {
        $this->TradeServiceCode = $tradeServiceCode;
        return $this;
    }
    /**
     * Get Stowage value
     * @return \Mnm\StowageType|null
     */
    public function getStowage()
    {
        return $this->Stowage;
    }
    /**
     * Set Stowage value
     * @param \Mnm\StowageType $stowage
     * @return \Mnm\TransportMeansType
     */
    public function setStowage(\Mnm\StowageType $stowage = null)
    {
        $this->Stowage = $stowage;
        return $this;
    }
    /**
     * Get AirTransport value
     * @return \Mnm\AirTransportType|null
     */
    public function getAirTransport()
    {
        return $this->AirTransport;
    }
    /**
     * Set AirTransport value
     * @param \Mnm\AirTransportType $airTransport
     * @return \Mnm\TransportMeansType
     */
    public function setAirTransport(\Mnm\AirTransportType $airTransport = null)
    {
        $this->AirTransport = $airTransport;
        return $this;
    }
    /**
     * Get RoadTransport value
     * @return \Mnm\RoadTransportType|null
     */
    public function getRoadTransport()
    {
        return $this->RoadTransport;
    }
    /**
     * Set RoadTransport value
     * @param \Mnm\RoadTransportType $roadTransport
     * @return \Mnm\TransportMeansType
     */
    public function setRoadTransport(\Mnm\RoadTransportType $roadTransport = null)
    {
        $this->RoadTransport = $roadTransport;
        return $this;
    }
    /**
     * Get RailTransport value
     * @return \Mnm\RailTransportType|null
     */
    public function getRailTransport()
    {
        return $this->RailTransport;
    }
    /**
     * Set RailTransport value
     * @param \Mnm\RailTransportType $railTransport
     * @return \Mnm\TransportMeansType
     */
    public function setRailTransport(\Mnm\RailTransportType $railTransport = null)
    {
        $this->RailTransport = $railTransport;
        return $this;
    }
    /**
     * Get MaritimeTransport value
     * @return \Mnm\MaritimeTransportType|null
     */
    public function getMaritimeTransport()
    {
        return $this->MaritimeTransport;
    }
    /**
     * Set MaritimeTransport value
     * @param \Mnm\MaritimeTransportType $maritimeTransport
     * @return \Mnm\TransportMeansType
     */
    public function setMaritimeTransport(\Mnm\MaritimeTransportType $maritimeTransport = null)
    {
        $this->MaritimeTransport = $maritimeTransport;
        return $this;
    }
    /**
     * Get OwnerParty value
     * @return \Mnm\PartyType|null
     */
    public function getOwnerParty()
    {
        return $this->OwnerParty;
    }
    /**
     * Set OwnerParty value
     * @param \Mnm\PartyType $ownerParty
     * @return \Mnm\TransportMeansType
     */
    public function setOwnerParty(\Mnm\PartyType $ownerParty = null)
    {
        $this->OwnerParty = $ownerParty;
        return $this;
    }
    /**
     * Get MeasurementDimension value
     * @return \Mnm\DimensionType[]|null
     */
    public function getMeasurementDimension()
    {
        return $this->MeasurementDimension;
    }
    /**
     * Set MeasurementDimension value
     * @param \Mnm\DimensionType[] $measurementDimension
     * @return \Mnm\TransportMeansType
     */
    public function setMeasurementDimension(array $measurementDimension = array())
    {
        $this->MeasurementDimension = $measurementDimension;
        return $this;
    }
    /**
     * Add item to MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \Mnm\DimensionType $item
     * @return \Mnm\TransportMeansType
     */
    public function addToMeasurementDimension(\Mnm\DimensionType $item)
    {
        $this->MeasurementDimension[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\TransportMeansType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
