<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportHandlingUnitType StructType
 * @subpackage Structs
 */
class TransportHandlingUnitType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q215:ID
     * @var \Mnm\IDType
     */
    public $ID;
    /**
     * The TransportHandlingUnitTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q216:TransportHandlingUnitTypeCode
     * @var \Mnm\TransportHandlingUnitTypeCodeType
     */
    public $TransportHandlingUnitTypeCode;
    /**
     * The HandlingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q217:HandlingCode
     * @var \Mnm\HandlingCodeType
     */
    public $HandlingCode;
    /**
     * The HandlingInstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q218:HandlingInstructions
     * @var \Mnm\HandlingInstructionsType
     */
    public $HandlingInstructions;
    /**
     * The HazardousRiskIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q219:HazardousRiskIndicator
     * @var \Mnm\HazardousRiskIndicatorType
     */
    public $HazardousRiskIndicator;
    /**
     * The TotalGoodsItemQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q220:TotalGoodsItemQuantity
     * @var \Mnm\TotalGoodsItemQuantityType
     */
    public $TotalGoodsItemQuantity;
    /**
     * The TotalPackageQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q221:TotalPackageQuantity
     * @var \Mnm\TotalPackageQuantityType
     */
    public $TotalPackageQuantity;
    /**
     * The DamageRemarks
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q222:DamageRemarks
     * @var \Mnm\DamageRemarksType[]
     */
    public $DamageRemarks;
    /**
     * The TraceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q223:TraceID
     * @var \Mnm\TraceIDType
     */
    public $TraceID;
    /**
     * The ActualPackage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\PackageType[]
     */
    public $ActualPackage;
    /**
     * The TransportEquipment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\TransportEquipmentType[]
     */
    public $TransportEquipment;
    /**
     * The TransportMeans
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\TransportMeansType[]
     */
    public $TransportMeans;
    /**
     * The HazardousGoodsTransit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\HazardousGoodsTransitType[]
     */
    public $HazardousGoodsTransit;
    /**
     * The MeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\DimensionType[]
     */
    public $MeasurementDimension;
    /**
     * The MinimumTemperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\TemperatureType
     */
    public $MinimumTemperature;
    /**
     * The MaximumTemperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\TemperatureType
     */
    public $MaximumTemperature;
    /**
     * The FloorSpaceMeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\DimensionType
     */
    public $FloorSpaceMeasurementDimension;
    /**
     * The PalletSpaceMeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\DimensionType
     */
    public $PalletSpaceMeasurementDimension;
    /**
     * The ShipmentDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\DocumentReferenceType[]
     */
    public $ShipmentDocumentReference;
    /**
     * The CustomsDeclaration
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\CustomsDeclarationType[]
     */
    public $CustomsDeclaration;
    /**
     * Constructor method for TransportHandlingUnitType
     * @uses TransportHandlingUnitType::setID()
     * @uses TransportHandlingUnitType::setTransportHandlingUnitTypeCode()
     * @uses TransportHandlingUnitType::setHandlingCode()
     * @uses TransportHandlingUnitType::setHandlingInstructions()
     * @uses TransportHandlingUnitType::setHazardousRiskIndicator()
     * @uses TransportHandlingUnitType::setTotalGoodsItemQuantity()
     * @uses TransportHandlingUnitType::setTotalPackageQuantity()
     * @uses TransportHandlingUnitType::setDamageRemarks()
     * @uses TransportHandlingUnitType::setTraceID()
     * @uses TransportHandlingUnitType::setActualPackage()
     * @uses TransportHandlingUnitType::setTransportEquipment()
     * @uses TransportHandlingUnitType::setTransportMeans()
     * @uses TransportHandlingUnitType::setHazardousGoodsTransit()
     * @uses TransportHandlingUnitType::setMeasurementDimension()
     * @uses TransportHandlingUnitType::setMinimumTemperature()
     * @uses TransportHandlingUnitType::setMaximumTemperature()
     * @uses TransportHandlingUnitType::setFloorSpaceMeasurementDimension()
     * @uses TransportHandlingUnitType::setPalletSpaceMeasurementDimension()
     * @uses TransportHandlingUnitType::setShipmentDocumentReference()
     * @uses TransportHandlingUnitType::setCustomsDeclaration()
     * @param \Mnm\IDType $iD
     * @param \Mnm\TransportHandlingUnitTypeCodeType $transportHandlingUnitTypeCode
     * @param \Mnm\HandlingCodeType $handlingCode
     * @param \Mnm\HandlingInstructionsType $handlingInstructions
     * @param \Mnm\HazardousRiskIndicatorType $hazardousRiskIndicator
     * @param \Mnm\TotalGoodsItemQuantityType $totalGoodsItemQuantity
     * @param \Mnm\TotalPackageQuantityType $totalPackageQuantity
     * @param \Mnm\DamageRemarksType[] $damageRemarks
     * @param \Mnm\TraceIDType $traceID
     * @param \Mnm\PackageType[] $actualPackage
     * @param \Mnm\TransportEquipmentType[] $transportEquipment
     * @param \Mnm\TransportMeansType[] $transportMeans
     * @param \Mnm\HazardousGoodsTransitType[] $hazardousGoodsTransit
     * @param \Mnm\DimensionType[] $measurementDimension
     * @param \Mnm\TemperatureType $minimumTemperature
     * @param \Mnm\TemperatureType $maximumTemperature
     * @param \Mnm\DimensionType $floorSpaceMeasurementDimension
     * @param \Mnm\DimensionType $palletSpaceMeasurementDimension
     * @param \Mnm\DocumentReferenceType[] $shipmentDocumentReference
     * @param \Mnm\CustomsDeclarationType[] $customsDeclaration
     */
    public function __construct(\Mnm\IDType $iD = null, \Mnm\TransportHandlingUnitTypeCodeType $transportHandlingUnitTypeCode = null, \Mnm\HandlingCodeType $handlingCode = null, \Mnm\HandlingInstructionsType $handlingInstructions = null, \Mnm\HazardousRiskIndicatorType $hazardousRiskIndicator = null, \Mnm\TotalGoodsItemQuantityType $totalGoodsItemQuantity = null, \Mnm\TotalPackageQuantityType $totalPackageQuantity = null, array $damageRemarks = array(), \Mnm\TraceIDType $traceID = null, array $actualPackage = array(), array $transportEquipment = array(), array $transportMeans = array(), array $hazardousGoodsTransit = array(), array $measurementDimension = array(), \Mnm\TemperatureType $minimumTemperature = null, \Mnm\TemperatureType $maximumTemperature = null, \Mnm\DimensionType $floorSpaceMeasurementDimension = null, \Mnm\DimensionType $palletSpaceMeasurementDimension = null, array $shipmentDocumentReference = array(), array $customsDeclaration = array())
    {
        $this
            ->setID($iD)
            ->setTransportHandlingUnitTypeCode($transportHandlingUnitTypeCode)
            ->setHandlingCode($handlingCode)
            ->setHandlingInstructions($handlingInstructions)
            ->setHazardousRiskIndicator($hazardousRiskIndicator)
            ->setTotalGoodsItemQuantity($totalGoodsItemQuantity)
            ->setTotalPackageQuantity($totalPackageQuantity)
            ->setDamageRemarks($damageRemarks)
            ->setTraceID($traceID)
            ->setActualPackage($actualPackage)
            ->setTransportEquipment($transportEquipment)
            ->setTransportMeans($transportMeans)
            ->setHazardousGoodsTransit($hazardousGoodsTransit)
            ->setMeasurementDimension($measurementDimension)
            ->setMinimumTemperature($minimumTemperature)
            ->setMaximumTemperature($maximumTemperature)
            ->setFloorSpaceMeasurementDimension($floorSpaceMeasurementDimension)
            ->setPalletSpaceMeasurementDimension($palletSpaceMeasurementDimension)
            ->setShipmentDocumentReference($shipmentDocumentReference)
            ->setCustomsDeclaration($customsDeclaration);
    }
    /**
     * Get ID value
     * @return \Mnm\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Mnm\IDType $iD
     * @return \Mnm\TransportHandlingUnitType
     */
    public function setID(\Mnm\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get TransportHandlingUnitTypeCode value
     * @return \Mnm\TransportHandlingUnitTypeCodeType|null
     */
    public function getTransportHandlingUnitTypeCode()
    {
        return $this->TransportHandlingUnitTypeCode;
    }
    /**
     * Set TransportHandlingUnitTypeCode value
     * @param \Mnm\TransportHandlingUnitTypeCodeType $transportHandlingUnitTypeCode
     * @return \Mnm\TransportHandlingUnitType
     */
    public function setTransportHandlingUnitTypeCode(\Mnm\TransportHandlingUnitTypeCodeType $transportHandlingUnitTypeCode = null)
    {
        $this->TransportHandlingUnitTypeCode = $transportHandlingUnitTypeCode;
        return $this;
    }
    /**
     * Get HandlingCode value
     * @return \Mnm\HandlingCodeType|null
     */
    public function getHandlingCode()
    {
        return $this->HandlingCode;
    }
    /**
     * Set HandlingCode value
     * @param \Mnm\HandlingCodeType $handlingCode
     * @return \Mnm\TransportHandlingUnitType
     */
    public function setHandlingCode(\Mnm\HandlingCodeType $handlingCode = null)
    {
        $this->HandlingCode = $handlingCode;
        return $this;
    }
    /**
     * Get HandlingInstructions value
     * @return \Mnm\HandlingInstructionsType|null
     */
    public function getHandlingInstructions()
    {
        return $this->HandlingInstructions;
    }
    /**
     * Set HandlingInstructions value
     * @param \Mnm\HandlingInstructionsType $handlingInstructions
     * @return \Mnm\TransportHandlingUnitType
     */
    public function setHandlingInstructions(\Mnm\HandlingInstructionsType $handlingInstructions = null)
    {
        $this->HandlingInstructions = $handlingInstructions;
        return $this;
    }
    /**
     * Get HazardousRiskIndicator value
     * @return \Mnm\HazardousRiskIndicatorType|null
     */
    public function getHazardousRiskIndicator()
    {
        return $this->HazardousRiskIndicator;
    }
    /**
     * Set HazardousRiskIndicator value
     * @param \Mnm\HazardousRiskIndicatorType $hazardousRiskIndicator
     * @return \Mnm\TransportHandlingUnitType
     */
    public function setHazardousRiskIndicator(\Mnm\HazardousRiskIndicatorType $hazardousRiskIndicator = null)
    {
        $this->HazardousRiskIndicator = $hazardousRiskIndicator;
        return $this;
    }
    /**
     * Get TotalGoodsItemQuantity value
     * @return \Mnm\TotalGoodsItemQuantityType|null
     */
    public function getTotalGoodsItemQuantity()
    {
        return $this->TotalGoodsItemQuantity;
    }
    /**
     * Set TotalGoodsItemQuantity value
     * @param \Mnm\TotalGoodsItemQuantityType $totalGoodsItemQuantity
     * @return \Mnm\TransportHandlingUnitType
     */
    public function setTotalGoodsItemQuantity(\Mnm\TotalGoodsItemQuantityType $totalGoodsItemQuantity = null)
    {
        $this->TotalGoodsItemQuantity = $totalGoodsItemQuantity;
        return $this;
    }
    /**
     * Get TotalPackageQuantity value
     * @return \Mnm\TotalPackageQuantityType|null
     */
    public function getTotalPackageQuantity()
    {
        return $this->TotalPackageQuantity;
    }
    /**
     * Set TotalPackageQuantity value
     * @param \Mnm\TotalPackageQuantityType $totalPackageQuantity
     * @return \Mnm\TransportHandlingUnitType
     */
    public function setTotalPackageQuantity(\Mnm\TotalPackageQuantityType $totalPackageQuantity = null)
    {
        $this->TotalPackageQuantity = $totalPackageQuantity;
        return $this;
    }
    /**
     * Get DamageRemarks value
     * @return \Mnm\DamageRemarksType[]|null
     */
    public function getDamageRemarks()
    {
        return $this->DamageRemarks;
    }
    /**
     * Set DamageRemarks value
     * @param \Mnm\DamageRemarksType[] $damageRemarks
     * @return \Mnm\TransportHandlingUnitType
     */
    public function setDamageRemarks(array $damageRemarks = array())
    {
        $this->DamageRemarks = $damageRemarks;
        return $this;
    }
    /**
     * Add item to DamageRemarks value
     * @throws \InvalidArgumentException
     * @param \Mnm\DamageRemarksType $item
     * @return \Mnm\TransportHandlingUnitType
     */
    public function addToDamageRemarks(\Mnm\DamageRemarksType $item)
    {
        $this->DamageRemarks[] = $item;
        return $this;
    }
    /**
     * Get TraceID value
     * @return \Mnm\TraceIDType|null
     */
    public function getTraceID()
    {
        return $this->TraceID;
    }
    /**
     * Set TraceID value
     * @param \Mnm\TraceIDType $traceID
     * @return \Mnm\TransportHandlingUnitType
     */
    public function setTraceID(\Mnm\TraceIDType $traceID = null)
    {
        $this->TraceID = $traceID;
        return $this;
    }
    /**
     * Get ActualPackage value
     * @return \Mnm\PackageType[]|null
     */
    public function getActualPackage()
    {
        return $this->ActualPackage;
    }
    /**
     * Set ActualPackage value
     * @param \Mnm\PackageType[] $actualPackage
     * @return \Mnm\TransportHandlingUnitType
     */
    public function setActualPackage(array $actualPackage = array())
    {
        $this->ActualPackage = $actualPackage;
        return $this;
    }
    /**
     * Add item to ActualPackage value
     * @throws \InvalidArgumentException
     * @param \Mnm\PackageType $item
     * @return \Mnm\TransportHandlingUnitType
     */
    public function addToActualPackage(\Mnm\PackageType $item)
    {
        $this->ActualPackage[] = $item;
        return $this;
    }
    /**
     * Get TransportEquipment value
     * @return \Mnm\TransportEquipmentType[]|null
     */
    public function getTransportEquipment()
    {
        return $this->TransportEquipment;
    }
    /**
     * Set TransportEquipment value
     * @param \Mnm\TransportEquipmentType[] $transportEquipment
     * @return \Mnm\TransportHandlingUnitType
     */
    public function setTransportEquipment(array $transportEquipment = array())
    {
        $this->TransportEquipment = $transportEquipment;
        return $this;
    }
    /**
     * Add item to TransportEquipment value
     * @throws \InvalidArgumentException
     * @param \Mnm\TransportEquipmentType $item
     * @return \Mnm\TransportHandlingUnitType
     */
    public function addToTransportEquipment(\Mnm\TransportEquipmentType $item)
    {
        $this->TransportEquipment[] = $item;
        return $this;
    }
    /**
     * Get TransportMeans value
     * @return \Mnm\TransportMeansType[]|null
     */
    public function getTransportMeans()
    {
        return $this->TransportMeans;
    }
    /**
     * Set TransportMeans value
     * @param \Mnm\TransportMeansType[] $transportMeans
     * @return \Mnm\TransportHandlingUnitType
     */
    public function setTransportMeans(array $transportMeans = array())
    {
        $this->TransportMeans = $transportMeans;
        return $this;
    }
    /**
     * Add item to TransportMeans value
     * @throws \InvalidArgumentException
     * @param \Mnm\TransportMeansType $item
     * @return \Mnm\TransportHandlingUnitType
     */
    public function addToTransportMeans(\Mnm\TransportMeansType $item)
    {
        $this->TransportMeans[] = $item;
        return $this;
    }
    /**
     * Get HazardousGoodsTransit value
     * @return \Mnm\HazardousGoodsTransitType[]|null
     */
    public function getHazardousGoodsTransit()
    {
        return $this->HazardousGoodsTransit;
    }
    /**
     * Set HazardousGoodsTransit value
     * @param \Mnm\HazardousGoodsTransitType[] $hazardousGoodsTransit
     * @return \Mnm\TransportHandlingUnitType
     */
    public function setHazardousGoodsTransit(array $hazardousGoodsTransit = array())
    {
        $this->HazardousGoodsTransit = $hazardousGoodsTransit;
        return $this;
    }
    /**
     * Add item to HazardousGoodsTransit value
     * @throws \InvalidArgumentException
     * @param \Mnm\HazardousGoodsTransitType $item
     * @return \Mnm\TransportHandlingUnitType
     */
    public function addToHazardousGoodsTransit(\Mnm\HazardousGoodsTransitType $item)
    {
        $this->HazardousGoodsTransit[] = $item;
        return $this;
    }
    /**
     * Get MeasurementDimension value
     * @return \Mnm\DimensionType[]|null
     */
    public function getMeasurementDimension()
    {
        return $this->MeasurementDimension;
    }
    /**
     * Set MeasurementDimension value
     * @param \Mnm\DimensionType[] $measurementDimension
     * @return \Mnm\TransportHandlingUnitType
     */
    public function setMeasurementDimension(array $measurementDimension = array())
    {
        $this->MeasurementDimension = $measurementDimension;
        return $this;
    }
    /**
     * Add item to MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \Mnm\DimensionType $item
     * @return \Mnm\TransportHandlingUnitType
     */
    public function addToMeasurementDimension(\Mnm\DimensionType $item)
    {
        $this->MeasurementDimension[] = $item;
        return $this;
    }
    /**
     * Get MinimumTemperature value
     * @return \Mnm\TemperatureType|null
     */
    public function getMinimumTemperature()
    {
        return $this->MinimumTemperature;
    }
    /**
     * Set MinimumTemperature value
     * @param \Mnm\TemperatureType $minimumTemperature
     * @return \Mnm\TransportHandlingUnitType
     */
    public function setMinimumTemperature(\Mnm\TemperatureType $minimumTemperature = null)
    {
        $this->MinimumTemperature = $minimumTemperature;
        return $this;
    }
    /**
     * Get MaximumTemperature value
     * @return \Mnm\TemperatureType|null
     */
    public function getMaximumTemperature()
    {
        return $this->MaximumTemperature;
    }
    /**
     * Set MaximumTemperature value
     * @param \Mnm\TemperatureType $maximumTemperature
     * @return \Mnm\TransportHandlingUnitType
     */
    public function setMaximumTemperature(\Mnm\TemperatureType $maximumTemperature = null)
    {
        $this->MaximumTemperature = $maximumTemperature;
        return $this;
    }
    /**
     * Get FloorSpaceMeasurementDimension value
     * @return \Mnm\DimensionType|null
     */
    public function getFloorSpaceMeasurementDimension()
    {
        return $this->FloorSpaceMeasurementDimension;
    }
    /**
     * Set FloorSpaceMeasurementDimension value
     * @param \Mnm\DimensionType $floorSpaceMeasurementDimension
     * @return \Mnm\TransportHandlingUnitType
     */
    public function setFloorSpaceMeasurementDimension(\Mnm\DimensionType $floorSpaceMeasurementDimension = null)
    {
        $this->FloorSpaceMeasurementDimension = $floorSpaceMeasurementDimension;
        return $this;
    }
    /**
     * Get PalletSpaceMeasurementDimension value
     * @return \Mnm\DimensionType|null
     */
    public function getPalletSpaceMeasurementDimension()
    {
        return $this->PalletSpaceMeasurementDimension;
    }
    /**
     * Set PalletSpaceMeasurementDimension value
     * @param \Mnm\DimensionType $palletSpaceMeasurementDimension
     * @return \Mnm\TransportHandlingUnitType
     */
    public function setPalletSpaceMeasurementDimension(\Mnm\DimensionType $palletSpaceMeasurementDimension = null)
    {
        $this->PalletSpaceMeasurementDimension = $palletSpaceMeasurementDimension;
        return $this;
    }
    /**
     * Get ShipmentDocumentReference value
     * @return \Mnm\DocumentReferenceType[]|null
     */
    public function getShipmentDocumentReference()
    {
        return $this->ShipmentDocumentReference;
    }
    /**
     * Set ShipmentDocumentReference value
     * @param \Mnm\DocumentReferenceType[] $shipmentDocumentReference
     * @return \Mnm\TransportHandlingUnitType
     */
    public function setShipmentDocumentReference(array $shipmentDocumentReference = array())
    {
        $this->ShipmentDocumentReference = $shipmentDocumentReference;
        return $this;
    }
    /**
     * Add item to ShipmentDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Mnm\DocumentReferenceType $item
     * @return \Mnm\TransportHandlingUnitType
     */
    public function addToShipmentDocumentReference(\Mnm\DocumentReferenceType $item)
    {
        $this->ShipmentDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get CustomsDeclaration value
     * @return \Mnm\CustomsDeclarationType[]|null
     */
    public function getCustomsDeclaration()
    {
        return $this->CustomsDeclaration;
    }
    /**
     * Set CustomsDeclaration value
     * @param \Mnm\CustomsDeclarationType[] $customsDeclaration
     * @return \Mnm\TransportHandlingUnitType
     */
    public function setCustomsDeclaration(array $customsDeclaration = array())
    {
        $this->CustomsDeclaration = $customsDeclaration;
        return $this;
    }
    /**
     * Add item to CustomsDeclaration value
     * @throws \InvalidArgumentException
     * @param \Mnm\CustomsDeclarationType $item
     * @return \Mnm\TransportHandlingUnitType
     */
    public function addToCustomsDeclaration(\Mnm\CustomsDeclarationType $item)
    {
        $this->CustomsDeclaration[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\TransportHandlingUnitType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
