<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TemperatureType StructType
 * @subpackage Structs
 */
class TemperatureType extends AbstractStructBase
{
    /**
     * The AttributeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q189:AttributeID
     * @var \Mnm\AttributeIDType
     */
    public $AttributeID;
    /**
     * The Measure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q190:Measure
     * @var \Mnm\MeasureType
     */
    public $Measure;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q191:Description
     * @var \Mnm\DescriptionType[]
     */
    public $Description;
    /**
     * Constructor method for TemperatureType
     * @uses TemperatureType::setAttributeID()
     * @uses TemperatureType::setMeasure()
     * @uses TemperatureType::setDescription()
     * @param \Mnm\AttributeIDType $attributeID
     * @param \Mnm\MeasureType $measure
     * @param \Mnm\DescriptionType[] $description
     */
    public function __construct(\Mnm\AttributeIDType $attributeID = null, \Mnm\MeasureType $measure = null, array $description = array())
    {
        $this
            ->setAttributeID($attributeID)
            ->setMeasure($measure)
            ->setDescription($description);
    }
    /**
     * Get AttributeID value
     * @return \Mnm\AttributeIDType|null
     */
    public function getAttributeID()
    {
        return $this->AttributeID;
    }
    /**
     * Set AttributeID value
     * @param \Mnm\AttributeIDType $attributeID
     * @return \Mnm\TemperatureType
     */
    public function setAttributeID(\Mnm\AttributeIDType $attributeID = null)
    {
        $this->AttributeID = $attributeID;
        return $this;
    }
    /**
     * Get Measure value
     * @return \Mnm\MeasureType|null
     */
    public function getMeasure()
    {
        return $this->Measure;
    }
    /**
     * Set Measure value
     * @param \Mnm\MeasureType $measure
     * @return \Mnm\TemperatureType
     */
    public function setMeasure(\Mnm\MeasureType $measure = null)
    {
        $this->Measure = $measure;
        return $this;
    }
    /**
     * Get Description value
     * @return \Mnm\DescriptionType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \Mnm\DescriptionType[] $description
     * @return \Mnm\TemperatureType
     */
    public function setDescription(array $description = array())
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \Mnm\DescriptionType $item
     * @return \Mnm\TemperatureType
     */
    public function addToDescription(\Mnm\DescriptionType $item)
    {
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\TemperatureType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
