<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxTotalType StructType
 * @subpackage Structs
 */
class TaxTotalType extends AbstractStructBase
{
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q177:TaxAmount
     * @var \Mnm\TaxAmountType
     */
    public $TaxAmount;
    /**
     * The TaxSubtotal
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\TaxSubtotalType[]
     */
    public $TaxSubtotal;
    /**
     * Constructor method for TaxTotalType
     * @uses TaxTotalType::setTaxAmount()
     * @uses TaxTotalType::setTaxSubtotal()
     * @param \Mnm\TaxAmountType $taxAmount
     * @param \Mnm\TaxSubtotalType[] $taxSubtotal
     */
    public function __construct(\Mnm\TaxAmountType $taxAmount = null, array $taxSubtotal = array())
    {
        $this
            ->setTaxAmount($taxAmount)
            ->setTaxSubtotal($taxSubtotal);
    }
    /**
     * Get TaxAmount value
     * @return \Mnm\TaxAmountType|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param \Mnm\TaxAmountType $taxAmount
     * @return \Mnm\TaxTotalType
     */
    public function setTaxAmount(\Mnm\TaxAmountType $taxAmount = null)
    {
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get TaxSubtotal value
     * @return \Mnm\TaxSubtotalType[]|null
     */
    public function getTaxSubtotal()
    {
        return $this->TaxSubtotal;
    }
    /**
     * Set TaxSubtotal value
     * @param \Mnm\TaxSubtotalType[] $taxSubtotal
     * @return \Mnm\TaxTotalType
     */
    public function setTaxSubtotal(array $taxSubtotal = array())
    {
        $this->TaxSubtotal = $taxSubtotal;
        return $this;
    }
    /**
     * Add item to TaxSubtotal value
     * @throws \InvalidArgumentException
     * @param \Mnm\TaxSubtotalType $item
     * @return \Mnm\TaxTotalType
     */
    public function addToTaxSubtotal(\Mnm\TaxSubtotalType $item)
    {
        $this->TaxSubtotal[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\TaxTotalType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
