<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignatureType StructType
 * @subpackage Structs
 */
class SignatureType extends AbstractStructBase
{
    /**
     * The SignedInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\SignedInfoType
     */
    public $SignedInfo;
    /**
     * The SignatureValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\SignatureValueType
     */
    public $SignatureValue;
    /**
     * The KeyInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\KeyInfoType
     */
    public $KeyInfo;
    /**
     * The Object
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\ObjectType[]
     */
    public $Object;
    /**
     * The Id
     * @var string
     */
    public $Id;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q81:ID
     * @var \Mnm\IDType
     */
    public $ID;
    /**
     * The SignatoryParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\PartyType
     */
    public $SignatoryParty;
    /**
     * The DigitalSignatureAttachment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\AttachmentType
     */
    public $DigitalSignatureAttachment;
    /**
     * Constructor method for SignatureType
     * @uses SignatureType::setSignedInfo()
     * @uses SignatureType::setSignatureValue()
     * @uses SignatureType::setKeyInfo()
     * @uses SignatureType::setObject()
     * @uses SignatureType::setId()
     * @uses SignatureType::setID_1()
     * @uses SignatureType::setSignatoryParty()
     * @uses SignatureType::setDigitalSignatureAttachment()
     * @param \Mnm\SignedInfoType $signedInfo
     * @param \Mnm\SignatureValueType $signatureValue
     * @param \Mnm\KeyInfoType $keyInfo
     * @param \Mnm\ObjectType[] $object
     * @param string $id
     * @param \Mnm\IDType $iD
     * @param \Mnm\PartyType $signatoryParty
     * @param \Mnm\AttachmentType $digitalSignatureAttachment
     */
    public function __construct(\Mnm\SignedInfoType $signedInfo = null, \Mnm\SignatureValueType $signatureValue = null, \Mnm\KeyInfoType $keyInfo = null, array $object = array(), $id = null, \Mnm\IDType $iD_1 = null, \Mnm\PartyType $signatoryParty = null, \Mnm\AttachmentType $digitalSignatureAttachment = null)
    {
        $this
            ->setSignedInfo($signedInfo)
            ->setSignatureValue($signatureValue)
            ->setKeyInfo($keyInfo)
            ->setObject($object)
            ->setId($id)
            ->setID_1($iD_1)
            ->setSignatoryParty($signatoryParty)
            ->setDigitalSignatureAttachment($digitalSignatureAttachment);
    }
    /**
     * Get SignedInfo value
     * @return \Mnm\SignedInfoType|null
     */
    public function getSignedInfo()
    {
        return $this->SignedInfo;
    }
    /**
     * Set SignedInfo value
     * @param \Mnm\SignedInfoType $signedInfo
     * @return \Mnm\SignatureType
     */
    public function setSignedInfo(\Mnm\SignedInfoType $signedInfo = null)
    {
        $this->SignedInfo = $signedInfo;
        return $this;
    }
    /**
     * Get SignatureValue value
     * @return \Mnm\SignatureValueType|null
     */
    public function getSignatureValue()
    {
        return $this->SignatureValue;
    }
    /**
     * Set SignatureValue value
     * @param \Mnm\SignatureValueType $signatureValue
     * @return \Mnm\SignatureType
     */
    public function setSignatureValue(\Mnm\SignatureValueType $signatureValue = null)
    {
        $this->SignatureValue = $signatureValue;
        return $this;
    }
    /**
     * Get KeyInfo value
     * @return \Mnm\KeyInfoType|null
     */
    public function getKeyInfo()
    {
        return $this->KeyInfo;
    }
    /**
     * Set KeyInfo value
     * @param \Mnm\KeyInfoType $keyInfo
     * @return \Mnm\SignatureType
     */
    public function setKeyInfo(\Mnm\KeyInfoType $keyInfo = null)
    {
        $this->KeyInfo = $keyInfo;
        return $this;
    }
    /**
     * Get Object value
     * @return \Mnm\ObjectType[]|null
     */
    public function getObject()
    {
        return $this->Object;
    }
    /**
     * Set Object value
     * @param \Mnm\ObjectType[] $object
     * @return \Mnm\SignatureType
     */
    public function setObject(array $object = array())
    {
        $this->Object = $object;
        return $this;
    }
    /**
     * Add item to Object value
     * @throws \InvalidArgumentException
     * @param \Mnm\ObjectType $item
     * @return \Mnm\SignatureType
     */
    public function addToObject(\Mnm\ObjectType $item)
    {
        $this->Object[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Mnm\SignatureType
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ID value
     * @return \Mnm\IDType|null
     */
    public function getID_1()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Mnm\IDType $iD
     * @return \Mnm\SignatureType
     */
    public function setID_1(\Mnm\IDType $iD_1 = null)
    {
        $this->ID = $iD_1;
        return $this;
    }
    /**
     * Get SignatoryParty value
     * @return \Mnm\PartyType|null
     */
    public function getSignatoryParty()
    {
        return $this->SignatoryParty;
    }
    /**
     * Set SignatoryParty value
     * @param \Mnm\PartyType $signatoryParty
     * @return \Mnm\SignatureType
     */
    public function setSignatoryParty(\Mnm\PartyType $signatoryParty = null)
    {
        $this->SignatoryParty = $signatoryParty;
        return $this;
    }
    /**
     * Get DigitalSignatureAttachment value
     * @return \Mnm\AttachmentType|null
     */
    public function getDigitalSignatureAttachment()
    {
        return $this->DigitalSignatureAttachment;
    }
    /**
     * Set DigitalSignatureAttachment value
     * @param \Mnm\AttachmentType $digitalSignatureAttachment
     * @return \Mnm\SignatureType
     */
    public function setDigitalSignatureAttachment(\Mnm\AttachmentType $digitalSignatureAttachment = null)
    {
        $this->DigitalSignatureAttachment = $digitalSignatureAttachment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\SignatureType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
