<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaveAsDraft StructType
 * @subpackage Structs
 */
class SaveAsDraft extends AbstractStructBase
{
    /**
     * The userInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\UserInformation
     */
    public $userInfo;
    /**
     * The invoices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\ArrayOfInvoiceInfo
     */
    public $invoices;
    /**
     * Constructor method for SaveAsDraft
     * @uses SaveAsDraft::setUserInfo()
     * @uses SaveAsDraft::setInvoices()
     * @param \Mnm\UserInformation $userInfo
     * @param \Mnm\ArrayOfInvoiceInfo $invoices
     */
    public function __construct(\Mnm\UserInformation $userInfo = null, \Mnm\ArrayOfInvoiceInfo $invoices = null)
    {
        $this
            ->setUserInfo($userInfo)
            ->setInvoices($invoices);
    }
    /**
     * Get userInfo value
     * @return \Mnm\UserInformation|null
     */
    public function getUserInfo()
    {
        return $this->userInfo;
    }
    /**
     * Set userInfo value
     * @param \Mnm\UserInformation $userInfo
     * @return \Mnm\SaveAsDraft
     */
    public function setUserInfo(\Mnm\UserInformation $userInfo = null)
    {
        $this->userInfo = $userInfo;
        return $this;
    }
    /**
     * Get invoices value
     * @return \Mnm\ArrayOfInvoiceInfo|null
     */
    public function getInvoices()
    {
        return $this->invoices;
    }
    /**
     * Set invoices value
     * @param \Mnm\ArrayOfInvoiceInfo $invoices
     * @return \Mnm\SaveAsDraft
     */
    public function setInvoices(\Mnm\ArrayOfInvoiceInfo $invoices = null)
    {
        $this->invoices = $invoices;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\SaveAsDraft
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
