<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueueInvoiceNotificationRequest StructType
 * @subpackage Structs
 */
class QueueInvoiceNotificationRequest extends AbstractStructBase
{
    /**
     * The Mailing
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\MailingInformation[]
     */
    public $Mailing;
    /**
     * The Messaging
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\SmsMessageInformation[]
     */
    public $Messaging;
    /**
     * The DocumentId
     * @var string
     */
    public $DocumentId;
    /**
     * Constructor method for QueueInvoiceNotificationRequest
     * @uses QueueInvoiceNotificationRequest::setMailing()
     * @uses QueueInvoiceNotificationRequest::setMessaging()
     * @uses QueueInvoiceNotificationRequest::setDocumentId()
     * @param \Mnm\MailingInformation[] $mailing
     * @param \Mnm\SmsMessageInformation[] $messaging
     * @param string $documentId
     */
    public function __construct(array $mailing = array(), array $messaging = array(), $documentId = null)
    {
        $this
            ->setMailing($mailing)
            ->setMessaging($messaging)
            ->setDocumentId($documentId);
    }
    /**
     * Get Mailing value
     * @return \Mnm\MailingInformation[]|null
     */
    public function getMailing()
    {
        return $this->Mailing;
    }
    /**
     * Set Mailing value
     * @param \Mnm\MailingInformation[] $mailing
     * @return \Mnm\QueueInvoiceNotificationRequest
     */
    public function setMailing(array $mailing = array())
    {
        $this->Mailing = $mailing;
        return $this;
    }
    /**
     * Add item to Mailing value
     * @throws \InvalidArgumentException
     * @param \Mnm\MailingInformation $item
     * @return \Mnm\QueueInvoiceNotificationRequest
     */
    public function addToMailing(\Mnm\MailingInformation $item)
    {
        $this->Mailing[] = $item;
        return $this;
    }
    /**
     * Get Messaging value
     * @return \Mnm\SmsMessageInformation[]|null
     */
    public function getMessaging()
    {
        return $this->Messaging;
    }
    /**
     * Set Messaging value
     * @param \Mnm\SmsMessageInformation[] $messaging
     * @return \Mnm\QueueInvoiceNotificationRequest
     */
    public function setMessaging(array $messaging = array())
    {
        $this->Messaging = $messaging;
        return $this;
    }
    /**
     * Add item to Messaging value
     * @throws \InvalidArgumentException
     * @param \Mnm\SmsMessageInformation $item
     * @return \Mnm\QueueInvoiceNotificationRequest
     */
    public function addToMessaging(\Mnm\SmsMessageInformation $item)
    {
        $this->Messaging[] = $item;
        return $this;
    }
    /**
     * Get DocumentId value
     * @return string|null
     */
    public function getDocumentId()
    {
        return $this->DocumentId;
    }
    /**
     * Set DocumentId value
     * @param string $documentId
     * @return \Mnm\QueueInvoiceNotificationRequest
     */
    public function setDocumentId($documentId = null)
    {
        $this->DocumentId = $documentId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\QueueInvoiceNotificationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
