<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonType StructType
 * @subpackage Structs
 */
class PersonType extends AbstractStructBase
{
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q61:FirstName
     * @var \Mnm\FirstNameType
     */
    public $FirstName;
    /**
     * The FamilyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q62:FamilyName
     * @var \Mnm\FamilyNameType
     */
    public $FamilyName;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q63:Title
     * @var \Mnm\TitleType
     */
    public $Title;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q64:MiddleName
     * @var \Mnm\MiddleNameType
     */
    public $MiddleName;
    /**
     * The NameSuffix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q65:NameSuffix
     * @var \Mnm\NameSuffixType
     */
    public $NameSuffix;
    /**
     * The NationalityID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q66:NationalityID
     * @var \Mnm\NationalityIDType
     */
    public $NationalityID;
    /**
     * The FinancialAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\FinancialAccountType
     */
    public $FinancialAccount;
    /**
     * The IdentityDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\DocumentReferenceType
     */
    public $IdentityDocumentReference;
    /**
     * Constructor method for PersonType
     * @uses PersonType::setFirstName()
     * @uses PersonType::setFamilyName()
     * @uses PersonType::setTitle()
     * @uses PersonType::setMiddleName()
     * @uses PersonType::setNameSuffix()
     * @uses PersonType::setNationalityID()
     * @uses PersonType::setFinancialAccount()
     * @uses PersonType::setIdentityDocumentReference()
     * @param \Mnm\FirstNameType $firstName
     * @param \Mnm\FamilyNameType $familyName
     * @param \Mnm\TitleType $title
     * @param \Mnm\MiddleNameType $middleName
     * @param \Mnm\NameSuffixType $nameSuffix
     * @param \Mnm\NationalityIDType $nationalityID
     * @param \Mnm\FinancialAccountType $financialAccount
     * @param \Mnm\DocumentReferenceType $identityDocumentReference
     */
    public function __construct(\Mnm\FirstNameType $firstName = null, \Mnm\FamilyNameType $familyName = null, \Mnm\TitleType $title = null, \Mnm\MiddleNameType $middleName = null, \Mnm\NameSuffixType $nameSuffix = null, \Mnm\NationalityIDType $nationalityID = null, \Mnm\FinancialAccountType $financialAccount = null, \Mnm\DocumentReferenceType $identityDocumentReference = null)
    {
        $this
            ->setFirstName($firstName)
            ->setFamilyName($familyName)
            ->setTitle($title)
            ->setMiddleName($middleName)
            ->setNameSuffix($nameSuffix)
            ->setNationalityID($nationalityID)
            ->setFinancialAccount($financialAccount)
            ->setIdentityDocumentReference($identityDocumentReference);
    }
    /**
     * Get FirstName value
     * @return \Mnm\FirstNameType|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param \Mnm\FirstNameType $firstName
     * @return \Mnm\PersonType
     */
    public function setFirstName(\Mnm\FirstNameType $firstName = null)
    {
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get FamilyName value
     * @return \Mnm\FamilyNameType|null
     */
    public function getFamilyName()
    {
        return $this->FamilyName;
    }
    /**
     * Set FamilyName value
     * @param \Mnm\FamilyNameType $familyName
     * @return \Mnm\PersonType
     */
    public function setFamilyName(\Mnm\FamilyNameType $familyName = null)
    {
        $this->FamilyName = $familyName;
        return $this;
    }
    /**
     * Get Title value
     * @return \Mnm\TitleType|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param \Mnm\TitleType $title
     * @return \Mnm\PersonType
     */
    public function setTitle(\Mnm\TitleType $title = null)
    {
        $this->Title = $title;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return \Mnm\MiddleNameType|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param \Mnm\MiddleNameType $middleName
     * @return \Mnm\PersonType
     */
    public function setMiddleName(\Mnm\MiddleNameType $middleName = null)
    {
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get NameSuffix value
     * @return \Mnm\NameSuffixType|null
     */
    public function getNameSuffix()
    {
        return $this->NameSuffix;
    }
    /**
     * Set NameSuffix value
     * @param \Mnm\NameSuffixType $nameSuffix
     * @return \Mnm\PersonType
     */
    public function setNameSuffix(\Mnm\NameSuffixType $nameSuffix = null)
    {
        $this->NameSuffix = $nameSuffix;
        return $this;
    }
    /**
     * Get NationalityID value
     * @return \Mnm\NationalityIDType|null
     */
    public function getNationalityID()
    {
        return $this->NationalityID;
    }
    /**
     * Set NationalityID value
     * @param \Mnm\NationalityIDType $nationalityID
     * @return \Mnm\PersonType
     */
    public function setNationalityID(\Mnm\NationalityIDType $nationalityID = null)
    {
        $this->NationalityID = $nationalityID;
        return $this;
    }
    /**
     * Get FinancialAccount value
     * @return \Mnm\FinancialAccountType|null
     */
    public function getFinancialAccount()
    {
        return $this->FinancialAccount;
    }
    /**
     * Set FinancialAccount value
     * @param \Mnm\FinancialAccountType $financialAccount
     * @return \Mnm\PersonType
     */
    public function setFinancialAccount(\Mnm\FinancialAccountType $financialAccount = null)
    {
        $this->FinancialAccount = $financialAccount;
        return $this;
    }
    /**
     * Get IdentityDocumentReference value
     * @return \Mnm\DocumentReferenceType|null
     */
    public function getIdentityDocumentReference()
    {
        return $this->IdentityDocumentReference;
    }
    /**
     * Set IdentityDocumentReference value
     * @param \Mnm\DocumentReferenceType $identityDocumentReference
     * @return \Mnm\PersonType
     */
    public function setIdentityDocumentReference(\Mnm\DocumentReferenceType $identityDocumentReference = null)
    {
        $this->IdentityDocumentReference = $identityDocumentReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\PersonType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
