<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartyType StructType
 * @subpackage Structs
 */
class PartyType extends AbstractStructBase
{
    /**
     * The WebsiteURI
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q18:WebsiteURI
     * @var \Mnm\WebsiteURIType
     */
    public $WebsiteURI;
    /**
     * The EndpointID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q19:EndpointID
     * @var \Mnm\EndpointIDType
     */
    public $EndpointID;
    /**
     * The IndustryClassificationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q20:IndustryClassificationCode
     * @var \Mnm\IndustryClassificationCodeType
     */
    public $IndustryClassificationCode;
    /**
     * The PartyIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\PartyIdentificationType[]
     */
    public $PartyIdentification;
    /**
     * The PartyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\PartyNameType
     */
    public $PartyName;
    /**
     * The PostalAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\AddressType
     */
    public $PostalAddress;
    /**
     * The PhysicalLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\LocationType
     */
    public $PhysicalLocation;
    /**
     * The PartyTaxScheme
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\PartyTaxSchemeType
     */
    public $PartyTaxScheme;
    /**
     * The PartyLegalEntity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\PartyLegalEntityType[]
     */
    public $PartyLegalEntity;
    /**
     * The Contact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\ContactType
     */
    public $Contact;
    /**
     * The Person
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\PersonType
     */
    public $Person;
    /**
     * The AgentParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\PartyType
     */
    public $AgentParty;
    /**
     * Constructor method for PartyType
     * @uses PartyType::setWebsiteURI()
     * @uses PartyType::setEndpointID()
     * @uses PartyType::setIndustryClassificationCode()
     * @uses PartyType::setPartyIdentification()
     * @uses PartyType::setPartyName()
     * @uses PartyType::setPostalAddress()
     * @uses PartyType::setPhysicalLocation()
     * @uses PartyType::setPartyTaxScheme()
     * @uses PartyType::setPartyLegalEntity()
     * @uses PartyType::setContact()
     * @uses PartyType::setPerson()
     * @uses PartyType::setAgentParty()
     * @param \Mnm\WebsiteURIType $websiteURI
     * @param \Mnm\EndpointIDType $endpointID
     * @param \Mnm\IndustryClassificationCodeType $industryClassificationCode
     * @param \Mnm\PartyIdentificationType[] $partyIdentification
     * @param \Mnm\PartyNameType $partyName
     * @param \Mnm\AddressType $postalAddress
     * @param \Mnm\LocationType $physicalLocation
     * @param \Mnm\PartyTaxSchemeType $partyTaxScheme
     * @param \Mnm\PartyLegalEntityType[] $partyLegalEntity
     * @param \Mnm\ContactType $contact
     * @param \Mnm\PersonType $person
     * @param \Mnm\PartyType $agentParty
     */
    public function __construct(\Mnm\WebsiteURIType $websiteURI = null, \Mnm\EndpointIDType $endpointID = null, \Mnm\IndustryClassificationCodeType $industryClassificationCode = null, array $partyIdentification = array(), \Mnm\PartyNameType $partyName = null, \Mnm\AddressType $postalAddress = null, \Mnm\LocationType $physicalLocation = null, \Mnm\PartyTaxSchemeType $partyTaxScheme = null, array $partyLegalEntity = array(), \Mnm\ContactType $contact = null, \Mnm\PersonType $person = null, \Mnm\PartyType $agentParty = null)
    {
        $this
            ->setWebsiteURI($websiteURI)
            ->setEndpointID($endpointID)
            ->setIndustryClassificationCode($industryClassificationCode)
            ->setPartyIdentification($partyIdentification)
            ->setPartyName($partyName)
            ->setPostalAddress($postalAddress)
            ->setPhysicalLocation($physicalLocation)
            ->setPartyTaxScheme($partyTaxScheme)
            ->setPartyLegalEntity($partyLegalEntity)
            ->setContact($contact)
            ->setPerson($person)
            ->setAgentParty($agentParty);
    }
    /**
     * Get WebsiteURI value
     * @return \Mnm\WebsiteURIType|null
     */
    public function getWebsiteURI()
    {
        return $this->WebsiteURI;
    }
    /**
     * Set WebsiteURI value
     * @param \Mnm\WebsiteURIType $websiteURI
     * @return \Mnm\PartyType
     */
    public function setWebsiteURI(\Mnm\WebsiteURIType $websiteURI = null)
    {
        $this->WebsiteURI = $websiteURI;
        return $this;
    }
    /**
     * Get EndpointID value
     * @return \Mnm\EndpointIDType|null
     */
    public function getEndpointID()
    {
        return $this->EndpointID;
    }
    /**
     * Set EndpointID value
     * @param \Mnm\EndpointIDType $endpointID
     * @return \Mnm\PartyType
     */
    public function setEndpointID(\Mnm\EndpointIDType $endpointID = null)
    {
        $this->EndpointID = $endpointID;
        return $this;
    }
    /**
     * Get IndustryClassificationCode value
     * @return \Mnm\IndustryClassificationCodeType|null
     */
    public function getIndustryClassificationCode()
    {
        return $this->IndustryClassificationCode;
    }
    /**
     * Set IndustryClassificationCode value
     * @param \Mnm\IndustryClassificationCodeType $industryClassificationCode
     * @return \Mnm\PartyType
     */
    public function setIndustryClassificationCode(\Mnm\IndustryClassificationCodeType $industryClassificationCode = null)
    {
        $this->IndustryClassificationCode = $industryClassificationCode;
        return $this;
    }
    /**
     * Get PartyIdentification value
     * @return \Mnm\PartyIdentificationType[]|null
     */
    public function getPartyIdentification()
    {
        return $this->PartyIdentification;
    }
    /**
     * Set PartyIdentification value
     * @param \Mnm\PartyIdentificationType[] $partyIdentification
     * @return \Mnm\PartyType
     */
    public function setPartyIdentification(array $partyIdentification = array())
    {
        $this->PartyIdentification = $partyIdentification;
        return $this;
    }
    /**
     * Add item to PartyIdentification value
     * @throws \InvalidArgumentException
     * @param \Mnm\PartyIdentificationType $item
     * @return \Mnm\PartyType
     */
    public function addToPartyIdentification(\Mnm\PartyIdentificationType $item)
    {
        $this->PartyIdentification[] = $item;
        return $this;
    }
    /**
     * Get PartyName value
     * @return \Mnm\PartyNameType|null
     */
    public function getPartyName()
    {
        return $this->PartyName;
    }
    /**
     * Set PartyName value
     * @param \Mnm\PartyNameType $partyName
     * @return \Mnm\PartyType
     */
    public function setPartyName(\Mnm\PartyNameType $partyName = null)
    {
        $this->PartyName = $partyName;
        return $this;
    }
    /**
     * Get PostalAddress value
     * @return \Mnm\AddressType|null
     */
    public function getPostalAddress()
    {
        return $this->PostalAddress;
    }
    /**
     * Set PostalAddress value
     * @param \Mnm\AddressType $postalAddress
     * @return \Mnm\PartyType
     */
    public function setPostalAddress(\Mnm\AddressType $postalAddress = null)
    {
        $this->PostalAddress = $postalAddress;
        return $this;
    }
    /**
     * Get PhysicalLocation value
     * @return \Mnm\LocationType|null
     */
    public function getPhysicalLocation()
    {
        return $this->PhysicalLocation;
    }
    /**
     * Set PhysicalLocation value
     * @param \Mnm\LocationType $physicalLocation
     * @return \Mnm\PartyType
     */
    public function setPhysicalLocation(\Mnm\LocationType $physicalLocation = null)
    {
        $this->PhysicalLocation = $physicalLocation;
        return $this;
    }
    /**
     * Get PartyTaxScheme value
     * @return \Mnm\PartyTaxSchemeType|null
     */
    public function getPartyTaxScheme()
    {
        return $this->PartyTaxScheme;
    }
    /**
     * Set PartyTaxScheme value
     * @param \Mnm\PartyTaxSchemeType $partyTaxScheme
     * @return \Mnm\PartyType
     */
    public function setPartyTaxScheme(\Mnm\PartyTaxSchemeType $partyTaxScheme = null)
    {
        $this->PartyTaxScheme = $partyTaxScheme;
        return $this;
    }
    /**
     * Get PartyLegalEntity value
     * @return \Mnm\PartyLegalEntityType[]|null
     */
    public function getPartyLegalEntity()
    {
        return $this->PartyLegalEntity;
    }
    /**
     * Set PartyLegalEntity value
     * @param \Mnm\PartyLegalEntityType[] $partyLegalEntity
     * @return \Mnm\PartyType
     */
    public function setPartyLegalEntity(array $partyLegalEntity = array())
    {
        $this->PartyLegalEntity = $partyLegalEntity;
        return $this;
    }
    /**
     * Add item to PartyLegalEntity value
     * @throws \InvalidArgumentException
     * @param \Mnm\PartyLegalEntityType $item
     * @return \Mnm\PartyType
     */
    public function addToPartyLegalEntity(\Mnm\PartyLegalEntityType $item)
    {
        $this->PartyLegalEntity[] = $item;
        return $this;
    }
    /**
     * Get Contact value
     * @return \Mnm\ContactType|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \Mnm\ContactType $contact
     * @return \Mnm\PartyType
     */
    public function setContact(\Mnm\ContactType $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get Person value
     * @return \Mnm\PersonType|null
     */
    public function getPerson()
    {
        return $this->Person;
    }
    /**
     * Set Person value
     * @param \Mnm\PersonType $person
     * @return \Mnm\PartyType
     */
    public function setPerson(\Mnm\PersonType $person = null)
    {
        $this->Person = $person;
        return $this;
    }
    /**
     * Get AgentParty value
     * @return \Mnm\PartyType|null
     */
    public function getAgentParty()
    {
        return $this->AgentParty;
    }
    /**
     * Set AgentParty value
     * @param \Mnm\PartyType $agentParty
     * @return \Mnm\PartyType
     */
    public function setAgentParty(\Mnm\PartyType $agentParty = null)
    {
        $this->AgentParty = $agentParty;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\PartyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
