<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PGPDataType StructType
 * @subpackage Structs
 */
class PGPDataType extends AbstractStructBase
{
    /**
     * The PGPKeyID
     * Meta information extracted from the WSDL
     * - choice: PGPKeyID | PGPKeyPacket |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PGPKeyID;
    /**
     * The PGPKeyPacket
     * Meta information extracted from the WSDL
     * - choice: PGPKeyID | PGPKeyPacket |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PGPKeyPacket;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for PGPDataType
     * @uses PGPDataType::setPGPKeyID()
     * @uses PGPDataType::setPGPKeyPacket()
     * @uses PGPDataType::setAny()
     * @param string $pGPKeyID
     * @param string $pGPKeyPacket
     * @param \DOMDocument $any
     */
    public function __construct($pGPKeyID = null, $pGPKeyPacket = null, \DOMDocument $any = null)
    {
        $this
            ->setPGPKeyID($pGPKeyID)
            ->setPGPKeyPacket($pGPKeyPacket)
            ->setAny($any);
    }
    /**
     * Get PGPKeyID value
     * @return string|null
     */
    public function getPGPKeyID()
    {
        return isset($this->PGPKeyID) ? $this->PGPKeyID : null;
    }
    /**
     * Set PGPKeyID value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $pGPKeyID
     * @return \Mnm\PGPDataType
     */
    public function setPGPKeyID($pGPKeyID = null)
    {
        if (is_null($pGPKeyID) || (is_array($pGPKeyID) && empty($pGPKeyID))) {
            unset($this->PGPKeyID);
        } else {
            $this->PGPKeyID = $pGPKeyID;
        }
        return $this;
    }
    /**
     * Get PGPKeyPacket value
     * @return string|null
     */
    public function getPGPKeyPacket()
    {
        return isset($this->PGPKeyPacket) ? $this->PGPKeyPacket : null;
    }
    /**
     * Set PGPKeyPacket value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $pGPKeyPacket
     * @return \Mnm\PGPDataType
     */
    public function setPGPKeyPacket($pGPKeyPacket = null)
    {
        if (is_null($pGPKeyPacket) || (is_array($pGPKeyPacket) && empty($pGPKeyPacket))) {
            unset($this->PGPKeyPacket);
        } else {
            $this->PGPKeyPacket = $pGPKeyPacket;
        }
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \Mnm\PGPDataType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\PGPDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
