<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderLineReferenceType StructType
 * @subpackage Structs
 */
class OrderLineReferenceType extends AbstractStructBase
{
    /**
     * The LineID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q171:LineID
     * @var \Mnm\LineIDType
     */
    public $LineID;
    /**
     * The SalesOrderLineID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q172:SalesOrderLineID
     * @var \Mnm\SalesOrderLineIDType
     */
    public $SalesOrderLineID;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q173:UUID
     * @var \Mnm\UUIDType
     */
    public $UUID;
    /**
     * The LineStatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q174:LineStatusCode
     * @var \Mnm\LineStatusCodeType
     */
    public $LineStatusCode;
    /**
     * The OrderReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\OrderReferenceType
     */
    public $OrderReference;
    /**
     * Constructor method for OrderLineReferenceType
     * @uses OrderLineReferenceType::setLineID()
     * @uses OrderLineReferenceType::setSalesOrderLineID()
     * @uses OrderLineReferenceType::setUUID()
     * @uses OrderLineReferenceType::setLineStatusCode()
     * @uses OrderLineReferenceType::setOrderReference()
     * @param \Mnm\LineIDType $lineID
     * @param \Mnm\SalesOrderLineIDType $salesOrderLineID
     * @param \Mnm\UUIDType $uUID
     * @param \Mnm\LineStatusCodeType $lineStatusCode
     * @param \Mnm\OrderReferenceType $orderReference
     */
    public function __construct(\Mnm\LineIDType $lineID = null, \Mnm\SalesOrderLineIDType $salesOrderLineID = null, \Mnm\UUIDType $uUID = null, \Mnm\LineStatusCodeType $lineStatusCode = null, \Mnm\OrderReferenceType $orderReference = null)
    {
        $this
            ->setLineID($lineID)
            ->setSalesOrderLineID($salesOrderLineID)
            ->setUUID($uUID)
            ->setLineStatusCode($lineStatusCode)
            ->setOrderReference($orderReference);
    }
    /**
     * Get LineID value
     * @return \Mnm\LineIDType|null
     */
    public function getLineID()
    {
        return $this->LineID;
    }
    /**
     * Set LineID value
     * @param \Mnm\LineIDType $lineID
     * @return \Mnm\OrderLineReferenceType
     */
    public function setLineID(\Mnm\LineIDType $lineID = null)
    {
        $this->LineID = $lineID;
        return $this;
    }
    /**
     * Get SalesOrderLineID value
     * @return \Mnm\SalesOrderLineIDType|null
     */
    public function getSalesOrderLineID()
    {
        return $this->SalesOrderLineID;
    }
    /**
     * Set SalesOrderLineID value
     * @param \Mnm\SalesOrderLineIDType $salesOrderLineID
     * @return \Mnm\OrderLineReferenceType
     */
    public function setSalesOrderLineID(\Mnm\SalesOrderLineIDType $salesOrderLineID = null)
    {
        $this->SalesOrderLineID = $salesOrderLineID;
        return $this;
    }
    /**
     * Get UUID value
     * @return \Mnm\UUIDType|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param \Mnm\UUIDType $uUID
     * @return \Mnm\OrderLineReferenceType
     */
    public function setUUID(\Mnm\UUIDType $uUID = null)
    {
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get LineStatusCode value
     * @return \Mnm\LineStatusCodeType|null
     */
    public function getLineStatusCode()
    {
        return $this->LineStatusCode;
    }
    /**
     * Set LineStatusCode value
     * @param \Mnm\LineStatusCodeType $lineStatusCode
     * @return \Mnm\OrderLineReferenceType
     */
    public function setLineStatusCode(\Mnm\LineStatusCodeType $lineStatusCode = null)
    {
        $this->LineStatusCode = $lineStatusCode;
        return $this;
    }
    /**
     * Get OrderReference value
     * @return \Mnm\OrderReferenceType|null
     */
    public function getOrderReference()
    {
        return $this->OrderReference;
    }
    /**
     * Set OrderReference value
     * @param \Mnm\OrderReferenceType $orderReference
     * @return \Mnm\OrderLineReferenceType
     */
    public function setOrderReference(\Mnm\OrderReferenceType $orderReference = null)
    {
        $this->OrderReference = $orderReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\OrderLineReferenceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
