<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MaritimeTransportType StructType
 * @subpackage Structs
 */
class MaritimeTransportType extends AbstractStructBase
{
    /**
     * The VesselID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q209:VesselID
     * @var \Mnm\VesselIDType
     */
    public $VesselID;
    /**
     * The VesselName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q210:VesselName
     * @var \Mnm\VesselNameType
     */
    public $VesselName;
    /**
     * The RadioCallSignID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q211:RadioCallSignID
     * @var \Mnm\RadioCallSignIDType
     */
    public $RadioCallSignID;
    /**
     * The ShipsRequirements
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q212:ShipsRequirements
     * @var \Mnm\ShipsRequirementsType[]
     */
    public $ShipsRequirements;
    /**
     * The GrossTonnageMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q213:GrossTonnageMeasure
     * @var \Mnm\GrossTonnageMeasureType
     */
    public $GrossTonnageMeasure;
    /**
     * The NetTonnageMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q214:NetTonnageMeasure
     * @var \Mnm\NetTonnageMeasureType
     */
    public $NetTonnageMeasure;
    /**
     * The RegistryCertificateDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\DocumentReferenceType
     */
    public $RegistryCertificateDocumentReference;
    /**
     * The RegistryPortLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\LocationType
     */
    public $RegistryPortLocation;
    /**
     * Constructor method for MaritimeTransportType
     * @uses MaritimeTransportType::setVesselID()
     * @uses MaritimeTransportType::setVesselName()
     * @uses MaritimeTransportType::setRadioCallSignID()
     * @uses MaritimeTransportType::setShipsRequirements()
     * @uses MaritimeTransportType::setGrossTonnageMeasure()
     * @uses MaritimeTransportType::setNetTonnageMeasure()
     * @uses MaritimeTransportType::setRegistryCertificateDocumentReference()
     * @uses MaritimeTransportType::setRegistryPortLocation()
     * @param \Mnm\VesselIDType $vesselID
     * @param \Mnm\VesselNameType $vesselName
     * @param \Mnm\RadioCallSignIDType $radioCallSignID
     * @param \Mnm\ShipsRequirementsType[] $shipsRequirements
     * @param \Mnm\GrossTonnageMeasureType $grossTonnageMeasure
     * @param \Mnm\NetTonnageMeasureType $netTonnageMeasure
     * @param \Mnm\DocumentReferenceType $registryCertificateDocumentReference
     * @param \Mnm\LocationType $registryPortLocation
     */
    public function __construct(\Mnm\VesselIDType $vesselID = null, \Mnm\VesselNameType $vesselName = null, \Mnm\RadioCallSignIDType $radioCallSignID = null, array $shipsRequirements = array(), \Mnm\GrossTonnageMeasureType $grossTonnageMeasure = null, \Mnm\NetTonnageMeasureType $netTonnageMeasure = null, \Mnm\DocumentReferenceType $registryCertificateDocumentReference = null, \Mnm\LocationType $registryPortLocation = null)
    {
        $this
            ->setVesselID($vesselID)
            ->setVesselName($vesselName)
            ->setRadioCallSignID($radioCallSignID)
            ->setShipsRequirements($shipsRequirements)
            ->setGrossTonnageMeasure($grossTonnageMeasure)
            ->setNetTonnageMeasure($netTonnageMeasure)
            ->setRegistryCertificateDocumentReference($registryCertificateDocumentReference)
            ->setRegistryPortLocation($registryPortLocation);
    }
    /**
     * Get VesselID value
     * @return \Mnm\VesselIDType|null
     */
    public function getVesselID()
    {
        return $this->VesselID;
    }
    /**
     * Set VesselID value
     * @param \Mnm\VesselIDType $vesselID
     * @return \Mnm\MaritimeTransportType
     */
    public function setVesselID(\Mnm\VesselIDType $vesselID = null)
    {
        $this->VesselID = $vesselID;
        return $this;
    }
    /**
     * Get VesselName value
     * @return \Mnm\VesselNameType|null
     */
    public function getVesselName()
    {
        return $this->VesselName;
    }
    /**
     * Set VesselName value
     * @param \Mnm\VesselNameType $vesselName
     * @return \Mnm\MaritimeTransportType
     */
    public function setVesselName(\Mnm\VesselNameType $vesselName = null)
    {
        $this->VesselName = $vesselName;
        return $this;
    }
    /**
     * Get RadioCallSignID value
     * @return \Mnm\RadioCallSignIDType|null
     */
    public function getRadioCallSignID()
    {
        return $this->RadioCallSignID;
    }
    /**
     * Set RadioCallSignID value
     * @param \Mnm\RadioCallSignIDType $radioCallSignID
     * @return \Mnm\MaritimeTransportType
     */
    public function setRadioCallSignID(\Mnm\RadioCallSignIDType $radioCallSignID = null)
    {
        $this->RadioCallSignID = $radioCallSignID;
        return $this;
    }
    /**
     * Get ShipsRequirements value
     * @return \Mnm\ShipsRequirementsType[]|null
     */
    public function getShipsRequirements()
    {
        return $this->ShipsRequirements;
    }
    /**
     * Set ShipsRequirements value
     * @param \Mnm\ShipsRequirementsType[] $shipsRequirements
     * @return \Mnm\MaritimeTransportType
     */
    public function setShipsRequirements(array $shipsRequirements = array())
    {
        $this->ShipsRequirements = $shipsRequirements;
        return $this;
    }
    /**
     * Add item to ShipsRequirements value
     * @throws \InvalidArgumentException
     * @param \Mnm\ShipsRequirementsType $item
     * @return \Mnm\MaritimeTransportType
     */
    public function addToShipsRequirements(\Mnm\ShipsRequirementsType $item)
    {
        $this->ShipsRequirements[] = $item;
        return $this;
    }
    /**
     * Get GrossTonnageMeasure value
     * @return \Mnm\GrossTonnageMeasureType|null
     */
    public function getGrossTonnageMeasure()
    {
        return $this->GrossTonnageMeasure;
    }
    /**
     * Set GrossTonnageMeasure value
     * @param \Mnm\GrossTonnageMeasureType $grossTonnageMeasure
     * @return \Mnm\MaritimeTransportType
     */
    public function setGrossTonnageMeasure(\Mnm\GrossTonnageMeasureType $grossTonnageMeasure = null)
    {
        $this->GrossTonnageMeasure = $grossTonnageMeasure;
        return $this;
    }
    /**
     * Get NetTonnageMeasure value
     * @return \Mnm\NetTonnageMeasureType|null
     */
    public function getNetTonnageMeasure()
    {
        return $this->NetTonnageMeasure;
    }
    /**
     * Set NetTonnageMeasure value
     * @param \Mnm\NetTonnageMeasureType $netTonnageMeasure
     * @return \Mnm\MaritimeTransportType
     */
    public function setNetTonnageMeasure(\Mnm\NetTonnageMeasureType $netTonnageMeasure = null)
    {
        $this->NetTonnageMeasure = $netTonnageMeasure;
        return $this;
    }
    /**
     * Get RegistryCertificateDocumentReference value
     * @return \Mnm\DocumentReferenceType|null
     */
    public function getRegistryCertificateDocumentReference()
    {
        return $this->RegistryCertificateDocumentReference;
    }
    /**
     * Set RegistryCertificateDocumentReference value
     * @param \Mnm\DocumentReferenceType $registryCertificateDocumentReference
     * @return \Mnm\MaritimeTransportType
     */
    public function setRegistryCertificateDocumentReference(\Mnm\DocumentReferenceType $registryCertificateDocumentReference = null)
    {
        $this->RegistryCertificateDocumentReference = $registryCertificateDocumentReference;
        return $this;
    }
    /**
     * Get RegistryPortLocation value
     * @return \Mnm\LocationType|null
     */
    public function getRegistryPortLocation()
    {
        return $this->RegistryPortLocation;
    }
    /**
     * Set RegistryPortLocation value
     * @param \Mnm\LocationType $registryPortLocation
     * @return \Mnm\MaritimeTransportType
     */
    public function setRegistryPortLocation(\Mnm\LocationType $registryPortLocation = null)
    {
        $this->RegistryPortLocation = $registryPortLocation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\MaritimeTransportType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
