<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KeyValueType StructType
 * Meta information extracted from the WSDL
 * - mixed: true
 * @subpackage Structs
 */
class KeyValueType extends AbstractStructBase
{
    /**
     * The DSAKeyValue
     * Meta information extracted from the WSDL
     * - choice: DSAKeyValue | RSAKeyValue |
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\DSAKeyValueType
     */
    public $DSAKeyValue;
    /**
     * The RSAKeyValue
     * Meta information extracted from the WSDL
     * - choice: DSAKeyValue | RSAKeyValue |
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\RSAKeyValueType
     */
    public $RSAKeyValue;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for KeyValueType
     * @uses KeyValueType::setDSAKeyValue()
     * @uses KeyValueType::setRSAKeyValue()
     * @uses KeyValueType::setAny()
     * @param \Mnm\DSAKeyValueType $dSAKeyValue
     * @param \Mnm\RSAKeyValueType $rSAKeyValue
     * @param \DOMDocument $any
     */
    public function __construct(\Mnm\DSAKeyValueType $dSAKeyValue = null, \Mnm\RSAKeyValueType $rSAKeyValue = null, \DOMDocument $any = null)
    {
        $this
            ->setDSAKeyValue($dSAKeyValue)
            ->setRSAKeyValue($rSAKeyValue)
            ->setAny($any);
    }
    /**
     * Get DSAKeyValue value
     * @return \Mnm\DSAKeyValueType|null
     */
    public function getDSAKeyValue()
    {
        return isset($this->DSAKeyValue) ? $this->DSAKeyValue : null;
    }
    /**
     * Set DSAKeyValue value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \Mnm\DSAKeyValueType $dSAKeyValue
     * @return \Mnm\KeyValueType
     */
    public function setDSAKeyValue(\Mnm\DSAKeyValueType $dSAKeyValue = null)
    {
        if (is_null($dSAKeyValue) || (is_array($dSAKeyValue) && empty($dSAKeyValue))) {
            unset($this->DSAKeyValue);
        } else {
            $this->DSAKeyValue = $dSAKeyValue;
        }
        return $this;
    }
    /**
     * Get RSAKeyValue value
     * @return \Mnm\RSAKeyValueType|null
     */
    public function getRSAKeyValue()
    {
        return isset($this->RSAKeyValue) ? $this->RSAKeyValue : null;
    }
    /**
     * Set RSAKeyValue value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \Mnm\RSAKeyValueType $rSAKeyValue
     * @return \Mnm\KeyValueType
     */
    public function setRSAKeyValue(\Mnm\RSAKeyValueType $rSAKeyValue = null)
    {
        if (is_null($rSAKeyValue) || (is_array($rSAKeyValue) && empty($rSAKeyValue))) {
            unset($this->RSAKeyValue);
        } else {
            $this->RSAKeyValue = $rSAKeyValue;
        }
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \Mnm\KeyValueType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\KeyValueType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
