<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KeyInfoType StructType
 * Meta information extracted from the WSDL
 * - mixed: true
 * @subpackage Structs
 */
class KeyInfoType extends AbstractStructBase
{
    /**
     * The X509Data
     * Meta information extracted from the WSDL
     * - choice: X509Data | MgmtData | RetrievalMethod | PGPData | KeyValue | SPKIData | KeyName |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\X509DataType
     */
    public $X509Data;
    /**
     * The MgmtData
     * Meta information extracted from the WSDL
     * - choice: X509Data | MgmtData | RetrievalMethod | PGPData | KeyValue | SPKIData | KeyName |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MgmtData;
    /**
     * The RetrievalMethod
     * Meta information extracted from the WSDL
     * - choice: X509Data | MgmtData | RetrievalMethod | PGPData | KeyValue | SPKIData | KeyName |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\RetrievalMethodType
     */
    public $RetrievalMethod;
    /**
     * The PGPData
     * Meta information extracted from the WSDL
     * - choice: X509Data | MgmtData | RetrievalMethod | PGPData | KeyValue | SPKIData | KeyName |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\PGPDataType
     */
    public $PGPData;
    /**
     * The KeyValue
     * Meta information extracted from the WSDL
     * - choice: X509Data | MgmtData | RetrievalMethod | PGPData | KeyValue | SPKIData | KeyName |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\KeyValueType
     */
    public $KeyValue;
    /**
     * The SPKIData
     * Meta information extracted from the WSDL
     * - choice: X509Data | MgmtData | RetrievalMethod | PGPData | KeyValue | SPKIData | KeyName |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\SPKIDataType
     */
    public $SPKIData;
    /**
     * The KeyName
     * Meta information extracted from the WSDL
     * - choice: X509Data | MgmtData | RetrievalMethod | PGPData | KeyValue | SPKIData | KeyName |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KeyName;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The Id
     * @var string
     */
    public $Id;
    /**
     * Constructor method for KeyInfoType
     * @uses KeyInfoType::setX509Data()
     * @uses KeyInfoType::setMgmtData()
     * @uses KeyInfoType::setRetrievalMethod()
     * @uses KeyInfoType::setPGPData()
     * @uses KeyInfoType::setKeyValue()
     * @uses KeyInfoType::setSPKIData()
     * @uses KeyInfoType::setKeyName()
     * @uses KeyInfoType::setAny()
     * @uses KeyInfoType::setId()
     * @param \Mnm\X509DataType $x509Data
     * @param string $mgmtData
     * @param \Mnm\RetrievalMethodType $retrievalMethod
     * @param \Mnm\PGPDataType $pGPData
     * @param \Mnm\KeyValueType $keyValue
     * @param \Mnm\SPKIDataType $sPKIData
     * @param string $keyName
     * @param \DOMDocument $any
     * @param string $id
     */
    public function __construct(\Mnm\X509DataType $x509Data = null, $mgmtData = null, \Mnm\RetrievalMethodType $retrievalMethod = null, \Mnm\PGPDataType $pGPData = null, \Mnm\KeyValueType $keyValue = null, \Mnm\SPKIDataType $sPKIData = null, $keyName = null, \DOMDocument $any = null, $id = null)
    {
        $this
            ->setX509Data($x509Data)
            ->setMgmtData($mgmtData)
            ->setRetrievalMethod($retrievalMethod)
            ->setPGPData($pGPData)
            ->setKeyValue($keyValue)
            ->setSPKIData($sPKIData)
            ->setKeyName($keyName)
            ->setAny($any)
            ->setId($id);
    }
    /**
     * Get X509Data value
     * @return \Mnm\X509DataType|null
     */
    public function getX509Data()
    {
        return isset($this->X509Data) ? $this->X509Data : null;
    }
    /**
     * Set X509Data value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \Mnm\X509DataType $x509Data
     * @return \Mnm\KeyInfoType
     */
    public function setX509Data(\Mnm\X509DataType $x509Data = null)
    {
        if (is_null($x509Data) || (is_array($x509Data) && empty($x509Data))) {
            unset($this->X509Data);
        } else {
            $this->X509Data = $x509Data;
        }
        return $this;
    }
    /**
     * Get MgmtData value
     * @return string|null
     */
    public function getMgmtData()
    {
        return isset($this->MgmtData) ? $this->MgmtData : null;
    }
    /**
     * Set MgmtData value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $mgmtData
     * @return \Mnm\KeyInfoType
     */
    public function setMgmtData($mgmtData = null)
    {
        if (is_null($mgmtData) || (is_array($mgmtData) && empty($mgmtData))) {
            unset($this->MgmtData);
        } else {
            $this->MgmtData = $mgmtData;
        }
        return $this;
    }
    /**
     * Get RetrievalMethod value
     * @return \Mnm\RetrievalMethodType|null
     */
    public function getRetrievalMethod()
    {
        return isset($this->RetrievalMethod) ? $this->RetrievalMethod : null;
    }
    /**
     * Set RetrievalMethod value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \Mnm\RetrievalMethodType $retrievalMethod
     * @return \Mnm\KeyInfoType
     */
    public function setRetrievalMethod(\Mnm\RetrievalMethodType $retrievalMethod = null)
    {
        if (is_null($retrievalMethod) || (is_array($retrievalMethod) && empty($retrievalMethod))) {
            unset($this->RetrievalMethod);
        } else {
            $this->RetrievalMethod = $retrievalMethod;
        }
        return $this;
    }
    /**
     * Get PGPData value
     * @return \Mnm\PGPDataType|null
     */
    public function getPGPData()
    {
        return isset($this->PGPData) ? $this->PGPData : null;
    }
    /**
     * Set PGPData value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \Mnm\PGPDataType $pGPData
     * @return \Mnm\KeyInfoType
     */
    public function setPGPData(\Mnm\PGPDataType $pGPData = null)
    {
        if (is_null($pGPData) || (is_array($pGPData) && empty($pGPData))) {
            unset($this->PGPData);
        } else {
            $this->PGPData = $pGPData;
        }
        return $this;
    }
    /**
     * Get KeyValue value
     * @return \Mnm\KeyValueType|null
     */
    public function getKeyValue()
    {
        return isset($this->KeyValue) ? $this->KeyValue : null;
    }
    /**
     * Set KeyValue value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \Mnm\KeyValueType $keyValue
     * @return \Mnm\KeyInfoType
     */
    public function setKeyValue(\Mnm\KeyValueType $keyValue = null)
    {
        if (is_null($keyValue) || (is_array($keyValue) && empty($keyValue))) {
            unset($this->KeyValue);
        } else {
            $this->KeyValue = $keyValue;
        }
        return $this;
    }
    /**
     * Get SPKIData value
     * @return \Mnm\SPKIDataType|null
     */
    public function getSPKIData()
    {
        return isset($this->SPKIData) ? $this->SPKIData : null;
    }
    /**
     * Set SPKIData value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \Mnm\SPKIDataType $sPKIData
     * @return \Mnm\KeyInfoType
     */
    public function setSPKIData(\Mnm\SPKIDataType $sPKIData = null)
    {
        if (is_null($sPKIData) || (is_array($sPKIData) && empty($sPKIData))) {
            unset($this->SPKIData);
        } else {
            $this->SPKIData = $sPKIData;
        }
        return $this;
    }
    /**
     * Get KeyName value
     * @return string|null
     */
    public function getKeyName()
    {
        return isset($this->KeyName) ? $this->KeyName : null;
    }
    /**
     * Set KeyName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $keyName
     * @return \Mnm\KeyInfoType
     */
    public function setKeyName($keyName = null)
    {
        if (is_null($keyName) || (is_array($keyName) && empty($keyName))) {
            unset($this->KeyName);
        } else {
            $this->KeyName = $keyName;
        }
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \Mnm\KeyInfoType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Mnm\KeyInfoType
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\KeyInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
