<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemType StructType
 * @subpackage Structs
 */
class ItemType extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q133:Description
     * @var \Mnm\DescriptionType
     */
    public $Description;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q134:Name
     * @var \Mnm\NameType
     */
    public $Name;
    /**
     * The Keyword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q135:Keyword
     * @var \Mnm\KeywordType
     */
    public $Keyword;
    /**
     * The BrandName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q136:BrandName
     * @var \Mnm\BrandNameType
     */
    public $BrandName;
    /**
     * The ModelName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q137:ModelName
     * @var \Mnm\ModelNameType
     */
    public $ModelName;
    /**
     * The BuyersItemIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\ItemIdentificationType
     */
    public $BuyersItemIdentification;
    /**
     * The SellersItemIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\ItemIdentificationType
     */
    public $SellersItemIdentification;
    /**
     * The ManufacturersItemIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\ItemIdentificationType
     */
    public $ManufacturersItemIdentification;
    /**
     * The AdditionalItemIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\ItemIdentificationType[]
     */
    public $AdditionalItemIdentification;
    /**
     * The OriginCountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\CountryType
     */
    public $OriginCountry;
    /**
     * The CommodityClassification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\CommodityClassificationType[]
     */
    public $CommodityClassification;
    /**
     * The ItemInstance
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\ItemInstanceType[]
     */
    public $ItemInstance;
    /**
     * Constructor method for ItemType
     * @uses ItemType::setDescription()
     * @uses ItemType::setName()
     * @uses ItemType::setKeyword()
     * @uses ItemType::setBrandName()
     * @uses ItemType::setModelName()
     * @uses ItemType::setBuyersItemIdentification()
     * @uses ItemType::setSellersItemIdentification()
     * @uses ItemType::setManufacturersItemIdentification()
     * @uses ItemType::setAdditionalItemIdentification()
     * @uses ItemType::setOriginCountry()
     * @uses ItemType::setCommodityClassification()
     * @uses ItemType::setItemInstance()
     * @param \Mnm\DescriptionType $description
     * @param \Mnm\NameType $name
     * @param \Mnm\KeywordType $keyword
     * @param \Mnm\BrandNameType $brandName
     * @param \Mnm\ModelNameType $modelName
     * @param \Mnm\ItemIdentificationType $buyersItemIdentification
     * @param \Mnm\ItemIdentificationType $sellersItemIdentification
     * @param \Mnm\ItemIdentificationType $manufacturersItemIdentification
     * @param \Mnm\ItemIdentificationType[] $additionalItemIdentification
     * @param \Mnm\CountryType $originCountry
     * @param \Mnm\CommodityClassificationType[] $commodityClassification
     * @param \Mnm\ItemInstanceType[] $itemInstance
     */
    public function __construct(\Mnm\DescriptionType $description = null, \Mnm\NameType $name = null, \Mnm\KeywordType $keyword = null, \Mnm\BrandNameType $brandName = null, \Mnm\ModelNameType $modelName = null, \Mnm\ItemIdentificationType $buyersItemIdentification = null, \Mnm\ItemIdentificationType $sellersItemIdentification = null, \Mnm\ItemIdentificationType $manufacturersItemIdentification = null, array $additionalItemIdentification = array(), \Mnm\CountryType $originCountry = null, array $commodityClassification = array(), array $itemInstance = array())
    {
        $this
            ->setDescription($description)
            ->setName($name)
            ->setKeyword($keyword)
            ->setBrandName($brandName)
            ->setModelName($modelName)
            ->setBuyersItemIdentification($buyersItemIdentification)
            ->setSellersItemIdentification($sellersItemIdentification)
            ->setManufacturersItemIdentification($manufacturersItemIdentification)
            ->setAdditionalItemIdentification($additionalItemIdentification)
            ->setOriginCountry($originCountry)
            ->setCommodityClassification($commodityClassification)
            ->setItemInstance($itemInstance);
    }
    /**
     * Get Description value
     * @return \Mnm\DescriptionType|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \Mnm\DescriptionType $description
     * @return \Mnm\ItemType
     */
    public function setDescription(\Mnm\DescriptionType $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Name value
     * @return \Mnm\NameType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \Mnm\NameType $name
     * @return \Mnm\ItemType
     */
    public function setName(\Mnm\NameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Keyword value
     * @return \Mnm\KeywordType|null
     */
    public function getKeyword()
    {
        return $this->Keyword;
    }
    /**
     * Set Keyword value
     * @param \Mnm\KeywordType $keyword
     * @return \Mnm\ItemType
     */
    public function setKeyword(\Mnm\KeywordType $keyword = null)
    {
        $this->Keyword = $keyword;
        return $this;
    }
    /**
     * Get BrandName value
     * @return \Mnm\BrandNameType|null
     */
    public function getBrandName()
    {
        return $this->BrandName;
    }
    /**
     * Set BrandName value
     * @param \Mnm\BrandNameType $brandName
     * @return \Mnm\ItemType
     */
    public function setBrandName(\Mnm\BrandNameType $brandName = null)
    {
        $this->BrandName = $brandName;
        return $this;
    }
    /**
     * Get ModelName value
     * @return \Mnm\ModelNameType|null
     */
    public function getModelName()
    {
        return $this->ModelName;
    }
    /**
     * Set ModelName value
     * @param \Mnm\ModelNameType $modelName
     * @return \Mnm\ItemType
     */
    public function setModelName(\Mnm\ModelNameType $modelName = null)
    {
        $this->ModelName = $modelName;
        return $this;
    }
    /**
     * Get BuyersItemIdentification value
     * @return \Mnm\ItemIdentificationType|null
     */
    public function getBuyersItemIdentification()
    {
        return $this->BuyersItemIdentification;
    }
    /**
     * Set BuyersItemIdentification value
     * @param \Mnm\ItemIdentificationType $buyersItemIdentification
     * @return \Mnm\ItemType
     */
    public function setBuyersItemIdentification(\Mnm\ItemIdentificationType $buyersItemIdentification = null)
    {
        $this->BuyersItemIdentification = $buyersItemIdentification;
        return $this;
    }
    /**
     * Get SellersItemIdentification value
     * @return \Mnm\ItemIdentificationType|null
     */
    public function getSellersItemIdentification()
    {
        return $this->SellersItemIdentification;
    }
    /**
     * Set SellersItemIdentification value
     * @param \Mnm\ItemIdentificationType $sellersItemIdentification
     * @return \Mnm\ItemType
     */
    public function setSellersItemIdentification(\Mnm\ItemIdentificationType $sellersItemIdentification = null)
    {
        $this->SellersItemIdentification = $sellersItemIdentification;
        return $this;
    }
    /**
     * Get ManufacturersItemIdentification value
     * @return \Mnm\ItemIdentificationType|null
     */
    public function getManufacturersItemIdentification()
    {
        return $this->ManufacturersItemIdentification;
    }
    /**
     * Set ManufacturersItemIdentification value
     * @param \Mnm\ItemIdentificationType $manufacturersItemIdentification
     * @return \Mnm\ItemType
     */
    public function setManufacturersItemIdentification(\Mnm\ItemIdentificationType $manufacturersItemIdentification = null)
    {
        $this->ManufacturersItemIdentification = $manufacturersItemIdentification;
        return $this;
    }
    /**
     * Get AdditionalItemIdentification value
     * @return \Mnm\ItemIdentificationType[]|null
     */
    public function getAdditionalItemIdentification()
    {
        return $this->AdditionalItemIdentification;
    }
    /**
     * Set AdditionalItemIdentification value
     * @param \Mnm\ItemIdentificationType[] $additionalItemIdentification
     * @return \Mnm\ItemType
     */
    public function setAdditionalItemIdentification(array $additionalItemIdentification = array())
    {
        $this->AdditionalItemIdentification = $additionalItemIdentification;
        return $this;
    }
    /**
     * Add item to AdditionalItemIdentification value
     * @throws \InvalidArgumentException
     * @param \Mnm\ItemIdentificationType $item
     * @return \Mnm\ItemType
     */
    public function addToAdditionalItemIdentification(\Mnm\ItemIdentificationType $item)
    {
        $this->AdditionalItemIdentification[] = $item;
        return $this;
    }
    /**
     * Get OriginCountry value
     * @return \Mnm\CountryType|null
     */
    public function getOriginCountry()
    {
        return $this->OriginCountry;
    }
    /**
     * Set OriginCountry value
     * @param \Mnm\CountryType $originCountry
     * @return \Mnm\ItemType
     */
    public function setOriginCountry(\Mnm\CountryType $originCountry = null)
    {
        $this->OriginCountry = $originCountry;
        return $this;
    }
    /**
     * Get CommodityClassification value
     * @return \Mnm\CommodityClassificationType[]|null
     */
    public function getCommodityClassification()
    {
        return $this->CommodityClassification;
    }
    /**
     * Set CommodityClassification value
     * @param \Mnm\CommodityClassificationType[] $commodityClassification
     * @return \Mnm\ItemType
     */
    public function setCommodityClassification(array $commodityClassification = array())
    {
        $this->CommodityClassification = $commodityClassification;
        return $this;
    }
    /**
     * Add item to CommodityClassification value
     * @throws \InvalidArgumentException
     * @param \Mnm\CommodityClassificationType $item
     * @return \Mnm\ItemType
     */
    public function addToCommodityClassification(\Mnm\CommodityClassificationType $item)
    {
        $this->CommodityClassification[] = $item;
        return $this;
    }
    /**
     * Get ItemInstance value
     * @return \Mnm\ItemInstanceType[]|null
     */
    public function getItemInstance()
    {
        return $this->ItemInstance;
    }
    /**
     * Set ItemInstance value
     * @param \Mnm\ItemInstanceType[] $itemInstance
     * @return \Mnm\ItemType
     */
    public function setItemInstance(array $itemInstance = array())
    {
        $this->ItemInstance = $itemInstance;
        return $this;
    }
    /**
     * Add item to ItemInstance value
     * @throws \InvalidArgumentException
     * @param \Mnm\ItemInstanceType $item
     * @return \Mnm\ItemType
     */
    public function addToItemInstance(\Mnm\ItemInstanceType $item)
    {
        $this->ItemInstance[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\ItemType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
