<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemPropertyType StructType
 * @subpackage Structs
 */
class ItemPropertyType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q146:ID
     * @var \Mnm\IDType
     */
    public $ID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q147:Name
     * @var \Mnm\NameType
     */
    public $Name;
    /**
     * The NameCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q148:NameCode
     * @var \Mnm\NameCodeType
     */
    public $NameCode;
    /**
     * The TestMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q149:TestMethod
     * @var \Mnm\TestMethodType
     */
    public $TestMethod;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q150:Value
     * @var \Mnm\ValueType
     */
    public $Value;
    /**
     * The ValueQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q151:ValueQuantity
     * @var \Mnm\ValueQuantityType
     */
    public $ValueQuantity;
    /**
     * The ValueQualifier
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q152:ValueQualifier
     * @var \Mnm\ValueQualifierType[]
     */
    public $ValueQualifier;
    /**
     * The ImportanceCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q153:ImportanceCode
     * @var \Mnm\ImportanceCodeType
     */
    public $ImportanceCode;
    /**
     * The ListValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q154:ListValue
     * @var \Mnm\ListValueType[]
     */
    public $ListValue;
    /**
     * The UsabilityPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\PeriodType
     */
    public $UsabilityPeriod;
    /**
     * The ItemPropertyGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\ItemPropertyGroupType[]
     */
    public $ItemPropertyGroup;
    /**
     * The RangeDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\DimensionType
     */
    public $RangeDimension;
    /**
     * The ItemPropertyRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\ItemPropertyRangeType
     */
    public $ItemPropertyRange;
    /**
     * Constructor method for ItemPropertyType
     * @uses ItemPropertyType::setID()
     * @uses ItemPropertyType::setName()
     * @uses ItemPropertyType::setNameCode()
     * @uses ItemPropertyType::setTestMethod()
     * @uses ItemPropertyType::setValue()
     * @uses ItemPropertyType::setValueQuantity()
     * @uses ItemPropertyType::setValueQualifier()
     * @uses ItemPropertyType::setImportanceCode()
     * @uses ItemPropertyType::setListValue()
     * @uses ItemPropertyType::setUsabilityPeriod()
     * @uses ItemPropertyType::setItemPropertyGroup()
     * @uses ItemPropertyType::setRangeDimension()
     * @uses ItemPropertyType::setItemPropertyRange()
     * @param \Mnm\IDType $iD
     * @param \Mnm\NameType $name
     * @param \Mnm\NameCodeType $nameCode
     * @param \Mnm\TestMethodType $testMethod
     * @param \Mnm\ValueType $value
     * @param \Mnm\ValueQuantityType $valueQuantity
     * @param \Mnm\ValueQualifierType[] $valueQualifier
     * @param \Mnm\ImportanceCodeType $importanceCode
     * @param \Mnm\ListValueType[] $listValue
     * @param \Mnm\PeriodType $usabilityPeriod
     * @param \Mnm\ItemPropertyGroupType[] $itemPropertyGroup
     * @param \Mnm\DimensionType $rangeDimension
     * @param \Mnm\ItemPropertyRangeType $itemPropertyRange
     */
    public function __construct(\Mnm\IDType $iD = null, \Mnm\NameType $name = null, \Mnm\NameCodeType $nameCode = null, \Mnm\TestMethodType $testMethod = null, \Mnm\ValueType $value = null, \Mnm\ValueQuantityType $valueQuantity = null, array $valueQualifier = array(), \Mnm\ImportanceCodeType $importanceCode = null, array $listValue = array(), \Mnm\PeriodType $usabilityPeriod = null, array $itemPropertyGroup = array(), \Mnm\DimensionType $rangeDimension = null, \Mnm\ItemPropertyRangeType $itemPropertyRange = null)
    {
        $this
            ->setID($iD)
            ->setName($name)
            ->setNameCode($nameCode)
            ->setTestMethod($testMethod)
            ->setValue($value)
            ->setValueQuantity($valueQuantity)
            ->setValueQualifier($valueQualifier)
            ->setImportanceCode($importanceCode)
            ->setListValue($listValue)
            ->setUsabilityPeriod($usabilityPeriod)
            ->setItemPropertyGroup($itemPropertyGroup)
            ->setRangeDimension($rangeDimension)
            ->setItemPropertyRange($itemPropertyRange);
    }
    /**
     * Get ID value
     * @return \Mnm\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Mnm\IDType $iD
     * @return \Mnm\ItemPropertyType
     */
    public function setID(\Mnm\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Name value
     * @return \Mnm\NameType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \Mnm\NameType $name
     * @return \Mnm\ItemPropertyType
     */
    public function setName(\Mnm\NameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get NameCode value
     * @return \Mnm\NameCodeType|null
     */
    public function getNameCode()
    {
        return $this->NameCode;
    }
    /**
     * Set NameCode value
     * @param \Mnm\NameCodeType $nameCode
     * @return \Mnm\ItemPropertyType
     */
    public function setNameCode(\Mnm\NameCodeType $nameCode = null)
    {
        $this->NameCode = $nameCode;
        return $this;
    }
    /**
     * Get TestMethod value
     * @return \Mnm\TestMethodType|null
     */
    public function getTestMethod()
    {
        return $this->TestMethod;
    }
    /**
     * Set TestMethod value
     * @param \Mnm\TestMethodType $testMethod
     * @return \Mnm\ItemPropertyType
     */
    public function setTestMethod(\Mnm\TestMethodType $testMethod = null)
    {
        $this->TestMethod = $testMethod;
        return $this;
    }
    /**
     * Get Value value
     * @return \Mnm\ValueType|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param \Mnm\ValueType $value
     * @return \Mnm\ItemPropertyType
     */
    public function setValue(\Mnm\ValueType $value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Get ValueQuantity value
     * @return \Mnm\ValueQuantityType|null
     */
    public function getValueQuantity()
    {
        return $this->ValueQuantity;
    }
    /**
     * Set ValueQuantity value
     * @param \Mnm\ValueQuantityType $valueQuantity
     * @return \Mnm\ItemPropertyType
     */
    public function setValueQuantity(\Mnm\ValueQuantityType $valueQuantity = null)
    {
        $this->ValueQuantity = $valueQuantity;
        return $this;
    }
    /**
     * Get ValueQualifier value
     * @return \Mnm\ValueQualifierType[]|null
     */
    public function getValueQualifier()
    {
        return $this->ValueQualifier;
    }
    /**
     * Set ValueQualifier value
     * @param \Mnm\ValueQualifierType[] $valueQualifier
     * @return \Mnm\ItemPropertyType
     */
    public function setValueQualifier(array $valueQualifier = array())
    {
        $this->ValueQualifier = $valueQualifier;
        return $this;
    }
    /**
     * Add item to ValueQualifier value
     * @throws \InvalidArgumentException
     * @param \Mnm\ValueQualifierType $item
     * @return \Mnm\ItemPropertyType
     */
    public function addToValueQualifier(\Mnm\ValueQualifierType $item)
    {
        $this->ValueQualifier[] = $item;
        return $this;
    }
    /**
     * Get ImportanceCode value
     * @return \Mnm\ImportanceCodeType|null
     */
    public function getImportanceCode()
    {
        return $this->ImportanceCode;
    }
    /**
     * Set ImportanceCode value
     * @param \Mnm\ImportanceCodeType $importanceCode
     * @return \Mnm\ItemPropertyType
     */
    public function setImportanceCode(\Mnm\ImportanceCodeType $importanceCode = null)
    {
        $this->ImportanceCode = $importanceCode;
        return $this;
    }
    /**
     * Get ListValue value
     * @return \Mnm\ListValueType[]|null
     */
    public function getListValue()
    {
        return $this->ListValue;
    }
    /**
     * Set ListValue value
     * @param \Mnm\ListValueType[] $listValue
     * @return \Mnm\ItemPropertyType
     */
    public function setListValue(array $listValue = array())
    {
        $this->ListValue = $listValue;
        return $this;
    }
    /**
     * Add item to ListValue value
     * @throws \InvalidArgumentException
     * @param \Mnm\ListValueType $item
     * @return \Mnm\ItemPropertyType
     */
    public function addToListValue(\Mnm\ListValueType $item)
    {
        $this->ListValue[] = $item;
        return $this;
    }
    /**
     * Get UsabilityPeriod value
     * @return \Mnm\PeriodType|null
     */
    public function getUsabilityPeriod()
    {
        return $this->UsabilityPeriod;
    }
    /**
     * Set UsabilityPeriod value
     * @param \Mnm\PeriodType $usabilityPeriod
     * @return \Mnm\ItemPropertyType
     */
    public function setUsabilityPeriod(\Mnm\PeriodType $usabilityPeriod = null)
    {
        $this->UsabilityPeriod = $usabilityPeriod;
        return $this;
    }
    /**
     * Get ItemPropertyGroup value
     * @return \Mnm\ItemPropertyGroupType[]|null
     */
    public function getItemPropertyGroup()
    {
        return $this->ItemPropertyGroup;
    }
    /**
     * Set ItemPropertyGroup value
     * @param \Mnm\ItemPropertyGroupType[] $itemPropertyGroup
     * @return \Mnm\ItemPropertyType
     */
    public function setItemPropertyGroup(array $itemPropertyGroup = array())
    {
        $this->ItemPropertyGroup = $itemPropertyGroup;
        return $this;
    }
    /**
     * Add item to ItemPropertyGroup value
     * @throws \InvalidArgumentException
     * @param \Mnm\ItemPropertyGroupType $item
     * @return \Mnm\ItemPropertyType
     */
    public function addToItemPropertyGroup(\Mnm\ItemPropertyGroupType $item)
    {
        $this->ItemPropertyGroup[] = $item;
        return $this;
    }
    /**
     * Get RangeDimension value
     * @return \Mnm\DimensionType|null
     */
    public function getRangeDimension()
    {
        return $this->RangeDimension;
    }
    /**
     * Set RangeDimension value
     * @param \Mnm\DimensionType $rangeDimension
     * @return \Mnm\ItemPropertyType
     */
    public function setRangeDimension(\Mnm\DimensionType $rangeDimension = null)
    {
        $this->RangeDimension = $rangeDimension;
        return $this;
    }
    /**
     * Get ItemPropertyRange value
     * @return \Mnm\ItemPropertyRangeType|null
     */
    public function getItemPropertyRange()
    {
        return $this->ItemPropertyRange;
    }
    /**
     * Set ItemPropertyRange value
     * @param \Mnm\ItemPropertyRangeType $itemPropertyRange
     * @return \Mnm\ItemPropertyType
     */
    public function setItemPropertyRange(\Mnm\ItemPropertyRangeType $itemPropertyRange = null)
    {
        $this->ItemPropertyRange = $itemPropertyRange;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\ItemPropertyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
