<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemInstanceType StructType
 * @subpackage Structs
 */
class ItemInstanceType extends AbstractStructBase
{
    /**
     * The ProductTraceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q140:ProductTraceID
     * @var \Mnm\ProductTraceIDType
     */
    public $ProductTraceID;
    /**
     * The ManufactureDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q141:ManufactureDate
     * @var \Mnm\ManufactureDateType
     */
    public $ManufactureDate;
    /**
     * The ManufactureTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q142:ManufactureTime
     * @var \Mnm\ManufactureTimeType
     */
    public $ManufactureTime;
    /**
     * The BestBeforeDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q143:BestBeforeDate
     * @var \Mnm\BestBeforeDateType
     */
    public $BestBeforeDate;
    /**
     * The RegistrationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q144:RegistrationID
     * @var \Mnm\RegistrationIDType
     */
    public $RegistrationID;
    /**
     * The SerialID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q145:SerialID
     * @var \Mnm\SerialIDType
     */
    public $SerialID;
    /**
     * The AdditionalItemProperty
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\ItemPropertyType[]
     */
    public $AdditionalItemProperty;
    /**
     * The LotIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\LotIdentificationType
     */
    public $LotIdentification;
    /**
     * Constructor method for ItemInstanceType
     * @uses ItemInstanceType::setProductTraceID()
     * @uses ItemInstanceType::setManufactureDate()
     * @uses ItemInstanceType::setManufactureTime()
     * @uses ItemInstanceType::setBestBeforeDate()
     * @uses ItemInstanceType::setRegistrationID()
     * @uses ItemInstanceType::setSerialID()
     * @uses ItemInstanceType::setAdditionalItemProperty()
     * @uses ItemInstanceType::setLotIdentification()
     * @param \Mnm\ProductTraceIDType $productTraceID
     * @param \Mnm\ManufactureDateType $manufactureDate
     * @param \Mnm\ManufactureTimeType $manufactureTime
     * @param \Mnm\BestBeforeDateType $bestBeforeDate
     * @param \Mnm\RegistrationIDType $registrationID
     * @param \Mnm\SerialIDType $serialID
     * @param \Mnm\ItemPropertyType[] $additionalItemProperty
     * @param \Mnm\LotIdentificationType $lotIdentification
     */
    public function __construct(\Mnm\ProductTraceIDType $productTraceID = null, \Mnm\ManufactureDateType $manufactureDate = null, \Mnm\ManufactureTimeType $manufactureTime = null, \Mnm\BestBeforeDateType $bestBeforeDate = null, \Mnm\RegistrationIDType $registrationID = null, \Mnm\SerialIDType $serialID = null, array $additionalItemProperty = array(), \Mnm\LotIdentificationType $lotIdentification = null)
    {
        $this
            ->setProductTraceID($productTraceID)
            ->setManufactureDate($manufactureDate)
            ->setManufactureTime($manufactureTime)
            ->setBestBeforeDate($bestBeforeDate)
            ->setRegistrationID($registrationID)
            ->setSerialID($serialID)
            ->setAdditionalItemProperty($additionalItemProperty)
            ->setLotIdentification($lotIdentification);
    }
    /**
     * Get ProductTraceID value
     * @return \Mnm\ProductTraceIDType|null
     */
    public function getProductTraceID()
    {
        return $this->ProductTraceID;
    }
    /**
     * Set ProductTraceID value
     * @param \Mnm\ProductTraceIDType $productTraceID
     * @return \Mnm\ItemInstanceType
     */
    public function setProductTraceID(\Mnm\ProductTraceIDType $productTraceID = null)
    {
        $this->ProductTraceID = $productTraceID;
        return $this;
    }
    /**
     * Get ManufactureDate value
     * @return \Mnm\ManufactureDateType|null
     */
    public function getManufactureDate()
    {
        return $this->ManufactureDate;
    }
    /**
     * Set ManufactureDate value
     * @param \Mnm\ManufactureDateType $manufactureDate
     * @return \Mnm\ItemInstanceType
     */
    public function setManufactureDate(\Mnm\ManufactureDateType $manufactureDate = null)
    {
        $this->ManufactureDate = $manufactureDate;
        return $this;
    }
    /**
     * Get ManufactureTime value
     * @return \Mnm\ManufactureTimeType|null
     */
    public function getManufactureTime()
    {
        return $this->ManufactureTime;
    }
    /**
     * Set ManufactureTime value
     * @param \Mnm\ManufactureTimeType $manufactureTime
     * @return \Mnm\ItemInstanceType
     */
    public function setManufactureTime(\Mnm\ManufactureTimeType $manufactureTime = null)
    {
        $this->ManufactureTime = $manufactureTime;
        return $this;
    }
    /**
     * Get BestBeforeDate value
     * @return \Mnm\BestBeforeDateType|null
     */
    public function getBestBeforeDate()
    {
        return $this->BestBeforeDate;
    }
    /**
     * Set BestBeforeDate value
     * @param \Mnm\BestBeforeDateType $bestBeforeDate
     * @return \Mnm\ItemInstanceType
     */
    public function setBestBeforeDate(\Mnm\BestBeforeDateType $bestBeforeDate = null)
    {
        $this->BestBeforeDate = $bestBeforeDate;
        return $this;
    }
    /**
     * Get RegistrationID value
     * @return \Mnm\RegistrationIDType|null
     */
    public function getRegistrationID()
    {
        return $this->RegistrationID;
    }
    /**
     * Set RegistrationID value
     * @param \Mnm\RegistrationIDType $registrationID
     * @return \Mnm\ItemInstanceType
     */
    public function setRegistrationID(\Mnm\RegistrationIDType $registrationID = null)
    {
        $this->RegistrationID = $registrationID;
        return $this;
    }
    /**
     * Get SerialID value
     * @return \Mnm\SerialIDType|null
     */
    public function getSerialID()
    {
        return $this->SerialID;
    }
    /**
     * Set SerialID value
     * @param \Mnm\SerialIDType $serialID
     * @return \Mnm\ItemInstanceType
     */
    public function setSerialID(\Mnm\SerialIDType $serialID = null)
    {
        $this->SerialID = $serialID;
        return $this;
    }
    /**
     * Get AdditionalItemProperty value
     * @return \Mnm\ItemPropertyType[]|null
     */
    public function getAdditionalItemProperty()
    {
        return $this->AdditionalItemProperty;
    }
    /**
     * Set AdditionalItemProperty value
     * @param \Mnm\ItemPropertyType[] $additionalItemProperty
     * @return \Mnm\ItemInstanceType
     */
    public function setAdditionalItemProperty(array $additionalItemProperty = array())
    {
        $this->AdditionalItemProperty = $additionalItemProperty;
        return $this;
    }
    /**
     * Add item to AdditionalItemProperty value
     * @throws \InvalidArgumentException
     * @param \Mnm\ItemPropertyType $item
     * @return \Mnm\ItemInstanceType
     */
    public function addToAdditionalItemProperty(\Mnm\ItemPropertyType $item)
    {
        $this->AdditionalItemProperty[] = $item;
        return $this;
    }
    /**
     * Get LotIdentification value
     * @return \Mnm\LotIdentificationType|null
     */
    public function getLotIdentification()
    {
        return $this->LotIdentification;
    }
    /**
     * Set LotIdentification value
     * @param \Mnm\LotIdentificationType $lotIdentification
     * @return \Mnm\ItemInstanceType
     */
    public function setLotIdentification(\Mnm\LotIdentificationType $lotIdentification = null)
    {
        $this->LotIdentification = $lotIdentification;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\ItemInstanceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
