<?php

namespace Mnm;

/**
 * This class stands for InvoiceTypes EnumType
 * @subpackage Enumerations
 */
class InvoiceTypes
{
    /**
     * Constant for value 'BaseInvoice'
     * @return string 'BaseInvoice'
     */
    const VALUE_BASE_INVOICE = 'BaseInvoice';
    /**
     * Constant for value 'ComercialInvoice'
     * @return string 'ComercialInvoice'
     */
    const VALUE_COMERCIAL_INVOICE = 'ComercialInvoice';
    /**
     * Constant for value 'InvoiceWithPassanger'
     * @return string 'InvoiceWithPassanger'
     */
    const VALUE_INVOICE_WITH_PASSANGER = 'InvoiceWithPassanger';
    /**
     * Constant for value 'Export'
     * @return string 'Export'
     */
    const VALUE_EXPORT = 'Export';
    /**
     * Constant for value 'eArchive'
     * @return string 'eArchive'
     */
    const VALUE_E_ARCHIVE = 'eArchive';
    /**
     * Constant for value 'Hks'
     * @return string 'Hks'
     */
    const VALUE_HKS = 'Hks';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BASE_INVOICE
     * @uses self::VALUE_COMERCIAL_INVOICE
     * @uses self::VALUE_INVOICE_WITH_PASSANGER
     * @uses self::VALUE_EXPORT
     * @uses self::VALUE_E_ARCHIVE
     * @uses self::VALUE_HKS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BASE_INVOICE,
            self::VALUE_COMERCIAL_INVOICE,
            self::VALUE_INVOICE_WITH_PASSANGER,
            self::VALUE_EXPORT,
            self::VALUE_E_ARCHIVE,
            self::VALUE_HKS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
