<?php

namespace Mnm;

/**
 * This class stands for InvoiceListSortingColumn EnumType
 * @subpackage Enumerations
 */
class InvoiceListSortingColumn
{
    /**
     * Constant for value 'Default'
     * @return string 'Default'
     */
    const VALUE_DEFAULT = 'Default';
    /**
     * Constant for value 'Id'
     * @return string 'Id'
     */
    const VALUE_ID = 'Id';
    /**
     * Constant for value 'CreateDate'
     * @return string 'CreateDate'
     */
    const VALUE_CREATE_DATE = 'CreateDate';
    /**
     * Constant for value 'ExecutionDate'
     * @return string 'ExecutionDate'
     */
    const VALUE_EXECUTION_DATE = 'ExecutionDate';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DEFAULT
     * @uses self::VALUE_ID
     * @uses self::VALUE_CREATE_DATE
     * @uses self::VALUE_EXECUTION_DATE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEFAULT,
            self::VALUE_ID,
            self::VALUE_CREATE_DATE,
            self::VALUE_EXECUTION_DATE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
