<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceLineType StructType
 * @subpackage Structs
 */
class InvoiceLineType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q167:ID
     * @var \Mnm\IDType
     */
    public $ID;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q168:Note
     * @var \Mnm\NoteType[]
     */
    public $Note;
    /**
     * The InvoicedQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q169:InvoicedQuantity
     * @var \Mnm\InvoicedQuantityType
     */
    public $InvoicedQuantity;
    /**
     * The LineExtensionAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q170:LineExtensionAmount
     * @var \Mnm\LineExtensionAmountType
     */
    public $LineExtensionAmount;
    /**
     * The OrderLineReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\OrderLineReferenceType[]
     */
    public $OrderLineReference;
    /**
     * The DespatchLineReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\LineReferenceType[]
     */
    public $DespatchLineReference;
    /**
     * The ReceiptLineReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\LineReferenceType[]
     */
    public $ReceiptLineReference;
    /**
     * The Delivery
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\DeliveryType[]
     */
    public $Delivery;
    /**
     * The AllowanceCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\AllowanceChargeType[]
     */
    public $AllowanceCharge;
    /**
     * The TaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\TaxTotalType
     */
    public $TaxTotal;
    /**
     * The WithholdingTaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\TaxTotalType[]
     */
    public $WithholdingTaxTotal;
    /**
     * The Item
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\ItemType
     */
    public $Item;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\PriceType
     */
    public $Price;
    /**
     * The SubInvoiceLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\InvoiceLineType[]
     */
    public $SubInvoiceLine;
    /**
     * Constructor method for InvoiceLineType
     * @uses InvoiceLineType::setID()
     * @uses InvoiceLineType::setNote()
     * @uses InvoiceLineType::setInvoicedQuantity()
     * @uses InvoiceLineType::setLineExtensionAmount()
     * @uses InvoiceLineType::setOrderLineReference()
     * @uses InvoiceLineType::setDespatchLineReference()
     * @uses InvoiceLineType::setReceiptLineReference()
     * @uses InvoiceLineType::setDelivery()
     * @uses InvoiceLineType::setAllowanceCharge()
     * @uses InvoiceLineType::setTaxTotal()
     * @uses InvoiceLineType::setWithholdingTaxTotal()
     * @uses InvoiceLineType::setItem()
     * @uses InvoiceLineType::setPrice()
     * @uses InvoiceLineType::setSubInvoiceLine()
     * @param \Mnm\IDType $iD
     * @param \Mnm\NoteType[] $note
     * @param \Mnm\InvoicedQuantityType $invoicedQuantity
     * @param \Mnm\LineExtensionAmountType $lineExtensionAmount
     * @param \Mnm\OrderLineReferenceType[] $orderLineReference
     * @param \Mnm\LineReferenceType[] $despatchLineReference
     * @param \Mnm\LineReferenceType[] $receiptLineReference
     * @param \Mnm\DeliveryType[] $delivery
     * @param \Mnm\AllowanceChargeType[] $allowanceCharge
     * @param \Mnm\TaxTotalType $taxTotal
     * @param \Mnm\TaxTotalType[] $withholdingTaxTotal
     * @param \Mnm\ItemType $item
     * @param \Mnm\PriceType $price
     * @param \Mnm\InvoiceLineType[] $subInvoiceLine
     */
    public function __construct(\Mnm\IDType $iD = null, array $note = array(), \Mnm\InvoicedQuantityType $invoicedQuantity = null, \Mnm\LineExtensionAmountType $lineExtensionAmount = null, array $orderLineReference = array(), array $despatchLineReference = array(), array $receiptLineReference = array(), array $delivery = array(), array $allowanceCharge = array(), \Mnm\TaxTotalType $taxTotal = null, array $withholdingTaxTotal = array(), \Mnm\ItemType $item = null, \Mnm\PriceType $price = null, array $subInvoiceLine = array())
    {
        $this
            ->setID($iD)
            ->setNote($note)
            ->setInvoicedQuantity($invoicedQuantity)
            ->setLineExtensionAmount($lineExtensionAmount)
            ->setOrderLineReference($orderLineReference)
            ->setDespatchLineReference($despatchLineReference)
            ->setReceiptLineReference($receiptLineReference)
            ->setDelivery($delivery)
            ->setAllowanceCharge($allowanceCharge)
            ->setTaxTotal($taxTotal)
            ->setWithholdingTaxTotal($withholdingTaxTotal)
            ->setItem($item)
            ->setPrice($price)
            ->setSubInvoiceLine($subInvoiceLine);
    }
    /**
     * Get ID value
     * @return \Mnm\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Mnm\IDType $iD
     * @return \Mnm\InvoiceLineType
     */
    public function setID(\Mnm\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Note value
     * @return \Mnm\NoteType[]|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param \Mnm\NoteType[] $note
     * @return \Mnm\InvoiceLineType
     */
    public function setNote(array $note = array())
    {
        $this->Note = $note;
        return $this;
    }
    /**
     * Add item to Note value
     * @throws \InvalidArgumentException
     * @param \Mnm\NoteType $item
     * @return \Mnm\InvoiceLineType
     */
    public function addToNote(\Mnm\NoteType $item)
    {
        $this->Note[] = $item;
        return $this;
    }
    /**
     * Get InvoicedQuantity value
     * @return \Mnm\InvoicedQuantityType|null
     */
    public function getInvoicedQuantity()
    {
        return $this->InvoicedQuantity;
    }
    /**
     * Set InvoicedQuantity value
     * @param \Mnm\InvoicedQuantityType $invoicedQuantity
     * @return \Mnm\InvoiceLineType
     */
    public function setInvoicedQuantity(\Mnm\InvoicedQuantityType $invoicedQuantity = null)
    {
        $this->InvoicedQuantity = $invoicedQuantity;
        return $this;
    }
    /**
     * Get LineExtensionAmount value
     * @return \Mnm\LineExtensionAmountType|null
     */
    public function getLineExtensionAmount()
    {
        return $this->LineExtensionAmount;
    }
    /**
     * Set LineExtensionAmount value
     * @param \Mnm\LineExtensionAmountType $lineExtensionAmount
     * @return \Mnm\InvoiceLineType
     */
    public function setLineExtensionAmount(\Mnm\LineExtensionAmountType $lineExtensionAmount = null)
    {
        $this->LineExtensionAmount = $lineExtensionAmount;
        return $this;
    }
    /**
     * Get OrderLineReference value
     * @return \Mnm\OrderLineReferenceType[]|null
     */
    public function getOrderLineReference()
    {
        return $this->OrderLineReference;
    }
    /**
     * Set OrderLineReference value
     * @param \Mnm\OrderLineReferenceType[] $orderLineReference
     * @return \Mnm\InvoiceLineType
     */
    public function setOrderLineReference(array $orderLineReference = array())
    {
        $this->OrderLineReference = $orderLineReference;
        return $this;
    }
    /**
     * Add item to OrderLineReference value
     * @throws \InvalidArgumentException
     * @param \Mnm\OrderLineReferenceType $item
     * @return \Mnm\InvoiceLineType
     */
    public function addToOrderLineReference(\Mnm\OrderLineReferenceType $item)
    {
        $this->OrderLineReference[] = $item;
        return $this;
    }
    /**
     * Get DespatchLineReference value
     * @return \Mnm\LineReferenceType[]|null
     */
    public function getDespatchLineReference()
    {
        return $this->DespatchLineReference;
    }
    /**
     * Set DespatchLineReference value
     * @param \Mnm\LineReferenceType[] $despatchLineReference
     * @return \Mnm\InvoiceLineType
     */
    public function setDespatchLineReference(array $despatchLineReference = array())
    {
        $this->DespatchLineReference = $despatchLineReference;
        return $this;
    }
    /**
     * Add item to DespatchLineReference value
     * @throws \InvalidArgumentException
     * @param \Mnm\LineReferenceType $item
     * @return \Mnm\InvoiceLineType
     */
    public function addToDespatchLineReference(\Mnm\LineReferenceType $item)
    {
        $this->DespatchLineReference[] = $item;
        return $this;
    }
    /**
     * Get ReceiptLineReference value
     * @return \Mnm\LineReferenceType[]|null
     */
    public function getReceiptLineReference()
    {
        return $this->ReceiptLineReference;
    }
    /**
     * Set ReceiptLineReference value
     * @param \Mnm\LineReferenceType[] $receiptLineReference
     * @return \Mnm\InvoiceLineType
     */
    public function setReceiptLineReference(array $receiptLineReference = array())
    {
        $this->ReceiptLineReference = $receiptLineReference;
        return $this;
    }
    /**
     * Add item to ReceiptLineReference value
     * @throws \InvalidArgumentException
     * @param \Mnm\LineReferenceType $item
     * @return \Mnm\InvoiceLineType
     */
    public function addToReceiptLineReference(\Mnm\LineReferenceType $item)
    {
        $this->ReceiptLineReference[] = $item;
        return $this;
    }
    /**
     * Get Delivery value
     * @return \Mnm\DeliveryType[]|null
     */
    public function getDelivery()
    {
        return $this->Delivery;
    }
    /**
     * Set Delivery value
     * @param \Mnm\DeliveryType[] $delivery
     * @return \Mnm\InvoiceLineType
     */
    public function setDelivery(array $delivery = array())
    {
        $this->Delivery = $delivery;
        return $this;
    }
    /**
     * Add item to Delivery value
     * @throws \InvalidArgumentException
     * @param \Mnm\DeliveryType $item
     * @return \Mnm\InvoiceLineType
     */
    public function addToDelivery(\Mnm\DeliveryType $item)
    {
        $this->Delivery[] = $item;
        return $this;
    }
    /**
     * Get AllowanceCharge value
     * @return \Mnm\AllowanceChargeType[]|null
     */
    public function getAllowanceCharge()
    {
        return $this->AllowanceCharge;
    }
    /**
     * Set AllowanceCharge value
     * @param \Mnm\AllowanceChargeType[] $allowanceCharge
     * @return \Mnm\InvoiceLineType
     */
    public function setAllowanceCharge(array $allowanceCharge = array())
    {
        $this->AllowanceCharge = $allowanceCharge;
        return $this;
    }
    /**
     * Add item to AllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \Mnm\AllowanceChargeType $item
     * @return \Mnm\InvoiceLineType
     */
    public function addToAllowanceCharge(\Mnm\AllowanceChargeType $item)
    {
        $this->AllowanceCharge[] = $item;
        return $this;
    }
    /**
     * Get TaxTotal value
     * @return \Mnm\TaxTotalType|null
     */
    public function getTaxTotal()
    {
        return $this->TaxTotal;
    }
    /**
     * Set TaxTotal value
     * @param \Mnm\TaxTotalType $taxTotal
     * @return \Mnm\InvoiceLineType
     */
    public function setTaxTotal(\Mnm\TaxTotalType $taxTotal = null)
    {
        $this->TaxTotal = $taxTotal;
        return $this;
    }
    /**
     * Get WithholdingTaxTotal value
     * @return \Mnm\TaxTotalType[]|null
     */
    public function getWithholdingTaxTotal()
    {
        return $this->WithholdingTaxTotal;
    }
    /**
     * Set WithholdingTaxTotal value
     * @param \Mnm\TaxTotalType[] $withholdingTaxTotal
     * @return \Mnm\InvoiceLineType
     */
    public function setWithholdingTaxTotal(array $withholdingTaxTotal = array())
    {
        $this->WithholdingTaxTotal = $withholdingTaxTotal;
        return $this;
    }
    /**
     * Add item to WithholdingTaxTotal value
     * @throws \InvalidArgumentException
     * @param \Mnm\TaxTotalType $item
     * @return \Mnm\InvoiceLineType
     */
    public function addToWithholdingTaxTotal(\Mnm\TaxTotalType $item)
    {
        $this->WithholdingTaxTotal[] = $item;
        return $this;
    }
    /**
     * Get Item value
     * @return \Mnm\ItemType|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @param \Mnm\ItemType $item
     * @return \Mnm\InvoiceLineType
     */
    public function setItem(\Mnm\ItemType $item = null)
    {
        $this->Item = $item;
        return $this;
    }
    /**
     * Get Price value
     * @return \Mnm\PriceType|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \Mnm\PriceType $price
     * @return \Mnm\InvoiceLineType
     */
    public function setPrice(\Mnm\PriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get SubInvoiceLine value
     * @return \Mnm\InvoiceLineType[]|null
     */
    public function getSubInvoiceLine()
    {
        return $this->SubInvoiceLine;
    }
    /**
     * Set SubInvoiceLine value
     * @param \Mnm\InvoiceLineType[] $subInvoiceLine
     * @return \Mnm\InvoiceLineType
     */
    public function setSubInvoiceLine(array $subInvoiceLine = array())
    {
        $this->SubInvoiceLine = $subInvoiceLine;
        return $this;
    }
    /**
     * Add item to SubInvoiceLine value
     * @throws \InvalidArgumentException
     * @param \Mnm\InvoiceLineType $item
     * @return \Mnm\InvoiceLineType
     */
    public function addToSubInvoiceLine(\Mnm\InvoiceLineType $item)
    {
        $this->SubInvoiceLine[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\InvoiceLineType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
