<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceInfo StructType
 * @subpackage Structs
 */
class InvoiceInfo extends AbstractStructBase
{
    /**
     * The Scenario
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Scenario;
    /**
     * The CreateDateUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDateUtc;
    /**
     * The Invoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\InvoiceType
     */
    public $Invoice;
    /**
     * The TargetCustomer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\CustomerInfo
     */
    public $TargetCustomer;
    /**
     * The EArchiveInvoiceInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\EArchiveInvoiceInformation
     */
    public $EArchiveInvoiceInfo;
    /**
     * The Notification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\NotificationInformation
     */
    public $Notification;
    /**
     * The LocalDocumentId
     * @var string
     */
    public $LocalDocumentId;
    /**
     * The ExtraInformation
     * @var string
     */
    public $ExtraInformation;
    /**
     * Constructor method for InvoiceInfo
     * @uses InvoiceInfo::setScenario()
     * @uses InvoiceInfo::setCreateDateUtc()
     * @uses InvoiceInfo::setInvoice()
     * @uses InvoiceInfo::setTargetCustomer()
     * @uses InvoiceInfo::setEArchiveInvoiceInfo()
     * @uses InvoiceInfo::setNotification()
     * @uses InvoiceInfo::setLocalDocumentId()
     * @uses InvoiceInfo::setExtraInformation()
     * @param string $scenario
     * @param string $createDateUtc
     * @param \Mnm\InvoiceType $invoice
     * @param \Mnm\CustomerInfo $targetCustomer
     * @param \Mnm\EArchiveInvoiceInformation $eArchiveInvoiceInfo
     * @param \Mnm\NotificationInformation $notification
     * @param string $localDocumentId
     * @param string $extraInformation
     */
    public function __construct($scenario = null, $createDateUtc = null, \Mnm\InvoiceType $invoice = null, \Mnm\CustomerInfo $targetCustomer = null, \Mnm\EArchiveInvoiceInformation $eArchiveInvoiceInfo = null, \Mnm\NotificationInformation $notification = null, $localDocumentId = null, $extraInformation = null)
    {
        $this
            ->setScenario($scenario)
            ->setCreateDateUtc($createDateUtc)
            ->setInvoice($invoice)
            ->setTargetCustomer($targetCustomer)
            ->setEArchiveInvoiceInfo($eArchiveInvoiceInfo)
            ->setNotification($notification)
            ->setLocalDocumentId($localDocumentId)
            ->setExtraInformation($extraInformation);
    }
    /**
     * Get Scenario value
     * @return string
     */
    public function getScenario()
    {
        return $this->Scenario;
    }
    /**
     * Set Scenario value
     * @param string $scenario
     * @return \Mnm\InvoiceInfo
     */
    public function setScenario($scenario = null)
    {
        $this->Scenario = $scenario;
        return $this;
    }
    /**
     * Get CreateDateUtc value
     * @return string
     */
    public function getCreateDateUtc()
    {
        return $this->CreateDateUtc;
    }
    /**
     * Set CreateDateUtc value
     * @param string $createDateUtc
     * @return \Mnm\InvoiceInfo
     */
    public function setCreateDateUtc($createDateUtc = null)
    {
        $this->CreateDateUtc = $createDateUtc;
        return $this;
    }
    /**
     * Get Invoice value
     * @return \Mnm\InvoiceType|null
     */
    public function getInvoice()
    {
        return $this->Invoice;
    }
    /**
     * Set Invoice value
     * @param \Mnm\InvoiceType $invoice
     * @return \Mnm\InvoiceInfo
     */
    public function setInvoice(\Mnm\InvoiceType $invoice = null)
    {
        $this->Invoice = $invoice;
        return $this;
    }
    /**
     * Get TargetCustomer value
     * @return \Mnm\CustomerInfo|null
     */
    public function getTargetCustomer()
    {
        return $this->TargetCustomer;
    }
    /**
     * Set TargetCustomer value
     * @param \Mnm\CustomerInfo $targetCustomer
     * @return \Mnm\InvoiceInfo
     */
    public function setTargetCustomer(\Mnm\CustomerInfo $targetCustomer = null)
    {
        $this->TargetCustomer = $targetCustomer;
        return $this;
    }
    /**
     * Get EArchiveInvoiceInfo value
     * @return \Mnm\EArchiveInvoiceInformation|null
     */
    public function getEArchiveInvoiceInfo()
    {
        return $this->EArchiveInvoiceInfo;
    }
    /**
     * Set EArchiveInvoiceInfo value
     * @param \Mnm\EArchiveInvoiceInformation $eArchiveInvoiceInfo
     * @return \Mnm\InvoiceInfo
     */
    public function setEArchiveInvoiceInfo(\Mnm\EArchiveInvoiceInformation $eArchiveInvoiceInfo = null)
    {
        $this->EArchiveInvoiceInfo = $eArchiveInvoiceInfo;
        return $this;
    }
    /**
     * Get Notification value
     * @return \Mnm\NotificationInformation|null
     */
    public function getNotification()
    {
        return $this->Notification;
    }
    /**
     * Set Notification value
     * @param \Mnm\NotificationInformation $notification
     * @return \Mnm\InvoiceInfo
     */
    public function setNotification(\Mnm\NotificationInformation $notification = null)
    {
        $this->Notification = $notification;
        return $this;
    }
    /**
     * Get LocalDocumentId value
     * @return string|null
     */
    public function getLocalDocumentId()
    {
        return $this->LocalDocumentId;
    }
    /**
     * Set LocalDocumentId value
     * @param string $localDocumentId
     * @return \Mnm\InvoiceInfo
     */
    public function setLocalDocumentId($localDocumentId = null)
    {
        $this->LocalDocumentId = $localDocumentId;
        return $this;
    }
    /**
     * Get ExtraInformation value
     * @return string|null
     */
    public function getExtraInformation()
    {
        return $this->ExtraInformation;
    }
    /**
     * Set ExtraInformation value
     * @param string $extraInformation
     * @return \Mnm\InvoiceInfo
     */
    public function setExtraInformation($extraInformation = null)
    {
        $this->ExtraInformation = $extraInformation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\InvoiceInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
