<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HazardousGoodsTransitType StructType
 * @subpackage Structs
 */
class HazardousGoodsTransitType extends AbstractStructBase
{
    /**
     * The TransportEmergencyCardCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q233:TransportEmergencyCardCode
     * @var \Mnm\TransportEmergencyCardCodeType
     */
    public $TransportEmergencyCardCode;
    /**
     * The PackingCriteriaCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q234:PackingCriteriaCode
     * @var \Mnm\PackingCriteriaCodeType
     */
    public $PackingCriteriaCode;
    /**
     * The HazardousRegulationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q235:HazardousRegulationCode
     * @var \Mnm\HazardousRegulationCodeType
     */
    public $HazardousRegulationCode;
    /**
     * The InhalationToxicityZoneCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q236:InhalationToxicityZoneCode
     * @var \Mnm\InhalationToxicityZoneCodeType
     */
    public $InhalationToxicityZoneCode;
    /**
     * The TransportAuthorizationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q237:TransportAuthorizationCode
     * @var \Mnm\TransportAuthorizationCodeType
     */
    public $TransportAuthorizationCode;
    /**
     * The MaximumTemperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\TemperatureType
     */
    public $MaximumTemperature;
    /**
     * The MinimumTemperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\TemperatureType
     */
    public $MinimumTemperature;
    /**
     * Constructor method for HazardousGoodsTransitType
     * @uses HazardousGoodsTransitType::setTransportEmergencyCardCode()
     * @uses HazardousGoodsTransitType::setPackingCriteriaCode()
     * @uses HazardousGoodsTransitType::setHazardousRegulationCode()
     * @uses HazardousGoodsTransitType::setInhalationToxicityZoneCode()
     * @uses HazardousGoodsTransitType::setTransportAuthorizationCode()
     * @uses HazardousGoodsTransitType::setMaximumTemperature()
     * @uses HazardousGoodsTransitType::setMinimumTemperature()
     * @param \Mnm\TransportEmergencyCardCodeType $transportEmergencyCardCode
     * @param \Mnm\PackingCriteriaCodeType $packingCriteriaCode
     * @param \Mnm\HazardousRegulationCodeType $hazardousRegulationCode
     * @param \Mnm\InhalationToxicityZoneCodeType $inhalationToxicityZoneCode
     * @param \Mnm\TransportAuthorizationCodeType $transportAuthorizationCode
     * @param \Mnm\TemperatureType $maximumTemperature
     * @param \Mnm\TemperatureType $minimumTemperature
     */
    public function __construct(\Mnm\TransportEmergencyCardCodeType $transportEmergencyCardCode = null, \Mnm\PackingCriteriaCodeType $packingCriteriaCode = null, \Mnm\HazardousRegulationCodeType $hazardousRegulationCode = null, \Mnm\InhalationToxicityZoneCodeType $inhalationToxicityZoneCode = null, \Mnm\TransportAuthorizationCodeType $transportAuthorizationCode = null, \Mnm\TemperatureType $maximumTemperature = null, \Mnm\TemperatureType $minimumTemperature = null)
    {
        $this
            ->setTransportEmergencyCardCode($transportEmergencyCardCode)
            ->setPackingCriteriaCode($packingCriteriaCode)
            ->setHazardousRegulationCode($hazardousRegulationCode)
            ->setInhalationToxicityZoneCode($inhalationToxicityZoneCode)
            ->setTransportAuthorizationCode($transportAuthorizationCode)
            ->setMaximumTemperature($maximumTemperature)
            ->setMinimumTemperature($minimumTemperature);
    }
    /**
     * Get TransportEmergencyCardCode value
     * @return \Mnm\TransportEmergencyCardCodeType|null
     */
    public function getTransportEmergencyCardCode()
    {
        return $this->TransportEmergencyCardCode;
    }
    /**
     * Set TransportEmergencyCardCode value
     * @param \Mnm\TransportEmergencyCardCodeType $transportEmergencyCardCode
     * @return \Mnm\HazardousGoodsTransitType
     */
    public function setTransportEmergencyCardCode(\Mnm\TransportEmergencyCardCodeType $transportEmergencyCardCode = null)
    {
        $this->TransportEmergencyCardCode = $transportEmergencyCardCode;
        return $this;
    }
    /**
     * Get PackingCriteriaCode value
     * @return \Mnm\PackingCriteriaCodeType|null
     */
    public function getPackingCriteriaCode()
    {
        return $this->PackingCriteriaCode;
    }
    /**
     * Set PackingCriteriaCode value
     * @param \Mnm\PackingCriteriaCodeType $packingCriteriaCode
     * @return \Mnm\HazardousGoodsTransitType
     */
    public function setPackingCriteriaCode(\Mnm\PackingCriteriaCodeType $packingCriteriaCode = null)
    {
        $this->PackingCriteriaCode = $packingCriteriaCode;
        return $this;
    }
    /**
     * Get HazardousRegulationCode value
     * @return \Mnm\HazardousRegulationCodeType|null
     */
    public function getHazardousRegulationCode()
    {
        return $this->HazardousRegulationCode;
    }
    /**
     * Set HazardousRegulationCode value
     * @param \Mnm\HazardousRegulationCodeType $hazardousRegulationCode
     * @return \Mnm\HazardousGoodsTransitType
     */
    public function setHazardousRegulationCode(\Mnm\HazardousRegulationCodeType $hazardousRegulationCode = null)
    {
        $this->HazardousRegulationCode = $hazardousRegulationCode;
        return $this;
    }
    /**
     * Get InhalationToxicityZoneCode value
     * @return \Mnm\InhalationToxicityZoneCodeType|null
     */
    public function getInhalationToxicityZoneCode()
    {
        return $this->InhalationToxicityZoneCode;
    }
    /**
     * Set InhalationToxicityZoneCode value
     * @param \Mnm\InhalationToxicityZoneCodeType $inhalationToxicityZoneCode
     * @return \Mnm\HazardousGoodsTransitType
     */
    public function setInhalationToxicityZoneCode(\Mnm\InhalationToxicityZoneCodeType $inhalationToxicityZoneCode = null)
    {
        $this->InhalationToxicityZoneCode = $inhalationToxicityZoneCode;
        return $this;
    }
    /**
     * Get TransportAuthorizationCode value
     * @return \Mnm\TransportAuthorizationCodeType|null
     */
    public function getTransportAuthorizationCode()
    {
        return $this->TransportAuthorizationCode;
    }
    /**
     * Set TransportAuthorizationCode value
     * @param \Mnm\TransportAuthorizationCodeType $transportAuthorizationCode
     * @return \Mnm\HazardousGoodsTransitType
     */
    public function setTransportAuthorizationCode(\Mnm\TransportAuthorizationCodeType $transportAuthorizationCode = null)
    {
        $this->TransportAuthorizationCode = $transportAuthorizationCode;
        return $this;
    }
    /**
     * Get MaximumTemperature value
     * @return \Mnm\TemperatureType|null
     */
    public function getMaximumTemperature()
    {
        return $this->MaximumTemperature;
    }
    /**
     * Set MaximumTemperature value
     * @param \Mnm\TemperatureType $maximumTemperature
     * @return \Mnm\HazardousGoodsTransitType
     */
    public function setMaximumTemperature(\Mnm\TemperatureType $maximumTemperature = null)
    {
        $this->MaximumTemperature = $maximumTemperature;
        return $this;
    }
    /**
     * Get MinimumTemperature value
     * @return \Mnm\TemperatureType|null
     */
    public function getMinimumTemperature()
    {
        return $this->MinimumTemperature;
    }
    /**
     * Set MinimumTemperature value
     * @param \Mnm\TemperatureType $minimumTemperature
     * @return \Mnm\HazardousGoodsTransitType
     */
    public function setMinimumTemperature(\Mnm\TemperatureType $minimumTemperature = null)
    {
        $this->MinimumTemperature = $minimumTemperature;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\HazardousGoodsTransitType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
