<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoodsItemType StructType
 * @subpackage Structs
 */
class GoodsItemType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q111:ID
     * @var \Mnm\IDType
     */
    public $ID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q112:Description
     * @var \Mnm\DescriptionType[]
     */
    public $Description;
    /**
     * The HazardousRiskIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q113:HazardousRiskIndicator
     * @var \Mnm\HazardousRiskIndicatorType
     */
    public $HazardousRiskIndicator;
    /**
     * The DeclaredCustomsValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q114:DeclaredCustomsValueAmount
     * @var \Mnm\DeclaredCustomsValueAmountType
     */
    public $DeclaredCustomsValueAmount;
    /**
     * The DeclaredForCarriageValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q115:DeclaredForCarriageValueAmount
     * @var \Mnm\DeclaredForCarriageValueAmountType
     */
    public $DeclaredForCarriageValueAmount;
    /**
     * The DeclaredStatisticsValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q116:DeclaredStatisticsValueAmount
     * @var \Mnm\DeclaredStatisticsValueAmountType
     */
    public $DeclaredStatisticsValueAmount;
    /**
     * The FreeOnBoardValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q117:FreeOnBoardValueAmount
     * @var \Mnm\FreeOnBoardValueAmountType
     */
    public $FreeOnBoardValueAmount;
    /**
     * The InsuranceValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q118:InsuranceValueAmount
     * @var \Mnm\InsuranceValueAmountType
     */
    public $InsuranceValueAmount;
    /**
     * The ValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q119:ValueAmount
     * @var \Mnm\ValueAmountType
     */
    public $ValueAmount;
    /**
     * The GrossWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q120:GrossWeightMeasure
     * @var \Mnm\GrossWeightMeasureType
     */
    public $GrossWeightMeasure;
    /**
     * The NetWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q121:NetWeightMeasure
     * @var \Mnm\NetWeightMeasureType
     */
    public $NetWeightMeasure;
    /**
     * The ChargeableWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q122:ChargeableWeightMeasure
     * @var \Mnm\ChargeableWeightMeasureType
     */
    public $ChargeableWeightMeasure;
    /**
     * The GrossVolumeMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q123:GrossVolumeMeasure
     * @var \Mnm\GrossVolumeMeasureType
     */
    public $GrossVolumeMeasure;
    /**
     * The NetVolumeMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q124:NetVolumeMeasure
     * @var \Mnm\NetVolumeMeasureType
     */
    public $NetVolumeMeasure;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q125:Quantity
     * @var \Mnm\QuantityType
     */
    public $Quantity;
    /**
     * The RequiredCustomsID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q126:RequiredCustomsID
     * @var \Mnm\RequiredCustomsIDType
     */
    public $RequiredCustomsID;
    /**
     * The CustomsStatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q127:CustomsStatusCode
     * @var \Mnm\CustomsStatusCodeType
     */
    public $CustomsStatusCode;
    /**
     * The CustomsTariffQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q128:CustomsTariffQuantity
     * @var \Mnm\CustomsTariffQuantityType
     */
    public $CustomsTariffQuantity;
    /**
     * The CustomsImportClassifiedIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q129:CustomsImportClassifiedIndicator
     * @var \Mnm\CustomsImportClassifiedIndicatorType
     */
    public $CustomsImportClassifiedIndicator;
    /**
     * The ChargeableQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q130:ChargeableQuantity
     * @var \Mnm\ChargeableQuantityType
     */
    public $ChargeableQuantity;
    /**
     * The ReturnableQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q131:ReturnableQuantity
     * @var \Mnm\ReturnableQuantityType
     */
    public $ReturnableQuantity;
    /**
     * The TraceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q132:TraceID
     * @var \Mnm\TraceIDType
     */
    public $TraceID;
    /**
     * The Item
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\ItemType[]
     */
    public $Item;
    /**
     * The FreightAllowanceCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\AllowanceChargeType[]
     */
    public $FreightAllowanceCharge;
    /**
     * The InvoiceLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\InvoiceLineType[]
     */
    public $InvoiceLine;
    /**
     * The Temperature
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\TemperatureType[]
     */
    public $Temperature;
    /**
     * The OriginAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\AddressType
     */
    public $OriginAddress;
    /**
     * The MeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\DimensionType[]
     */
    public $MeasurementDimension;
    /**
     * Constructor method for GoodsItemType
     * @uses GoodsItemType::setID()
     * @uses GoodsItemType::setDescription()
     * @uses GoodsItemType::setHazardousRiskIndicator()
     * @uses GoodsItemType::setDeclaredCustomsValueAmount()
     * @uses GoodsItemType::setDeclaredForCarriageValueAmount()
     * @uses GoodsItemType::setDeclaredStatisticsValueAmount()
     * @uses GoodsItemType::setFreeOnBoardValueAmount()
     * @uses GoodsItemType::setInsuranceValueAmount()
     * @uses GoodsItemType::setValueAmount()
     * @uses GoodsItemType::setGrossWeightMeasure()
     * @uses GoodsItemType::setNetWeightMeasure()
     * @uses GoodsItemType::setChargeableWeightMeasure()
     * @uses GoodsItemType::setGrossVolumeMeasure()
     * @uses GoodsItemType::setNetVolumeMeasure()
     * @uses GoodsItemType::setQuantity()
     * @uses GoodsItemType::setRequiredCustomsID()
     * @uses GoodsItemType::setCustomsStatusCode()
     * @uses GoodsItemType::setCustomsTariffQuantity()
     * @uses GoodsItemType::setCustomsImportClassifiedIndicator()
     * @uses GoodsItemType::setChargeableQuantity()
     * @uses GoodsItemType::setReturnableQuantity()
     * @uses GoodsItemType::setTraceID()
     * @uses GoodsItemType::setItem()
     * @uses GoodsItemType::setFreightAllowanceCharge()
     * @uses GoodsItemType::setInvoiceLine()
     * @uses GoodsItemType::setTemperature()
     * @uses GoodsItemType::setOriginAddress()
     * @uses GoodsItemType::setMeasurementDimension()
     * @param \Mnm\IDType $iD
     * @param \Mnm\DescriptionType[] $description
     * @param \Mnm\HazardousRiskIndicatorType $hazardousRiskIndicator
     * @param \Mnm\DeclaredCustomsValueAmountType $declaredCustomsValueAmount
     * @param \Mnm\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount
     * @param \Mnm\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount
     * @param \Mnm\FreeOnBoardValueAmountType $freeOnBoardValueAmount
     * @param \Mnm\InsuranceValueAmountType $insuranceValueAmount
     * @param \Mnm\ValueAmountType $valueAmount
     * @param \Mnm\GrossWeightMeasureType $grossWeightMeasure
     * @param \Mnm\NetWeightMeasureType $netWeightMeasure
     * @param \Mnm\ChargeableWeightMeasureType $chargeableWeightMeasure
     * @param \Mnm\GrossVolumeMeasureType $grossVolumeMeasure
     * @param \Mnm\NetVolumeMeasureType $netVolumeMeasure
     * @param \Mnm\QuantityType $quantity
     * @param \Mnm\RequiredCustomsIDType $requiredCustomsID
     * @param \Mnm\CustomsStatusCodeType $customsStatusCode
     * @param \Mnm\CustomsTariffQuantityType $customsTariffQuantity
     * @param \Mnm\CustomsImportClassifiedIndicatorType $customsImportClassifiedIndicator
     * @param \Mnm\ChargeableQuantityType $chargeableQuantity
     * @param \Mnm\ReturnableQuantityType $returnableQuantity
     * @param \Mnm\TraceIDType $traceID
     * @param \Mnm\ItemType[] $item
     * @param \Mnm\AllowanceChargeType[] $freightAllowanceCharge
     * @param \Mnm\InvoiceLineType[] $invoiceLine
     * @param \Mnm\TemperatureType[] $temperature
     * @param \Mnm\AddressType $originAddress
     * @param \Mnm\DimensionType[] $measurementDimension
     */
    public function __construct(\Mnm\IDType $iD = null, array $description = array(), \Mnm\HazardousRiskIndicatorType $hazardousRiskIndicator = null, \Mnm\DeclaredCustomsValueAmountType $declaredCustomsValueAmount = null, \Mnm\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount = null, \Mnm\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount = null, \Mnm\FreeOnBoardValueAmountType $freeOnBoardValueAmount = null, \Mnm\InsuranceValueAmountType $insuranceValueAmount = null, \Mnm\ValueAmountType $valueAmount = null, \Mnm\GrossWeightMeasureType $grossWeightMeasure = null, \Mnm\NetWeightMeasureType $netWeightMeasure = null, \Mnm\ChargeableWeightMeasureType $chargeableWeightMeasure = null, \Mnm\GrossVolumeMeasureType $grossVolumeMeasure = null, \Mnm\NetVolumeMeasureType $netVolumeMeasure = null, \Mnm\QuantityType $quantity = null, \Mnm\RequiredCustomsIDType $requiredCustomsID = null, \Mnm\CustomsStatusCodeType $customsStatusCode = null, \Mnm\CustomsTariffQuantityType $customsTariffQuantity = null, \Mnm\CustomsImportClassifiedIndicatorType $customsImportClassifiedIndicator = null, \Mnm\ChargeableQuantityType $chargeableQuantity = null, \Mnm\ReturnableQuantityType $returnableQuantity = null, \Mnm\TraceIDType $traceID = null, array $item = array(), array $freightAllowanceCharge = array(), array $invoiceLine = array(), array $temperature = array(), \Mnm\AddressType $originAddress = null, array $measurementDimension = array())
    {
        $this
            ->setID($iD)
            ->setDescription($description)
            ->setHazardousRiskIndicator($hazardousRiskIndicator)
            ->setDeclaredCustomsValueAmount($declaredCustomsValueAmount)
            ->setDeclaredForCarriageValueAmount($declaredForCarriageValueAmount)
            ->setDeclaredStatisticsValueAmount($declaredStatisticsValueAmount)
            ->setFreeOnBoardValueAmount($freeOnBoardValueAmount)
            ->setInsuranceValueAmount($insuranceValueAmount)
            ->setValueAmount($valueAmount)
            ->setGrossWeightMeasure($grossWeightMeasure)
            ->setNetWeightMeasure($netWeightMeasure)
            ->setChargeableWeightMeasure($chargeableWeightMeasure)
            ->setGrossVolumeMeasure($grossVolumeMeasure)
            ->setNetVolumeMeasure($netVolumeMeasure)
            ->setQuantity($quantity)
            ->setRequiredCustomsID($requiredCustomsID)
            ->setCustomsStatusCode($customsStatusCode)
            ->setCustomsTariffQuantity($customsTariffQuantity)
            ->setCustomsImportClassifiedIndicator($customsImportClassifiedIndicator)
            ->setChargeableQuantity($chargeableQuantity)
            ->setReturnableQuantity($returnableQuantity)
            ->setTraceID($traceID)
            ->setItem($item)
            ->setFreightAllowanceCharge($freightAllowanceCharge)
            ->setInvoiceLine($invoiceLine)
            ->setTemperature($temperature)
            ->setOriginAddress($originAddress)
            ->setMeasurementDimension($measurementDimension);
    }
    /**
     * Get ID value
     * @return \Mnm\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Mnm\IDType $iD
     * @return \Mnm\GoodsItemType
     */
    public function setID(\Mnm\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Description value
     * @return \Mnm\DescriptionType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \Mnm\DescriptionType[] $description
     * @return \Mnm\GoodsItemType
     */
    public function setDescription(array $description = array())
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \Mnm\DescriptionType $item
     * @return \Mnm\GoodsItemType
     */
    public function addToDescription(\Mnm\DescriptionType $item)
    {
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get HazardousRiskIndicator value
     * @return \Mnm\HazardousRiskIndicatorType|null
     */
    public function getHazardousRiskIndicator()
    {
        return $this->HazardousRiskIndicator;
    }
    /**
     * Set HazardousRiskIndicator value
     * @param \Mnm\HazardousRiskIndicatorType $hazardousRiskIndicator
     * @return \Mnm\GoodsItemType
     */
    public function setHazardousRiskIndicator(\Mnm\HazardousRiskIndicatorType $hazardousRiskIndicator = null)
    {
        $this->HazardousRiskIndicator = $hazardousRiskIndicator;
        return $this;
    }
    /**
     * Get DeclaredCustomsValueAmount value
     * @return \Mnm\DeclaredCustomsValueAmountType|null
     */
    public function getDeclaredCustomsValueAmount()
    {
        return $this->DeclaredCustomsValueAmount;
    }
    /**
     * Set DeclaredCustomsValueAmount value
     * @param \Mnm\DeclaredCustomsValueAmountType $declaredCustomsValueAmount
     * @return \Mnm\GoodsItemType
     */
    public function setDeclaredCustomsValueAmount(\Mnm\DeclaredCustomsValueAmountType $declaredCustomsValueAmount = null)
    {
        $this->DeclaredCustomsValueAmount = $declaredCustomsValueAmount;
        return $this;
    }
    /**
     * Get DeclaredForCarriageValueAmount value
     * @return \Mnm\DeclaredForCarriageValueAmountType|null
     */
    public function getDeclaredForCarriageValueAmount()
    {
        return $this->DeclaredForCarriageValueAmount;
    }
    /**
     * Set DeclaredForCarriageValueAmount value
     * @param \Mnm\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount
     * @return \Mnm\GoodsItemType
     */
    public function setDeclaredForCarriageValueAmount(\Mnm\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount = null)
    {
        $this->DeclaredForCarriageValueAmount = $declaredForCarriageValueAmount;
        return $this;
    }
    /**
     * Get DeclaredStatisticsValueAmount value
     * @return \Mnm\DeclaredStatisticsValueAmountType|null
     */
    public function getDeclaredStatisticsValueAmount()
    {
        return $this->DeclaredStatisticsValueAmount;
    }
    /**
     * Set DeclaredStatisticsValueAmount value
     * @param \Mnm\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount
     * @return \Mnm\GoodsItemType
     */
    public function setDeclaredStatisticsValueAmount(\Mnm\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount = null)
    {
        $this->DeclaredStatisticsValueAmount = $declaredStatisticsValueAmount;
        return $this;
    }
    /**
     * Get FreeOnBoardValueAmount value
     * @return \Mnm\FreeOnBoardValueAmountType|null
     */
    public function getFreeOnBoardValueAmount()
    {
        return $this->FreeOnBoardValueAmount;
    }
    /**
     * Set FreeOnBoardValueAmount value
     * @param \Mnm\FreeOnBoardValueAmountType $freeOnBoardValueAmount
     * @return \Mnm\GoodsItemType
     */
    public function setFreeOnBoardValueAmount(\Mnm\FreeOnBoardValueAmountType $freeOnBoardValueAmount = null)
    {
        $this->FreeOnBoardValueAmount = $freeOnBoardValueAmount;
        return $this;
    }
    /**
     * Get InsuranceValueAmount value
     * @return \Mnm\InsuranceValueAmountType|null
     */
    public function getInsuranceValueAmount()
    {
        return $this->InsuranceValueAmount;
    }
    /**
     * Set InsuranceValueAmount value
     * @param \Mnm\InsuranceValueAmountType $insuranceValueAmount
     * @return \Mnm\GoodsItemType
     */
    public function setInsuranceValueAmount(\Mnm\InsuranceValueAmountType $insuranceValueAmount = null)
    {
        $this->InsuranceValueAmount = $insuranceValueAmount;
        return $this;
    }
    /**
     * Get ValueAmount value
     * @return \Mnm\ValueAmountType|null
     */
    public function getValueAmount()
    {
        return $this->ValueAmount;
    }
    /**
     * Set ValueAmount value
     * @param \Mnm\ValueAmountType $valueAmount
     * @return \Mnm\GoodsItemType
     */
    public function setValueAmount(\Mnm\ValueAmountType $valueAmount = null)
    {
        $this->ValueAmount = $valueAmount;
        return $this;
    }
    /**
     * Get GrossWeightMeasure value
     * @return \Mnm\GrossWeightMeasureType|null
     */
    public function getGrossWeightMeasure()
    {
        return $this->GrossWeightMeasure;
    }
    /**
     * Set GrossWeightMeasure value
     * @param \Mnm\GrossWeightMeasureType $grossWeightMeasure
     * @return \Mnm\GoodsItemType
     */
    public function setGrossWeightMeasure(\Mnm\GrossWeightMeasureType $grossWeightMeasure = null)
    {
        $this->GrossWeightMeasure = $grossWeightMeasure;
        return $this;
    }
    /**
     * Get NetWeightMeasure value
     * @return \Mnm\NetWeightMeasureType|null
     */
    public function getNetWeightMeasure()
    {
        return $this->NetWeightMeasure;
    }
    /**
     * Set NetWeightMeasure value
     * @param \Mnm\NetWeightMeasureType $netWeightMeasure
     * @return \Mnm\GoodsItemType
     */
    public function setNetWeightMeasure(\Mnm\NetWeightMeasureType $netWeightMeasure = null)
    {
        $this->NetWeightMeasure = $netWeightMeasure;
        return $this;
    }
    /**
     * Get ChargeableWeightMeasure value
     * @return \Mnm\ChargeableWeightMeasureType|null
     */
    public function getChargeableWeightMeasure()
    {
        return $this->ChargeableWeightMeasure;
    }
    /**
     * Set ChargeableWeightMeasure value
     * @param \Mnm\ChargeableWeightMeasureType $chargeableWeightMeasure
     * @return \Mnm\GoodsItemType
     */
    public function setChargeableWeightMeasure(\Mnm\ChargeableWeightMeasureType $chargeableWeightMeasure = null)
    {
        $this->ChargeableWeightMeasure = $chargeableWeightMeasure;
        return $this;
    }
    /**
     * Get GrossVolumeMeasure value
     * @return \Mnm\GrossVolumeMeasureType|null
     */
    public function getGrossVolumeMeasure()
    {
        return $this->GrossVolumeMeasure;
    }
    /**
     * Set GrossVolumeMeasure value
     * @param \Mnm\GrossVolumeMeasureType $grossVolumeMeasure
     * @return \Mnm\GoodsItemType
     */
    public function setGrossVolumeMeasure(\Mnm\GrossVolumeMeasureType $grossVolumeMeasure = null)
    {
        $this->GrossVolumeMeasure = $grossVolumeMeasure;
        return $this;
    }
    /**
     * Get NetVolumeMeasure value
     * @return \Mnm\NetVolumeMeasureType|null
     */
    public function getNetVolumeMeasure()
    {
        return $this->NetVolumeMeasure;
    }
    /**
     * Set NetVolumeMeasure value
     * @param \Mnm\NetVolumeMeasureType $netVolumeMeasure
     * @return \Mnm\GoodsItemType
     */
    public function setNetVolumeMeasure(\Mnm\NetVolumeMeasureType $netVolumeMeasure = null)
    {
        $this->NetVolumeMeasure = $netVolumeMeasure;
        return $this;
    }
    /**
     * Get Quantity value
     * @return \Mnm\QuantityType|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param \Mnm\QuantityType $quantity
     * @return \Mnm\GoodsItemType
     */
    public function setQuantity(\Mnm\QuantityType $quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get RequiredCustomsID value
     * @return \Mnm\RequiredCustomsIDType|null
     */
    public function getRequiredCustomsID()
    {
        return $this->RequiredCustomsID;
    }
    /**
     * Set RequiredCustomsID value
     * @param \Mnm\RequiredCustomsIDType $requiredCustomsID
     * @return \Mnm\GoodsItemType
     */
    public function setRequiredCustomsID(\Mnm\RequiredCustomsIDType $requiredCustomsID = null)
    {
        $this->RequiredCustomsID = $requiredCustomsID;
        return $this;
    }
    /**
     * Get CustomsStatusCode value
     * @return \Mnm\CustomsStatusCodeType|null
     */
    public function getCustomsStatusCode()
    {
        return $this->CustomsStatusCode;
    }
    /**
     * Set CustomsStatusCode value
     * @param \Mnm\CustomsStatusCodeType $customsStatusCode
     * @return \Mnm\GoodsItemType
     */
    public function setCustomsStatusCode(\Mnm\CustomsStatusCodeType $customsStatusCode = null)
    {
        $this->CustomsStatusCode = $customsStatusCode;
        return $this;
    }
    /**
     * Get CustomsTariffQuantity value
     * @return \Mnm\CustomsTariffQuantityType|null
     */
    public function getCustomsTariffQuantity()
    {
        return $this->CustomsTariffQuantity;
    }
    /**
     * Set CustomsTariffQuantity value
     * @param \Mnm\CustomsTariffQuantityType $customsTariffQuantity
     * @return \Mnm\GoodsItemType
     */
    public function setCustomsTariffQuantity(\Mnm\CustomsTariffQuantityType $customsTariffQuantity = null)
    {
        $this->CustomsTariffQuantity = $customsTariffQuantity;
        return $this;
    }
    /**
     * Get CustomsImportClassifiedIndicator value
     * @return \Mnm\CustomsImportClassifiedIndicatorType|null
     */
    public function getCustomsImportClassifiedIndicator()
    {
        return $this->CustomsImportClassifiedIndicator;
    }
    /**
     * Set CustomsImportClassifiedIndicator value
     * @param \Mnm\CustomsImportClassifiedIndicatorType $customsImportClassifiedIndicator
     * @return \Mnm\GoodsItemType
     */
    public function setCustomsImportClassifiedIndicator(\Mnm\CustomsImportClassifiedIndicatorType $customsImportClassifiedIndicator = null)
    {
        $this->CustomsImportClassifiedIndicator = $customsImportClassifiedIndicator;
        return $this;
    }
    /**
     * Get ChargeableQuantity value
     * @return \Mnm\ChargeableQuantityType|null
     */
    public function getChargeableQuantity()
    {
        return $this->ChargeableQuantity;
    }
    /**
     * Set ChargeableQuantity value
     * @param \Mnm\ChargeableQuantityType $chargeableQuantity
     * @return \Mnm\GoodsItemType
     */
    public function setChargeableQuantity(\Mnm\ChargeableQuantityType $chargeableQuantity = null)
    {
        $this->ChargeableQuantity = $chargeableQuantity;
        return $this;
    }
    /**
     * Get ReturnableQuantity value
     * @return \Mnm\ReturnableQuantityType|null
     */
    public function getReturnableQuantity()
    {
        return $this->ReturnableQuantity;
    }
    /**
     * Set ReturnableQuantity value
     * @param \Mnm\ReturnableQuantityType $returnableQuantity
     * @return \Mnm\GoodsItemType
     */
    public function setReturnableQuantity(\Mnm\ReturnableQuantityType $returnableQuantity = null)
    {
        $this->ReturnableQuantity = $returnableQuantity;
        return $this;
    }
    /**
     * Get TraceID value
     * @return \Mnm\TraceIDType|null
     */
    public function getTraceID()
    {
        return $this->TraceID;
    }
    /**
     * Set TraceID value
     * @param \Mnm\TraceIDType $traceID
     * @return \Mnm\GoodsItemType
     */
    public function setTraceID(\Mnm\TraceIDType $traceID = null)
    {
        $this->TraceID = $traceID;
        return $this;
    }
    /**
     * Get Item value
     * @return \Mnm\ItemType[]|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @param \Mnm\ItemType[] $item
     * @return \Mnm\GoodsItemType
     */
    public function setItem(array $item = array())
    {
        $this->Item = $item;
        return $this;
    }
    /**
     * Add item to Item value
     * @throws \InvalidArgumentException
     * @param \Mnm\ItemType $item
     * @return \Mnm\GoodsItemType
     */
    public function addToItem(\Mnm\ItemType $item)
    {
        $this->Item[] = $item;
        return $this;
    }
    /**
     * Get FreightAllowanceCharge value
     * @return \Mnm\AllowanceChargeType[]|null
     */
    public function getFreightAllowanceCharge()
    {
        return $this->FreightAllowanceCharge;
    }
    /**
     * Set FreightAllowanceCharge value
     * @param \Mnm\AllowanceChargeType[] $freightAllowanceCharge
     * @return \Mnm\GoodsItemType
     */
    public function setFreightAllowanceCharge(array $freightAllowanceCharge = array())
    {
        $this->FreightAllowanceCharge = $freightAllowanceCharge;
        return $this;
    }
    /**
     * Add item to FreightAllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \Mnm\AllowanceChargeType $item
     * @return \Mnm\GoodsItemType
     */
    public function addToFreightAllowanceCharge(\Mnm\AllowanceChargeType $item)
    {
        $this->FreightAllowanceCharge[] = $item;
        return $this;
    }
    /**
     * Get InvoiceLine value
     * @return \Mnm\InvoiceLineType[]|null
     */
    public function getInvoiceLine()
    {
        return $this->InvoiceLine;
    }
    /**
     * Set InvoiceLine value
     * @param \Mnm\InvoiceLineType[] $invoiceLine
     * @return \Mnm\GoodsItemType
     */
    public function setInvoiceLine(array $invoiceLine = array())
    {
        $this->InvoiceLine = $invoiceLine;
        return $this;
    }
    /**
     * Add item to InvoiceLine value
     * @throws \InvalidArgumentException
     * @param \Mnm\InvoiceLineType $item
     * @return \Mnm\GoodsItemType
     */
    public function addToInvoiceLine(\Mnm\InvoiceLineType $item)
    {
        $this->InvoiceLine[] = $item;
        return $this;
    }
    /**
     * Get Temperature value
     * @return \Mnm\TemperatureType[]|null
     */
    public function getTemperature()
    {
        return $this->Temperature;
    }
    /**
     * Set Temperature value
     * @param \Mnm\TemperatureType[] $temperature
     * @return \Mnm\GoodsItemType
     */
    public function setTemperature(array $temperature = array())
    {
        $this->Temperature = $temperature;
        return $this;
    }
    /**
     * Add item to Temperature value
     * @throws \InvalidArgumentException
     * @param \Mnm\TemperatureType $item
     * @return \Mnm\GoodsItemType
     */
    public function addToTemperature(\Mnm\TemperatureType $item)
    {
        $this->Temperature[] = $item;
        return $this;
    }
    /**
     * Get OriginAddress value
     * @return \Mnm\AddressType|null
     */
    public function getOriginAddress()
    {
        return $this->OriginAddress;
    }
    /**
     * Set OriginAddress value
     * @param \Mnm\AddressType $originAddress
     * @return \Mnm\GoodsItemType
     */
    public function setOriginAddress(\Mnm\AddressType $originAddress = null)
    {
        $this->OriginAddress = $originAddress;
        return $this;
    }
    /**
     * Get MeasurementDimension value
     * @return \Mnm\DimensionType[]|null
     */
    public function getMeasurementDimension()
    {
        return $this->MeasurementDimension;
    }
    /**
     * Set MeasurementDimension value
     * @param \Mnm\DimensionType[] $measurementDimension
     * @return \Mnm\GoodsItemType
     */
    public function setMeasurementDimension(array $measurementDimension = array())
    {
        $this->MeasurementDimension = $measurementDimension;
        return $this;
    }
    /**
     * Add item to MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \Mnm\DimensionType $item
     * @return \Mnm\GoodsItemType
     */
    public function addToMeasurementDimension(\Mnm\DimensionType $item)
    {
        $this->MeasurementDimension[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\GoodsItemType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
