<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExchangeRateType StructType
 * @subpackage Structs
 */
class ExchangeRateType extends AbstractStructBase
{
    /**
     * The SourceCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q248:SourceCurrencyCode
     * @var \Mnm\SourceCurrencyCodeType
     */
    public $SourceCurrencyCode;
    /**
     * The TargetCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q249:TargetCurrencyCode
     * @var \Mnm\TargetCurrencyCodeType
     */
    public $TargetCurrencyCode;
    /**
     * The CalculationRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q250:CalculationRate
     * @var \Mnm\CalculationRateType
     */
    public $CalculationRate;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q251:Date
     * @var \Mnm\DateType
     */
    public $Date;
    /**
     * Constructor method for ExchangeRateType
     * @uses ExchangeRateType::setSourceCurrencyCode()
     * @uses ExchangeRateType::setTargetCurrencyCode()
     * @uses ExchangeRateType::setCalculationRate()
     * @uses ExchangeRateType::setDate()
     * @param \Mnm\SourceCurrencyCodeType $sourceCurrencyCode
     * @param \Mnm\TargetCurrencyCodeType $targetCurrencyCode
     * @param \Mnm\CalculationRateType $calculationRate
     * @param \Mnm\DateType $date
     */
    public function __construct(\Mnm\SourceCurrencyCodeType $sourceCurrencyCode = null, \Mnm\TargetCurrencyCodeType $targetCurrencyCode = null, \Mnm\CalculationRateType $calculationRate = null, \Mnm\DateType $date = null)
    {
        $this
            ->setSourceCurrencyCode($sourceCurrencyCode)
            ->setTargetCurrencyCode($targetCurrencyCode)
            ->setCalculationRate($calculationRate)
            ->setDate($date);
    }
    /**
     * Get SourceCurrencyCode value
     * @return \Mnm\SourceCurrencyCodeType|null
     */
    public function getSourceCurrencyCode()
    {
        return $this->SourceCurrencyCode;
    }
    /**
     * Set SourceCurrencyCode value
     * @param \Mnm\SourceCurrencyCodeType $sourceCurrencyCode
     * @return \Mnm\ExchangeRateType
     */
    public function setSourceCurrencyCode(\Mnm\SourceCurrencyCodeType $sourceCurrencyCode = null)
    {
        $this->SourceCurrencyCode = $sourceCurrencyCode;
        return $this;
    }
    /**
     * Get TargetCurrencyCode value
     * @return \Mnm\TargetCurrencyCodeType|null
     */
    public function getTargetCurrencyCode()
    {
        return $this->TargetCurrencyCode;
    }
    /**
     * Set TargetCurrencyCode value
     * @param \Mnm\TargetCurrencyCodeType $targetCurrencyCode
     * @return \Mnm\ExchangeRateType
     */
    public function setTargetCurrencyCode(\Mnm\TargetCurrencyCodeType $targetCurrencyCode = null)
    {
        $this->TargetCurrencyCode = $targetCurrencyCode;
        return $this;
    }
    /**
     * Get CalculationRate value
     * @return \Mnm\CalculationRateType|null
     */
    public function getCalculationRate()
    {
        return $this->CalculationRate;
    }
    /**
     * Set CalculationRate value
     * @param \Mnm\CalculationRateType $calculationRate
     * @return \Mnm\ExchangeRateType
     */
    public function setCalculationRate(\Mnm\CalculationRateType $calculationRate = null)
    {
        $this->CalculationRate = $calculationRate;
        return $this;
    }
    /**
     * Get Date value
     * @return \Mnm\DateType|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param \Mnm\DateType $date
     * @return \Mnm\ExchangeRateType
     */
    public function setDate(\Mnm\DateType $date = null)
    {
        $this->Date = $date;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\ExchangeRateType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
