<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EnvelopeData StructType
 * @subpackage Structs
 */
class EnvelopeData extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StatusCode;
    /**
     * The Envelope
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Envelope;
    /**
     * The EnvelopeIdentifier
     * @var string
     */
    public $EnvelopeIdentifier;
    /**
     * Constructor method for EnvelopeData
     * @uses EnvelopeData::setStatus()
     * @uses EnvelopeData::setStatusCode()
     * @uses EnvelopeData::setEnvelope()
     * @uses EnvelopeData::setEnvelopeIdentifier()
     * @param string $status
     * @param int $statusCode
     * @param string $envelope
     * @param string $envelopeIdentifier
     */
    public function __construct($status = null, $statusCode = null, $envelope = null, $envelopeIdentifier = null)
    {
        $this
            ->setStatus($status)
            ->setStatusCode($statusCode)
            ->setEnvelope($envelope)
            ->setEnvelopeIdentifier($envelopeIdentifier);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Mnm\EnvelopeData
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return int
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param int $statusCode
     * @return \Mnm\EnvelopeData
     */
    public function setStatusCode($statusCode = null)
    {
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get Envelope value
     * @return string|null
     */
    public function getEnvelope()
    {
        return $this->Envelope;
    }
    /**
     * Set Envelope value
     * @param string $envelope
     * @return \Mnm\EnvelopeData
     */
    public function setEnvelope($envelope = null)
    {
        $this->Envelope = $envelope;
        return $this;
    }
    /**
     * Get EnvelopeIdentifier value
     * @return string|null
     */
    public function getEnvelopeIdentifier()
    {
        return $this->EnvelopeIdentifier;
    }
    /**
     * Set EnvelopeIdentifier value
     * @param string $envelopeIdentifier
     * @return \Mnm\EnvelopeData
     */
    public function setEnvelopeIdentifier($envelopeIdentifier = null)
    {
        $this->EnvelopeIdentifier = $envelopeIdentifier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\EnvelopeData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
