<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentResponseInfo StructType
 * @subpackage Structs
 */
class DocumentResponseInfo extends AbstractStructBase
{
    /**
     * The ResponseStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ResponseStatus;
    /**
     * The LineResponses
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\ArrayOfLineResponseInfo
     */
    public $LineResponses;
    /**
     * The InvoiceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceId;
    /**
     * The Reason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reason;
    /**
     * Constructor method for DocumentResponseInfo
     * @uses DocumentResponseInfo::setResponseStatus()
     * @uses DocumentResponseInfo::setLineResponses()
     * @uses DocumentResponseInfo::setInvoiceId()
     * @uses DocumentResponseInfo::setReason()
     * @param string $responseStatus
     * @param \Mnm\ArrayOfLineResponseInfo $lineResponses
     * @param string $invoiceId
     * @param string $reason
     */
    public function __construct($responseStatus = null, \Mnm\ArrayOfLineResponseInfo $lineResponses = null, $invoiceId = null, $reason = null)
    {
        $this
            ->setResponseStatus($responseStatus)
            ->setLineResponses($lineResponses)
            ->setInvoiceId($invoiceId)
            ->setReason($reason);
    }
    /**
     * Get ResponseStatus value
     * @return string
     */
    public function getResponseStatus()
    {
        return $this->ResponseStatus;
    }
    /**
     * Set ResponseStatus value
     * @param string $responseStatus
     * @return \Mnm\DocumentResponseInfo
     */
    public function setResponseStatus($responseStatus = null)
    {
        $this->ResponseStatus = $responseStatus;
        return $this;
    }
    /**
     * Get LineResponses value
     * @return \Mnm\ArrayOfLineResponseInfo|null
     */
    public function getLineResponses()
    {
        return $this->LineResponses;
    }
    /**
     * Set LineResponses value
     * @param \Mnm\ArrayOfLineResponseInfo $lineResponses
     * @return \Mnm\DocumentResponseInfo
     */
    public function setLineResponses(\Mnm\ArrayOfLineResponseInfo $lineResponses = null)
    {
        $this->LineResponses = $lineResponses;
        return $this;
    }
    /**
     * Get InvoiceId value
     * @return string|null
     */
    public function getInvoiceId()
    {
        return $this->InvoiceId;
    }
    /**
     * Set InvoiceId value
     * @param string $invoiceId
     * @return \Mnm\DocumentResponseInfo
     */
    public function setInvoiceId($invoiceId = null)
    {
        $this->InvoiceId = $invoiceId;
        return $this;
    }
    /**
     * Get Reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param string $reason
     * @return \Mnm\DocumentResponseInfo
     */
    public function setReason($reason = null)
    {
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\DocumentResponseInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
