<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentReferenceType StructType
 * @subpackage Structs
 */
class DocumentReferenceType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q11:ID
     * @var \Mnm\IDType
     */
    public $ID;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q12:IssueDate
     * @var \Mnm\IssueDateType
     */
    public $IssueDate;
    /**
     * The DocumentTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q13:DocumentTypeCode
     * @var \Mnm\DocumentTypeCodeType
     */
    public $DocumentTypeCode;
    /**
     * The DocumentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q14:DocumentType
     * @var \Mnm\DocumentTypeType
     */
    public $DocumentType;
    /**
     * The DocumentDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q15:DocumentDescription
     * @var \Mnm\DocumentDescriptionType[]
     */
    public $DocumentDescription;
    /**
     * The Attachment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\AttachmentType
     */
    public $Attachment;
    /**
     * The ValidityPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\PeriodType
     */
    public $ValidityPeriod;
    /**
     * The IssuerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\PartyType
     */
    public $IssuerParty;
    /**
     * Constructor method for DocumentReferenceType
     * @uses DocumentReferenceType::setID()
     * @uses DocumentReferenceType::setIssueDate()
     * @uses DocumentReferenceType::setDocumentTypeCode()
     * @uses DocumentReferenceType::setDocumentType()
     * @uses DocumentReferenceType::setDocumentDescription()
     * @uses DocumentReferenceType::setAttachment()
     * @uses DocumentReferenceType::setValidityPeriod()
     * @uses DocumentReferenceType::setIssuerParty()
     * @param \Mnm\IDType $iD
     * @param \Mnm\IssueDateType $issueDate
     * @param \Mnm\DocumentTypeCodeType $documentTypeCode
     * @param \Mnm\DocumentTypeType $documentType
     * @param \Mnm\DocumentDescriptionType[] $documentDescription
     * @param \Mnm\AttachmentType $attachment
     * @param \Mnm\PeriodType $validityPeriod
     * @param \Mnm\PartyType $issuerParty
     */
    public function __construct(\Mnm\IDType $iD = null, \Mnm\IssueDateType $issueDate = null, \Mnm\DocumentTypeCodeType $documentTypeCode = null, \Mnm\DocumentTypeType $documentType = null, array $documentDescription = array(), \Mnm\AttachmentType $attachment = null, \Mnm\PeriodType $validityPeriod = null, \Mnm\PartyType $issuerParty = null)
    {
        $this
            ->setID($iD)
            ->setIssueDate($issueDate)
            ->setDocumentTypeCode($documentTypeCode)
            ->setDocumentType($documentType)
            ->setDocumentDescription($documentDescription)
            ->setAttachment($attachment)
            ->setValidityPeriod($validityPeriod)
            ->setIssuerParty($issuerParty);
    }
    /**
     * Get ID value
     * @return \Mnm\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Mnm\IDType $iD
     * @return \Mnm\DocumentReferenceType
     */
    public function setID(\Mnm\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return \Mnm\IssueDateType|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param \Mnm\IssueDateType $issueDate
     * @return \Mnm\DocumentReferenceType
     */
    public function setIssueDate(\Mnm\IssueDateType $issueDate = null)
    {
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get DocumentTypeCode value
     * @return \Mnm\DocumentTypeCodeType|null
     */
    public function getDocumentTypeCode()
    {
        return $this->DocumentTypeCode;
    }
    /**
     * Set DocumentTypeCode value
     * @param \Mnm\DocumentTypeCodeType $documentTypeCode
     * @return \Mnm\DocumentReferenceType
     */
    public function setDocumentTypeCode(\Mnm\DocumentTypeCodeType $documentTypeCode = null)
    {
        $this->DocumentTypeCode = $documentTypeCode;
        return $this;
    }
    /**
     * Get DocumentType value
     * @return \Mnm\DocumentTypeType|null
     */
    public function getDocumentType()
    {
        return $this->DocumentType;
    }
    /**
     * Set DocumentType value
     * @param \Mnm\DocumentTypeType $documentType
     * @return \Mnm\DocumentReferenceType
     */
    public function setDocumentType(\Mnm\DocumentTypeType $documentType = null)
    {
        $this->DocumentType = $documentType;
        return $this;
    }
    /**
     * Get DocumentDescription value
     * @return \Mnm\DocumentDescriptionType[]|null
     */
    public function getDocumentDescription()
    {
        return $this->DocumentDescription;
    }
    /**
     * Set DocumentDescription value
     * @param \Mnm\DocumentDescriptionType[] $documentDescription
     * @return \Mnm\DocumentReferenceType
     */
    public function setDocumentDescription(array $documentDescription = array())
    {
        $this->DocumentDescription = $documentDescription;
        return $this;
    }
    /**
     * Add item to DocumentDescription value
     * @throws \InvalidArgumentException
     * @param \Mnm\DocumentDescriptionType $item
     * @return \Mnm\DocumentReferenceType
     */
    public function addToDocumentDescription(\Mnm\DocumentDescriptionType $item)
    {
        $this->DocumentDescription[] = $item;
        return $this;
    }
    /**
     * Get Attachment value
     * @return \Mnm\AttachmentType|null
     */
    public function getAttachment()
    {
        return $this->Attachment;
    }
    /**
     * Set Attachment value
     * @param \Mnm\AttachmentType $attachment
     * @return \Mnm\DocumentReferenceType
     */
    public function setAttachment(\Mnm\AttachmentType $attachment = null)
    {
        $this->Attachment = $attachment;
        return $this;
    }
    /**
     * Get ValidityPeriod value
     * @return \Mnm\PeriodType|null
     */
    public function getValidityPeriod()
    {
        return $this->ValidityPeriod;
    }
    /**
     * Set ValidityPeriod value
     * @param \Mnm\PeriodType $validityPeriod
     * @return \Mnm\DocumentReferenceType
     */
    public function setValidityPeriod(\Mnm\PeriodType $validityPeriod = null)
    {
        $this->ValidityPeriod = $validityPeriod;
        return $this;
    }
    /**
     * Get IssuerParty value
     * @return \Mnm\PartyType|null
     */
    public function getIssuerParty()
    {
        return $this->IssuerParty;
    }
    /**
     * Set IssuerParty value
     * @param \Mnm\PartyType $issuerParty
     * @return \Mnm\DocumentReferenceType
     */
    public function setIssuerParty(\Mnm\PartyType $issuerParty = null)
    {
        $this->IssuerParty = $issuerParty;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\DocumentReferenceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
