<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DespatchType StructType
 * @subpackage Structs
 */
class DespatchType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q89:ID
     * @var \Mnm\IDType
     */
    public $ID;
    /**
     * The ActualDespatchDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q90:ActualDespatchDate
     * @var \Mnm\ActualDespatchDateType
     */
    public $ActualDespatchDate;
    /**
     * The ActualDespatchTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q91:ActualDespatchTime
     * @var \Mnm\ActualDespatchTimeType
     */
    public $ActualDespatchTime;
    /**
     * The Instructions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q92:Instructions
     * @var \Mnm\InstructionsType
     */
    public $Instructions;
    /**
     * The DespatchAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\AddressType
     */
    public $DespatchAddress;
    /**
     * The DespatchParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\PartyType
     */
    public $DespatchParty;
    /**
     * The Contact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\ContactType
     */
    public $Contact;
    /**
     * The EstimatedDespatchPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\PeriodType
     */
    public $EstimatedDespatchPeriod;
    /**
     * Constructor method for DespatchType
     * @uses DespatchType::setID()
     * @uses DespatchType::setActualDespatchDate()
     * @uses DespatchType::setActualDespatchTime()
     * @uses DespatchType::setInstructions()
     * @uses DespatchType::setDespatchAddress()
     * @uses DespatchType::setDespatchParty()
     * @uses DespatchType::setContact()
     * @uses DespatchType::setEstimatedDespatchPeriod()
     * @param \Mnm\IDType $iD
     * @param \Mnm\ActualDespatchDateType $actualDespatchDate
     * @param \Mnm\ActualDespatchTimeType $actualDespatchTime
     * @param \Mnm\InstructionsType $instructions
     * @param \Mnm\AddressType $despatchAddress
     * @param \Mnm\PartyType $despatchParty
     * @param \Mnm\ContactType $contact
     * @param \Mnm\PeriodType $estimatedDespatchPeriod
     */
    public function __construct(\Mnm\IDType $iD = null, \Mnm\ActualDespatchDateType $actualDespatchDate = null, \Mnm\ActualDespatchTimeType $actualDespatchTime = null, \Mnm\InstructionsType $instructions = null, \Mnm\AddressType $despatchAddress = null, \Mnm\PartyType $despatchParty = null, \Mnm\ContactType $contact = null, \Mnm\PeriodType $estimatedDespatchPeriod = null)
    {
        $this
            ->setID($iD)
            ->setActualDespatchDate($actualDespatchDate)
            ->setActualDespatchTime($actualDespatchTime)
            ->setInstructions($instructions)
            ->setDespatchAddress($despatchAddress)
            ->setDespatchParty($despatchParty)
            ->setContact($contact)
            ->setEstimatedDespatchPeriod($estimatedDespatchPeriod);
    }
    /**
     * Get ID value
     * @return \Mnm\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Mnm\IDType $iD
     * @return \Mnm\DespatchType
     */
    public function setID(\Mnm\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get ActualDespatchDate value
     * @return \Mnm\ActualDespatchDateType|null
     */
    public function getActualDespatchDate()
    {
        return $this->ActualDespatchDate;
    }
    /**
     * Set ActualDespatchDate value
     * @param \Mnm\ActualDespatchDateType $actualDespatchDate
     * @return \Mnm\DespatchType
     */
    public function setActualDespatchDate(\Mnm\ActualDespatchDateType $actualDespatchDate = null)
    {
        $this->ActualDespatchDate = $actualDespatchDate;
        return $this;
    }
    /**
     * Get ActualDespatchTime value
     * @return \Mnm\ActualDespatchTimeType|null
     */
    public function getActualDespatchTime()
    {
        return $this->ActualDespatchTime;
    }
    /**
     * Set ActualDespatchTime value
     * @param \Mnm\ActualDespatchTimeType $actualDespatchTime
     * @return \Mnm\DespatchType
     */
    public function setActualDespatchTime(\Mnm\ActualDespatchTimeType $actualDespatchTime = null)
    {
        $this->ActualDespatchTime = $actualDespatchTime;
        return $this;
    }
    /**
     * Get Instructions value
     * @return \Mnm\InstructionsType|null
     */
    public function getInstructions()
    {
        return $this->Instructions;
    }
    /**
     * Set Instructions value
     * @param \Mnm\InstructionsType $instructions
     * @return \Mnm\DespatchType
     */
    public function setInstructions(\Mnm\InstructionsType $instructions = null)
    {
        $this->Instructions = $instructions;
        return $this;
    }
    /**
     * Get DespatchAddress value
     * @return \Mnm\AddressType|null
     */
    public function getDespatchAddress()
    {
        return $this->DespatchAddress;
    }
    /**
     * Set DespatchAddress value
     * @param \Mnm\AddressType $despatchAddress
     * @return \Mnm\DespatchType
     */
    public function setDespatchAddress(\Mnm\AddressType $despatchAddress = null)
    {
        $this->DespatchAddress = $despatchAddress;
        return $this;
    }
    /**
     * Get DespatchParty value
     * @return \Mnm\PartyType|null
     */
    public function getDespatchParty()
    {
        return $this->DespatchParty;
    }
    /**
     * Set DespatchParty value
     * @param \Mnm\PartyType $despatchParty
     * @return \Mnm\DespatchType
     */
    public function setDespatchParty(\Mnm\PartyType $despatchParty = null)
    {
        $this->DespatchParty = $despatchParty;
        return $this;
    }
    /**
     * Get Contact value
     * @return \Mnm\ContactType|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \Mnm\ContactType $contact
     * @return \Mnm\DespatchType
     */
    public function setContact(\Mnm\ContactType $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get EstimatedDespatchPeriod value
     * @return \Mnm\PeriodType|null
     */
    public function getEstimatedDespatchPeriod()
    {
        return $this->EstimatedDespatchPeriod;
    }
    /**
     * Set EstimatedDespatchPeriod value
     * @param \Mnm\PeriodType $estimatedDespatchPeriod
     * @return \Mnm\DespatchType
     */
    public function setEstimatedDespatchPeriod(\Mnm\PeriodType $estimatedDespatchPeriod = null)
    {
        $this->EstimatedDespatchPeriod = $estimatedDespatchPeriod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\DespatchType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
