<?php

namespace Mnm;

/**
 * This class stands for CustomerType EnumType
 * @subpackage Enumerations
 */
class CustomerType
{
    /**
     * Constant for value 'Enterprise'
     * @return string 'Enterprise'
     */
    const VALUE_ENTERPRISE = 'Enterprise';
    /**
     * Constant for value 'Person'
     * @return string 'Person'
     */
    const VALUE_PERSON = 'Person';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ENTERPRISE
     * @uses self::VALUE_PERSON
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ENTERPRISE,
            self::VALUE_PERSON,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
