<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CloneInvoices StructType
 * @subpackage Structs
 */
class CloneInvoices extends AbstractStructBase
{
    /**
     * The userInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\UserInformation
     */
    public $userInfo;
    /**
     * The invoiceIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\ArrayOfString
     */
    public $invoiceIds;
    /**
     * Constructor method for CloneInvoices
     * @uses CloneInvoices::setUserInfo()
     * @uses CloneInvoices::setInvoiceIds()
     * @param \Mnm\UserInformation $userInfo
     * @param \Mnm\ArrayOfString $invoiceIds
     */
    public function __construct(\Mnm\UserInformation $userInfo = null, \Mnm\ArrayOfString $invoiceIds = null)
    {
        $this
            ->setUserInfo($userInfo)
            ->setInvoiceIds($invoiceIds);
    }
    /**
     * Get userInfo value
     * @return \Mnm\UserInformation|null
     */
    public function getUserInfo()
    {
        return $this->userInfo;
    }
    /**
     * Set userInfo value
     * @param \Mnm\UserInformation $userInfo
     * @return \Mnm\CloneInvoices
     */
    public function setUserInfo(\Mnm\UserInformation $userInfo = null)
    {
        $this->userInfo = $userInfo;
        return $this;
    }
    /**
     * Get invoiceIds value
     * @return \Mnm\ArrayOfString|null
     */
    public function getInvoiceIds()
    {
        return $this->invoiceIds;
    }
    /**
     * Set invoiceIds value
     * @param \Mnm\ArrayOfString $invoiceIds
     * @return \Mnm\CloneInvoices
     */
    public function setInvoiceIds(\Mnm\ArrayOfString $invoiceIds = null)
    {
        $this->invoiceIds = $invoiceIds;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\CloneInvoices
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
