<?php

namespace Mnm;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'SignatureType' => '\\Mnm\\SignatureType',
            'SignedInfoType' => '\\Mnm\\SignedInfoType',
            'CanonicalizationMethodType' => '\\Mnm\\CanonicalizationMethodType',
            'SignatureMethodType' => '\\Mnm\\SignatureMethodType',
            'ReferenceType' => '\\Mnm\\ReferenceType',
            'ArrayOfTransformType' => '\\Mnm\\ArrayOfTransformType',
            'TransformType' => '\\Mnm\\TransformType',
            'DigestMethodType' => '\\Mnm\\DigestMethodType',
            'SignatureValueType' => '\\Mnm\\SignatureValueType',
            'KeyInfoType' => '\\Mnm\\KeyInfoType',
            'X509DataType' => '\\Mnm\\X509DataType',
            'X509IssuerSerialType' => '\\Mnm\\X509IssuerSerialType',
            'RetrievalMethodType' => '\\Mnm\\RetrievalMethodType',
            'PGPDataType' => '\\Mnm\\PGPDataType',
            'KeyValueType' => '\\Mnm\\KeyValueType',
            'DSAKeyValueType' => '\\Mnm\\DSAKeyValueType',
            'RSAKeyValueType' => '\\Mnm\\RSAKeyValueType',
            'SPKIDataType' => '\\Mnm\\SPKIDataType',
            'ObjectType' => '\\Mnm\\ObjectType',
            'IdentifierType' => '\\Mnm\\IdentifierType',
            'CodeType' => '\\Mnm\\CodeType',
            'TextType' => '\\Mnm\\TextType',
            'NumericType' => '\\Mnm\\NumericType',
            'MeasureType' => '\\Mnm\\MeasureType',
            'BinaryObjectType' => '\\Mnm\\BinaryObjectType',
            'AmountType' => '\\Mnm\\AmountType',
            'QuantityType' => '\\Mnm\\QuantityType',
            'IndicatorType' => '\\Mnm\\IndicatorType',
            'DateType' => '\\Mnm\\DateType',
            'TimeType' => '\\Mnm\\TimeType',
            'NameType' => '\\Mnm\\NameType',
            'ValueType' => '\\Mnm\\ValueType',
            'RateType' => '\\Mnm\\RateType',
            'PercentType' => '\\Mnm\\PercentType',
            'GraphicType' => '\\Mnm\\GraphicType',
            'PictureType' => '\\Mnm\\PictureType',
            'SoundType' => '\\Mnm\\SoundType',
            'VideoType' => '\\Mnm\\VideoType',
            'ArrayOfUBLExtensionType' => '\\Mnm\\ArrayOfUBLExtensionType',
            'UBLExtensionType' => '\\Mnm\\UBLExtensionType',
            'ExtensionContentType' => '\\Mnm\\ExtensionContentType',
            'ExtensionVersionIDType' => '\\Mnm\\ExtensionVersionIDType',
            'ExtensionURIType' => '\\Mnm\\ExtensionURIType',
            'ExtensionAgencyIDType' => '\\Mnm\\ExtensionAgencyIDType',
            'ExtensionAgencyURIType' => '\\Mnm\\ExtensionAgencyURIType',
            'ExtensionReasonCodeType' => '\\Mnm\\ExtensionReasonCodeType',
            'ExtensionReasonType' => '\\Mnm\\ExtensionReasonType',
            'ExtensionAgencyNameType' => '\\Mnm\\ExtensionAgencyNameType',
            'UBLVersionIDType' => '\\Mnm\\UBLVersionIDType',
            'SchemeURIType' => '\\Mnm\\SchemeURIType',
            'SecurityIDType' => '\\Mnm\\SecurityIDType',
            'SalesOrderLineIDType' => '\\Mnm\\SalesOrderLineIDType',
            'SerialIDType' => '\\Mnm\\SerialIDType',
            'ShippingOrderIDType' => '\\Mnm\\ShippingOrderIDType',
            'SpecificationIDType' => '\\Mnm\\SpecificationIDType',
            'SequenceNumberIDType' => '\\Mnm\\SequenceNumberIDType',
            'SignatureIDType' => '\\Mnm\\SignatureIDType',
            'SellerEventIDType' => '\\Mnm\\SellerEventIDType',
            'SequenceIDType' => '\\Mnm\\SequenceIDType',
            'RegistrationIDType' => '\\Mnm\\RegistrationIDType',
            'RegistrationNationalityIDType' => '\\Mnm\\RegistrationNationalityIDType',
            'ReferencedConsignmentIDType' => '\\Mnm\\ReferencedConsignmentIDType',
            'RailCarIDType' => '\\Mnm\\RailCarIDType',
            'ReferenceIDType' => '\\Mnm\\ReferenceIDType',
            'RevisedForecastLineIDType' => '\\Mnm\\RevisedForecastLineIDType',
            'SalesOrderIDType' => '\\Mnm\\SalesOrderIDType',
            'RequiredCustomsIDType' => '\\Mnm\\RequiredCustomsIDType',
            'ReleaseIDType' => '\\Mnm\\ReleaseIDType',
            'RequestForQuotationLineIDType' => '\\Mnm\\RequestForQuotationLineIDType',
            'VersionIDType' => '\\Mnm\\VersionIDType',
            'VesselIDType' => '\\Mnm\\VesselIDType',
            'VariantIDType' => '\\Mnm\\VariantIDType',
            'UpperOrangeHazardPlacardIDType' => '\\Mnm\\UpperOrangeHazardPlacardIDType',
            'ValidatorIDType' => '\\Mnm\\ValidatorIDType',
            'WebsiteURIType' => '\\Mnm\\WebsiteURIType',
            'UUIDType' => '\\Mnm\\UUIDType',
            'TenderEnvelopeIDType' => '\\Mnm\\TenderEnvelopeIDType',
            'TraceIDType' => '\\Mnm\\TraceIDType',
            'SupplierAssignedAccountIDType' => '\\Mnm\\SupplierAssignedAccountIDType',
            'SubscriberIDType' => '\\Mnm\\SubscriberIDType',
            'SuccessiveSequenceIDType' => '\\Mnm\\SuccessiveSequenceIDType',
            'TrackingIDType' => '\\Mnm\\TrackingIDType',
            'URIType' => '\\Mnm\\URIType',
            'TransportationServiceDetailsURIType' => '\\Mnm\\TransportationServiceDetailsURIType',
            'TrainIDType' => '\\Mnm\\TrainIDType',
            'TransportExecutionPlanReferenceIDType' => '\\Mnm\\TransportExecutionPlanReferenceIDType',
            'RadioCallSignIDType' => '\\Mnm\\RadioCallSignIDType',
            'ConsumptionReportIDType' => '\\Mnm\\ConsumptionReportIDType',
            'ConsumptionIDType' => '\\Mnm\\ConsumptionIDType',
            'ContractedCarrierAssignedIDType' => '\\Mnm\\ContractedCarrierAssignedIDType',
            'ContractFolderIDType' => '\\Mnm\\ContractFolderIDType',
            'ConsignorAssignedIDType' => '\\Mnm\\ConsignorAssignedIDType',
            'ChipApplicationIDType' => '\\Mnm\\ChipApplicationIDType',
            'CarrierAssignedIDType' => '\\Mnm\\CarrierAssignedIDType',
            'ConsigneeAssignedIDType' => '\\Mnm\\ConsigneeAssignedIDType',
            'CompanyIDType' => '\\Mnm\\CompanyIDType',
            'ExtendedIDType' => '\\Mnm\\ExtendedIDType',
            'ExchangeMarketIDType' => '\\Mnm\\ExchangeMarketIDType',
            'HazardClassIDType' => '\\Mnm\\HazardClassIDType',
            'FreightForwarderAssignedIDType' => '\\Mnm\\FreightForwarderAssignedIDType',
            'EndpointIDType' => '\\Mnm\\EndpointIDType',
            'CustomizationIDType' => '\\Mnm\\CustomizationIDType',
            'CustomerAssignedAccountIDType' => '\\Mnm\\CustomerAssignedAccountIDType',
            'EconomicOperatorRegistryURIType' => '\\Mnm\\EconomicOperatorRegistryURIType',
            'DocumentIDType' => '\\Mnm\\DocumentIDType',
            'CV2IDType' => '\\Mnm\\CV2IDType',
            'AdditionalAccountIDType' => '\\Mnm\\AdditionalAccountIDType',
            'AccountIDType' => '\\Mnm\\AccountIDType',
            'AircraftIDType' => '\\Mnm\\AircraftIDType',
            'AgencyIDType' => '\\Mnm\\AgencyIDType',
            'BusinessIdentityEvidenceIDType' => '\\Mnm\\BusinessIdentityEvidenceIDType',
            'BusinessClassificationEvidenceIDType' => '\\Mnm\\BusinessClassificationEvidenceIDType',
            'BuyerProfileURIType' => '\\Mnm\\BuyerProfileURIType',
            'BuyerEventIDType' => '\\Mnm\\BuyerEventIDType',
            'BrokerAssignedIDType' => '\\Mnm\\BrokerAssignedIDType',
            'AuctionURIType' => '\\Mnm\\AuctionURIType',
            'AttributeIDType' => '\\Mnm\\AttributeIDType',
            'BarcodeSymbologyIDType' => '\\Mnm\\BarcodeSymbologyIDType',
            'AwardingCriterionIDType' => '\\Mnm\\AwardingCriterionIDType',
            'IDType' => '\\Mnm\\IDType',
            'ProfileExecutionIDType' => '\\Mnm\\ProfileExecutionIDType',
            'ParentDocumentIDType' => '\\Mnm\\ParentDocumentIDType',
            'PrimaryAccountNumberIDType' => '\\Mnm\\PrimaryAccountNumberIDType',
            'ProductTraceIDType' => '\\Mnm\\ProductTraceIDType',
            'OriginalJobIDType' => '\\Mnm\\OriginalJobIDType',
            'OntologyURIType' => '\\Mnm\\OntologyURIType',
            'NetworkIDType' => '\\Mnm\\NetworkIDType',
            'OriginalContractingSystemIDType' => '\\Mnm\\OriginalContractingSystemIDType',
            'OpenTenderIDType' => '\\Mnm\\OpenTenderIDType',
            'ParentDocumentVersionIDType' => '\\Mnm\\ParentDocumentVersionIDType',
            'ParentDocumentLineReferenceIDType' => '\\Mnm\\ParentDocumentLineReferenceIDType',
            'PaymentMeansIDType' => '\\Mnm\\PaymentMeansIDType',
            'PaymentIDType' => '\\Mnm\\PaymentIDType',
            'PaymentTermsDetailsURIType' => '\\Mnm\\PaymentTermsDetailsURIType',
            'PreviousJobIDType' => '\\Mnm\\PreviousJobIDType',
            'PreviousVersionIDType' => '\\Mnm\\PreviousVersionIDType',
            'PerformingCarrierAssignedIDType' => '\\Mnm\\PerformingCarrierAssignedIDType',
            'PrepaidPaymentReferenceIDType' => '\\Mnm\\PrepaidPaymentReferenceIDType',
            'NationalityIDType' => '\\Mnm\\NationalityIDType',
            'JourneyIDType' => '\\Mnm\\JourneyIDType',
            'IssuerIDType' => '\\Mnm\\IssuerIDType',
            'LicensePlateIDType' => '\\Mnm\\LicensePlateIDType',
            'LanguageIDType' => '\\Mnm\\LanguageIDType',
            'IssueNumberIDType' => '\\Mnm\\IssueNumberIDType',
            'ImmobilizationCertificateIDType' => '\\Mnm\\ImmobilizationCertificateIDType',
            'IdentificationIDType' => '\\Mnm\\IdentificationIDType',
            'InstructionIDType' => '\\Mnm\\InstructionIDType',
            'InformationURIType' => '\\Mnm\\InformationURIType',
            'LowerOrangeHazardPlacardIDType' => '\\Mnm\\LowerOrangeHazardPlacardIDType',
            'LotNumberIDType' => '\\Mnm\\LotNumberIDType',
            'MarkingIDType' => '\\Mnm\\MarkingIDType',
            'ProfileIDType' => '\\Mnm\\ProfileIDType',
            'LocationIDType' => '\\Mnm\\LocationIDType',
            'LoadingSequenceIDType' => '\\Mnm\\LoadingSequenceIDType',
            'LineIDType' => '\\Mnm\\LineIDType',
            'LogoReferenceIDType' => '\\Mnm\\LogoReferenceIDType',
            'CopyIndicatorType' => '\\Mnm\\CopyIndicatorType',
            'FullyPaidSharesIndicatorType' => '\\Mnm\\FullyPaidSharesIndicatorType',
            'FrozenDocumentIndicatorType' => '\\Mnm\\FrozenDocumentIndicatorType',
            'GovernmentAgreementConstraintIndicatorType' => '\\Mnm\\GovernmentAgreementConstraintIndicatorType',
            'GeneralCargoIndicatorType' => '\\Mnm\\GeneralCargoIndicatorType',
            'FreeOfChargeIndicatorType' => '\\Mnm\\FreeOfChargeIndicatorType',
            'CustomsImportClassifiedIndicatorType' => '\\Mnm\\CustomsImportClassifiedIndicatorType',
            'FollowupContractIndicatorType' => '\\Mnm\\FollowupContractIndicatorType',
            'DangerousGoodsApprovedIndicatorType' => '\\Mnm\\DangerousGoodsApprovedIndicatorType',
            'HazardousRiskIndicatorType' => '\\Mnm\\HazardousRiskIndicatorType',
            'MarkCareIndicatorType' => '\\Mnm\\MarkCareIndicatorType',
            'MarkAttentionIndicatorType' => '\\Mnm\\MarkAttentionIndicatorType',
            'OptionalLineItemIndicatorType' => '\\Mnm\\OptionalLineItemIndicatorType',
            'OnCarriageIndicatorType' => '\\Mnm\\OnCarriageIndicatorType',
            'LivestockIndicatorType' => '\\Mnm\\LivestockIndicatorType',
            'HumanFoodIndicatorType' => '\\Mnm\\HumanFoodIndicatorType',
            'HumanFoodApprovedIndicatorType' => '\\Mnm\\HumanFoodApprovedIndicatorType',
            'LegalStatusIndicatorType' => '\\Mnm\\LegalStatusIndicatorType',
            'IndicationIndicatorType' => '\\Mnm\\IndicationIndicatorType',
            'ContainerizedIndicatorType' => '\\Mnm\\ContainerizedIndicatorType',
            'AnimalFoodApprovedIndicatorType' => '\\Mnm\\AnimalFoodApprovedIndicatorType',
            'AdValoremIndicatorType' => '\\Mnm\\AdValoremIndicatorType',
            'AuctionConstraintIndicatorType' => '\\Mnm\\AuctionConstraintIndicatorType',
            'AnimalFoodIndicatorType' => '\\Mnm\\AnimalFoodIndicatorType',
            'AcceptedIndicatorType' => '\\Mnm\\AcceptedIndicatorType',
            'BackOrderAllowedIndicatorType' => '\\Mnm\\BackOrderAllowedIndicatorType',
            'ChargeIndicatorType' => '\\Mnm\\ChargeIndicatorType',
            'CatalogueIndicatorType' => '\\Mnm\\CatalogueIndicatorType',
            'ConsolidatableIndicatorType' => '\\Mnm\\ConsolidatableIndicatorType',
            'CompletionIndicatorType' => '\\Mnm\\CompletionIndicatorType',
            'CandidateReductionConstraintIndicatorType' => '\\Mnm\\CandidateReductionConstraintIndicatorType',
            'BasedOnConsensusIndicatorType' => '\\Mnm\\BasedOnConsensusIndicatorType',
            'BalanceBroughtForwardIndicatorType' => '\\Mnm\\BalanceBroughtForwardIndicatorType',
            'BulkCargoIndicatorType' => '\\Mnm\\BulkCargoIndicatorType',
            'BindingOnBuyerIndicatorType' => '\\Mnm\\BindingOnBuyerIndicatorType',
            'OrderableIndicatorType' => '\\Mnm\\OrderableIndicatorType',
            'ReturnableMaterialIndicatorType' => '\\Mnm\\ReturnableMaterialIndicatorType',
            'SoleProprietorshipIndicatorType' => '\\Mnm\\SoleProprietorshipIndicatorType',
            'SpecialSecurityIndicatorType' => '\\Mnm\\SpecialSecurityIndicatorType',
            'ReturnabilityIndicatorType' => '\\Mnm\\ReturnabilityIndicatorType',
            'RefrigeratedIndicatorType' => '\\Mnm\\RefrigeratedIndicatorType',
            'RefrigerationOnIndicatorType' => '\\Mnm\\RefrigerationOnIndicatorType',
            'RequiredCurriculaIndicatorType' => '\\Mnm\\RequiredCurriculaIndicatorType',
            'SplitConsignmentIndicatorType' => '\\Mnm\\SplitConsignmentIndicatorType',
            'ToOrderIndicatorType' => '\\Mnm\\ToOrderIndicatorType',
            'UnknownPriceIndicatorType' => '\\Mnm\\UnknownPriceIndicatorType',
            'VariantConstraintIndicatorType' => '\\Mnm\\VariantConstraintIndicatorType',
            'ThirdPartyPayerIndicatorType' => '\\Mnm\\ThirdPartyPayerIndicatorType',
            'StatusAvailableIndicatorType' => '\\Mnm\\StatusAvailableIndicatorType',
            'TaxEvidenceIndicatorType' => '\\Mnm\\TaxEvidenceIndicatorType',
            'TaxIncludedIndicatorType' => '\\Mnm\\TaxIncludedIndicatorType',
            'PublishAwardIndicatorType' => '\\Mnm\\PublishAwardIndicatorType',
            'PowerIndicatorType' => '\\Mnm\\PowerIndicatorType',
            'PreCarriageIndicatorType' => '\\Mnm\\PreCarriageIndicatorType',
            'ItemUpdateRequestIndicatorType' => '\\Mnm\\ItemUpdateRequestIndicatorType',
            'PartialDeliveryIndicatorType' => '\\Mnm\\PartialDeliveryIndicatorType',
            'PricingUpdateRequestIndicatorType' => '\\Mnm\\PricingUpdateRequestIndicatorType',
            'PrizeIndicatorType' => '\\Mnm\\PrizeIndicatorType',
            'PrepaidIndicatorType' => '\\Mnm\\PrepaidIndicatorType',
            'OtherConditionsIndicatorType' => '\\Mnm\\OtherConditionsIndicatorType',
            'IssueDateType' => '\\Mnm\\IssueDateType',
            'LastRevisionDateType' => '\\Mnm\\LastRevisionDateType',
            'LatestDeliveryDateType' => '\\Mnm\\LatestDeliveryDateType',
            'GuaranteedDespatchDateType' => '\\Mnm\\GuaranteedDespatchDateType',
            'InstallmentDueDateType' => '\\Mnm\\InstallmentDueDateType',
            'LatestProposalAcceptanceDateType' => '\\Mnm\\LatestProposalAcceptanceDateType',
            'LatestSecurityClearanceDateType' => '\\Mnm\\LatestSecurityClearanceDateType',
            'LatestPickupDateType' => '\\Mnm\\LatestPickupDateType',
            'LatestMeterReadingDateType' => '\\Mnm\\LatestMeterReadingDateType',
            'EarliestPickupDateType' => '\\Mnm\\EarliestPickupDateType',
            'EffectiveDateType' => '\\Mnm\\EffectiveDateType',
            'DueDateType' => '\\Mnm\\DueDateType',
            'ComparisonForecastIssueDateType' => '\\Mnm\\ComparisonForecastIssueDateType',
            'ExpiryDateType' => '\\Mnm\\ExpiryDateType',
            'FirstShipmentAvailibilityDateType' => '\\Mnm\\FirstShipmentAvailibilityDateType',
            'EstimatedDespatchDateType' => '\\Mnm\\EstimatedDespatchDateType',
            'EndDateType' => '\\Mnm\\EndDateType',
            'EstimatedDeliveryDateType' => '\\Mnm\\EstimatedDeliveryDateType',
            'ManufactureDateType' => '\\Mnm\\ManufactureDateType',
            'RegistrationExpirationDateType' => '\\Mnm\\RegistrationExpirationDateType',
            'RequestedDeliveryDateType' => '\\Mnm\\RequestedDeliveryDateType',
            'RegistrationDateType' => '\\Mnm\\RegistrationDateType',
            'RegisteredDateType' => '\\Mnm\\RegisteredDateType',
            'ResolutionDateType' => '\\Mnm\\ResolutionDateType',
            'ResponseDateType' => '\\Mnm\\ResponseDateType',
            'RequiredDeliveryDateType' => '\\Mnm\\RequiredDeliveryDateType',
            'RequestedDespatchDateType' => '\\Mnm\\RequestedDespatchDateType',
            'RequestedPublicationDateType' => '\\Mnm\\RequestedPublicationDateType',
            'PaymentDueDateType' => '\\Mnm\\PaymentDueDateType',
            'PlannedDateType' => '\\Mnm\\PlannedDateType',
            'PaidDateType' => '\\Mnm\\PaidDateType',
            'NominationDateType' => '\\Mnm\\NominationDateType',
            'OccurrenceDateType' => '\\Mnm\\OccurrenceDateType',
            'ReferenceDateType' => '\\Mnm\\ReferenceDateType',
            'PreviousMeterReadingDateType' => '\\Mnm\\PreviousMeterReadingDateType',
            'ReceivedDateType' => '\\Mnm\\ReceivedDateType',
            'CallDateType' => '\\Mnm\\CallDateType',
            'AvailabilityDateType' => '\\Mnm\\AvailabilityDateType',
            'ApprovalDateType' => '\\Mnm\\ApprovalDateType',
            'ValidityStartDateType' => '\\Mnm\\ValidityStartDateType',
            'AwardDateType' => '\\Mnm\\AwardDateType',
            'BestBeforeDateType' => '\\Mnm\\BestBeforeDateType',
            'ActualDeliveryDateType' => '\\Mnm\\ActualDeliveryDateType',
            'ActualPickupDateType' => '\\Mnm\\ActualPickupDateType',
            'ActualDespatchDateType' => '\\Mnm\\ActualDespatchDateType',
            'StartDateType' => '\\Mnm\\StartDateType',
            'SubmissionDateType' => '\\Mnm\\SubmissionDateType',
            'SubmissionDueDateType' => '\\Mnm\\SubmissionDueDateType',
            'BirthDateType' => '\\Mnm\\BirthDateType',
            'RevisionDateType' => '\\Mnm\\RevisionDateType',
            'SourceForecastIssueDateType' => '\\Mnm\\SourceForecastIssueDateType',
            'TaxPointDateType' => '\\Mnm\\TaxPointDateType',
            'ValidationDateType' => '\\Mnm\\ValidationDateType',
            'IssueTimeType' => '\\Mnm\\IssueTimeType',
            'PaidTimeType' => '\\Mnm\\PaidTimeType',
            'OccurrenceTimeType' => '\\Mnm\\OccurrenceTimeType',
            'RegisteredTimeType' => '\\Mnm\\RegisteredTimeType',
            'ReferenceTimeType' => '\\Mnm\\ReferenceTimeType',
            'LatestPickupTimeType' => '\\Mnm\\LatestPickupTimeType',
            'LatestDeliveryTimeType' => '\\Mnm\\LatestDeliveryTimeType',
            'NominationTimeType' => '\\Mnm\\NominationTimeType',
            'ManufactureTimeType' => '\\Mnm\\ManufactureTimeType',
            'RequestedDespatchTimeType' => '\\Mnm\\RequestedDespatchTimeType',
            'StartTimeType' => '\\Mnm\\StartTimeType',
            'SourceForecastIssueTimeType' => '\\Mnm\\SourceForecastIssueTimeType',
            'ActualDeliveryTimeType' => '\\Mnm\\ActualDeliveryTimeType',
            'ValidationTimeType' => '\\Mnm\\ValidationTimeType',
            'ResolutionTimeType' => '\\Mnm\\ResolutionTimeType',
            'RequiredDeliveryTimeType' => '\\Mnm\\RequiredDeliveryTimeType',
            'RevisionTimeType' => '\\Mnm\\RevisionTimeType',
            'ResponseTimeType' => '\\Mnm\\ResponseTimeType',
            'LastRevisionTimeType' => '\\Mnm\\LastRevisionTimeType',
            'ActualDespatchTimeType' => '\\Mnm\\ActualDespatchTimeType',
            'CallTimeType' => '\\Mnm\\CallTimeType',
            'AwardTimeType' => '\\Mnm\\AwardTimeType',
            'ActualPickupTimeType' => '\\Mnm\\ActualPickupTimeType',
            'ComparisonForecastIssueTimeType' => '\\Mnm\\ComparisonForecastIssueTimeType',
            'ExpiryTimeType' => '\\Mnm\\ExpiryTimeType',
            'EstimatedDespatchTimeType' => '\\Mnm\\EstimatedDespatchTimeType',
            'GuaranteedDespatchTimeType' => '\\Mnm\\GuaranteedDespatchTimeType',
            'EffectiveTimeType' => '\\Mnm\\EffectiveTimeType',
            'EarliestPickupTimeType' => '\\Mnm\\EarliestPickupTimeType',
            'EstimatedDeliveryTimeType' => '\\Mnm\\EstimatedDeliveryTimeType',
            'EndTimeType' => '\\Mnm\\EndTimeType',
            'InvoiceTypeCodeType' => '\\Mnm\\InvoiceTypeCodeType',
            'PositionCodeType' => '\\Mnm\\PositionCodeType',
            'PerformanceMetricTypeCodeType' => '\\Mnm\\PerformanceMetricTypeCodeType',
            'PaymentAlternativeCurrencyCodeType' => '\\Mnm\\PaymentAlternativeCurrencyCodeType',
            'PaymentChannelCodeType' => '\\Mnm\\PaymentChannelCodeType',
            'PartPresentationCodeType' => '\\Mnm\\PartPresentationCodeType',
            'PartyTypeCodeType' => '\\Mnm\\PartyTypeCodeType',
            'PaymentMeansCodeType' => '\\Mnm\\PaymentMeansCodeType',
            'PaymentPurposeCodeType' => '\\Mnm\\PaymentPurposeCodeType',
            'PaymentCurrencyCodeType' => '\\Mnm\\PaymentCurrencyCodeType',
            'PaymentFrequencyCodeType' => '\\Mnm\\PaymentFrequencyCodeType',
            'ContractingSystemCodeType' => '\\Mnm\\ContractingSystemCodeType',
            'ContractTypeCodeType' => '\\Mnm\\ContractTypeCodeType',
            'ConsumptionTypeCodeType' => '\\Mnm\\ConsumptionTypeCodeType',
            'CoordinateSystemCodeType' => '\\Mnm\\CoordinateSystemCodeType',
            'CountrySubentityCodeType' => '\\Mnm\\CountrySubentityCodeType',
            'CorrectionTypeCodeType' => '\\Mnm\\CorrectionTypeCodeType',
            'CorporateRegistrationTypeCodeType' => '\\Mnm\\CorporateRegistrationTypeCodeType',
            'ConsumptionLevelCodeType' => '\\Mnm\\ConsumptionLevelCodeType',
            'ComparisonDataSourceCodeType' => '\\Mnm\\ComparisonDataSourceCodeType',
            'ComparisonDataCodeType' => '\\Mnm\\ComparisonDataCodeType',
            'CompanyLiquidationStatusCodeType' => '\\Mnm\\CompanyLiquidationStatusCodeType',
            'ConditionCodeType' => '\\Mnm\\ConditionCodeType',
            'ConsumersEnergyLevelCodeType' => '\\Mnm\\ConsumersEnergyLevelCodeType',
            'ConsumerIncentiveTacticTypeCodeType' => '\\Mnm\\ConsumerIncentiveTacticTypeCodeType',
            'ConstitutionCodeType' => '\\Mnm\\ConstitutionCodeType',
            'DispositionCodeType' => '\\Mnm\\DispositionCodeType',
            'DisplayTacticTypeCodeType' => '\\Mnm\\DisplayTacticTypeCodeType',
            'DirectionCodeType' => '\\Mnm\\DirectionCodeType',
            'DocumentCurrencyCodeType' => '\\Mnm\\DocumentCurrencyCodeType',
            'DocumentTypeCodeType' => '\\Mnm\\DocumentTypeCodeType',
            'DocumentStatusReasonCodeType' => '\\Mnm\\DocumentStatusReasonCodeType',
            'DocumentStatusCodeType' => '\\Mnm\\DocumentStatusCodeType',
            'DespatchAdviceTypeCodeType' => '\\Mnm\\DespatchAdviceTypeCodeType',
            'CurrentChargeTypeCodeType' => '\\Mnm\\CurrentChargeTypeCodeType',
            'CurrencyCodeType' => '\\Mnm\\CurrencyCodeType',
            'CreditNoteTypeCodeType' => '\\Mnm\\CreditNoteTypeCodeType',
            'CustomsStatusCodeType' => '\\Mnm\\CustomsStatusCodeType',
            'DescriptionCodeType' => '\\Mnm\\DescriptionCodeType',
            'DeclarationTypeCodeType' => '\\Mnm\\DeclarationTypeCodeType',
            'DataSourceCodeType' => '\\Mnm\\DataSourceCodeType',
            'AddressTypeCodeType' => '\\Mnm\\AddressTypeCodeType',
            'AddressFormatCodeType' => '\\Mnm\\AddressFormatCodeType',
            'ActivityTypeCodeType' => '\\Mnm\\ActivityTypeCodeType',
            'AdjustmentReasonCodeType' => '\\Mnm\\AdjustmentReasonCodeType',
            'ApplicationStatusCodeType' => '\\Mnm\\ApplicationStatusCodeType',
            'AllowanceChargeReasonCodeType' => '\\Mnm\\AllowanceChargeReasonCodeType',
            'AdmissionCodeType' => '\\Mnm\\AdmissionCodeType',
            'ActionCodeType' => '\\Mnm\\ActionCodeType',
            'AccountingCostCodeType' => '\\Mnm\\AccountingCostCodeType',
            'AccountTypeCodeType' => '\\Mnm\\AccountTypeCodeType',
            'AccountFormatCodeType' => '\\Mnm\\AccountFormatCodeType',
            'ChannelCodeType' => '\\Mnm\\ChannelCodeType',
            'CertificateTypeCodeType' => '\\Mnm\\CertificateTypeCodeType',
            'CargoTypeCodeType' => '\\Mnm\\CargoTypeCodeType',
            'CharacterSetCodeType' => '\\Mnm\\CharacterSetCodeType',
            'CompanyLegalFormCodeType' => '\\Mnm\\CompanyLegalFormCodeType',
            'CommodityCodeType' => '\\Mnm\\CommodityCodeType',
            'CollaborationPriorityCodeType' => '\\Mnm\\CollaborationPriorityCodeType',
            'CardTypeCodeType' => '\\Mnm\\CardTypeCodeType',
            'AwardingMethodTypeCodeType' => '\\Mnm\\AwardingMethodTypeCodeType',
            'AwardingCriterionTypeCodeType' => '\\Mnm\\AwardingCriterionTypeCodeType',
            'AvailabilityStatusCodeType' => '\\Mnm\\AvailabilityStatusCodeType',
            'CalculationExpressionCodeType' => '\\Mnm\\CalculationExpressionCodeType',
            'CardChipCodeType' => '\\Mnm\\CardChipCodeType',
            'CapabilityTypeCodeType' => '\\Mnm\\CapabilityTypeCodeType',
            'CalculationMethodCodeType' => '\\Mnm\\CalculationMethodCodeType',
            'LossRiskResponsibilityCodeType' => '\\Mnm\\LossRiskResponsibilityCodeType',
            'LongitudeDirectionCodeType' => '\\Mnm\\LongitudeDirectionCodeType',
            'LocationTypeCodeType' => '\\Mnm\\LocationTypeCodeType',
            'MandateTypeCodeType' => '\\Mnm\\MandateTypeCodeType',
            'MeterConstantCodeType' => '\\Mnm\\MeterConstantCodeType',
            'MedicalFirstAidGuideCodeType' => '\\Mnm\\MedicalFirstAidGuideCodeType',
            'MathematicOperatorCodeType' => '\\Mnm\\MathematicOperatorCodeType',
            'LocaleCodeType' => '\\Mnm\\LocaleCodeType',
            'ItemClassificationCodeType' => '\\Mnm\\ItemClassificationCodeType',
            'InspectionMethodCodeType' => '\\Mnm\\InspectionMethodCodeType',
            'LatestMeterReadingMethodCodeType' => '\\Mnm\\LatestMeterReadingMethodCodeType',
            'LineStatusCodeType' => '\\Mnm\\LineStatusCodeType',
            'LifeCycleStatusCodeType' => '\\Mnm\\LifeCycleStatusCodeType',
            'LatitudeDirectionCodeType' => '\\Mnm\\LatitudeDirectionCodeType',
            'PackLevelCodeType' => '\\Mnm\\PackLevelCodeType',
            'OwnerTypeCodeType' => '\\Mnm\\OwnerTypeCodeType',
            'OrderTypeCodeType' => '\\Mnm\\OrderTypeCodeType',
            'PackageLevelCodeType' => '\\Mnm\\PackageLevelCodeType',
            'ParentDocumentTypeCodeType' => '\\Mnm\\ParentDocumentTypeCodeType',
            'PackingCriteriaCodeType' => '\\Mnm\\PackingCriteriaCodeType',
            'PackagingTypeCodeType' => '\\Mnm\\PackagingTypeCodeType',
            'OrderResponseCodeType' => '\\Mnm\\OrderResponseCodeType',
            'MiscellaneousEventTypeCodeType' => '\\Mnm\\MiscellaneousEventTypeCodeType',
            'MimeCodeType' => '\\Mnm\\MimeCodeType',
            'MeterReadingTypeCodeType' => '\\Mnm\\MeterReadingTypeCodeType',
            'NameCodeType' => '\\Mnm\\NameCodeType',
            'OneTimeChargeTypeCodeType' => '\\Mnm\\OneTimeChargeTypeCodeType',
            'NotificationTypeCodeType' => '\\Mnm\\NotificationTypeCodeType',
            'NatureCodeType' => '\\Mnm\\NatureCodeType',
            'ExpenseCodeType' => '\\Mnm\\ExpenseCodeType',
            'ExemptionReasonCodeType' => '\\Mnm\\ExemptionReasonCodeType',
            'ExecutionRequirementCodeType' => '\\Mnm\\ExecutionRequirementCodeType',
            'ExpressionCodeType' => '\\Mnm\\ExpressionCodeType',
            'ForecastPurposeCodeType' => '\\Mnm\\ForecastPurposeCodeType',
            'FinancingInstrumentCodeType' => '\\Mnm\\FinancingInstrumentCodeType',
            'FeatureTacticTypeCodeType' => '\\Mnm\\FeatureTacticTypeCodeType',
            'ExceptionStatusCodeType' => '\\Mnm\\ExceptionStatusCodeType',
            'EncodingCodeType' => '\\Mnm\\EncodingCodeType',
            'EmergencyProceduresCodeType' => '\\Mnm\\EmergencyProceduresCodeType',
            'DutyCodeType' => '\\Mnm\\DutyCodeType',
            'EnvironmentalEmissionTypeCodeType' => '\\Mnm\\EnvironmentalEmissionTypeCodeType',
            'ExceptionResolutionCodeType' => '\\Mnm\\ExceptionResolutionCodeType',
            'EvidenceTypeCodeType' => '\\Mnm\\EvidenceTypeCodeType',
            'EvaluationCriterionTypeCodeType' => '\\Mnm\\EvaluationCriterionTypeCodeType',
            'HeatingTypeCodeType' => '\\Mnm\\HeatingTypeCodeType',
            'HazardousRegulationCodeType' => '\\Mnm\\HazardousRegulationCodeType',
            'HazardousCategoryCodeType' => '\\Mnm\\HazardousCategoryCodeType',
            'IdentificationCodeType' => '\\Mnm\\IdentificationCodeType',
            'InhalationToxicityZoneCodeType' => '\\Mnm\\InhalationToxicityZoneCodeType',
            'IndustryClassificationCodeType' => '\\Mnm\\IndustryClassificationCodeType',
            'ImportanceCodeType' => '\\Mnm\\ImportanceCodeType',
            'HandlingCodeType' => '\\Mnm\\HandlingCodeType',
            'FreightRateClassCodeType' => '\\Mnm\\FreightRateClassCodeType',
            'FormatCodeType' => '\\Mnm\\FormatCodeType',
            'ForecastTypeCodeType' => '\\Mnm\\ForecastTypeCodeType',
            'FullnessIndicationCodeType' => '\\Mnm\\FullnessIndicationCodeType',
            'GuaranteeTypeCodeType' => '\\Mnm\\GuaranteeTypeCodeType',
            'GenderCodeType' => '\\Mnm\\GenderCodeType',
            'FundingProgramCodeType' => '\\Mnm\\FundingProgramCodeType',
            'ValidationResultCodeType' => '\\Mnm\\ValidationResultCodeType',
            'TaxTypeCodeType' => '\\Mnm\\TaxTypeCodeType',
            'WeekDayCodeType' => '\\Mnm\\WeekDayCodeType',
            'WorkPhaseCodeType' => '\\Mnm\\WorkPhaseCodeType',
            'WeightingAlgorithmCodeType' => '\\Mnm\\WeightingAlgorithmCodeType',
            'TelecommunicationsServiceCallCodeType' => '\\Mnm\\TelecommunicationsServiceCallCodeType',
            'TenderEnvelopeTypeCodeType' => '\\Mnm\\TenderEnvelopeTypeCodeType',
            'TenderResultCodeType' => '\\Mnm\\TenderResultCodeType',
            'TelecommunicationsSupplyTypeCodeType' => '\\Mnm\\TelecommunicationsSupplyTypeCodeType',
            'UtilityStatementTypeCodeType' => '\\Mnm\\UtilityStatementTypeCodeType',
            'TelecommunicationsServiceCategoryCodeType' => '\\Mnm\\TelecommunicationsServiceCategoryCodeType',
            'TargetCurrencyCodeType' => '\\Mnm\\TargetCurrencyCodeType',
            'TariffClassCodeType' => '\\Mnm\\TariffClassCodeType',
            'SupplyChainActivityTypeCodeType' => '\\Mnm\\SupplyChainActivityTypeCodeType',
            'SubscriberTypeCodeType' => '\\Mnm\\SubscriberTypeCodeType',
            'SubstitutionStatusCodeType' => '\\Mnm\\SubstitutionStatusCodeType',
            'TariffCodeType' => '\\Mnm\\TariffCodeType',
            'TaxLevelCodeType' => '\\Mnm\\TaxLevelCodeType',
            'TaxCurrencyCodeType' => '\\Mnm\\TaxCurrencyCodeType',
            'TaxExemptionReasonCodeType' => '\\Mnm\\TaxExemptionReasonCodeType',
            'TransportEventTypeCodeType' => '\\Mnm\\TransportEventTypeCodeType',
            'TransportExecutionStatusCodeType' => '\\Mnm\\TransportExecutionStatusCodeType',
            'TransportEquipmentTypeCodeType' => '\\Mnm\\TransportEquipmentTypeCodeType',
            'TransportAuthorizationCodeType' => '\\Mnm\\TransportAuthorizationCodeType',
            'TransportEmergencyCardCodeType' => '\\Mnm\\TransportEmergencyCardCodeType',
            'TransportHandlingUnitTypeCodeType' => '\\Mnm\\TransportHandlingUnitTypeCodeType',
            'TransportationStatusTypeCodeType' => '\\Mnm\\TransportationStatusTypeCodeType',
            'TypeCodeType' => '\\Mnm\\TypeCodeType',
            'TransportServiceCodeType' => '\\Mnm\\TransportServiceCodeType',
            'TransportMeansTypeCodeType' => '\\Mnm\\TransportMeansTypeCodeType',
            'TransportModeCodeType' => '\\Mnm\\TransportModeCodeType',
            'TendererRoleCodeType' => '\\Mnm\\TendererRoleCodeType',
            'ThresholdValueComparisonCodeType' => '\\Mnm\\ThresholdValueComparisonCodeType',
            'UrgencyCodeType' => '\\Mnm\\UrgencyCodeType',
            'TenderTypeCodeType' => '\\Mnm\\TenderTypeCodeType',
            'TendererRequirementTypeCodeType' => '\\Mnm\\TendererRequirementTypeCodeType',
            'UNDGCodeType' => '\\Mnm\\UNDGCodeType',
            'TradeServiceCodeType' => '\\Mnm\\TradeServiceCodeType',
            'TransitDirectionCodeType' => '\\Mnm\\TransitDirectionCodeType',
            'TradeItemPackingLabelingTypeCodeType' => '\\Mnm\\TradeItemPackingLabelingTypeCodeType',
            'TimingComplaintCodeType' => '\\Mnm\\TimingComplaintCodeType',
            'TrackingDeviceCodeType' => '\\Mnm\\TrackingDeviceCodeType',
            'SubmissionMethodCodeType' => '\\Mnm\\SubmissionMethodCodeType',
            'ProviderTypeCodeType' => '\\Mnm\\ProviderTypeCodeType',
            'PurposeCodeType' => '\\Mnm\\PurposeCodeType',
            'PromotionalEventTypeCodeType' => '\\Mnm\\PromotionalEventTypeCodeType',
            'ProcurementTypeCodeType' => '\\Mnm\\ProcurementTypeCodeType',
            'ProfileStatusCodeType' => '\\Mnm\\ProfileStatusCodeType',
            'QualityControlCodeType' => '\\Mnm\\QualityControlCodeType',
            'RejectActionCodeType' => '\\Mnm\\RejectActionCodeType',
            'RejectReasonCodeType' => '\\Mnm\\RejectReasonCodeType',
            'ReferenceEventCodeType' => '\\Mnm\\ReferenceEventCodeType',
            'QuantityDiscrepancyCodeType' => '\\Mnm\\QuantityDiscrepancyCodeType',
            'ReceiptAdviceTypeCodeType' => '\\Mnm\\ReceiptAdviceTypeCodeType',
            'PreviousMeterReadingMethodCodeType' => '\\Mnm\\PreviousMeterReadingMethodCodeType',
            'PriceEvaluationCodeType' => '\\Mnm\\PriceEvaluationCodeType',
            'PreviousCancellationReasonCodeType' => '\\Mnm\\PreviousCancellationReasonCodeType',
            'TimeFrequencyCodeType' => '\\Mnm\\TimeFrequencyCodeType',
            'PreferenceCriterionCodeType' => '\\Mnm\\PreferenceCriterionCodeType',
            'PriceTypeCodeType' => '\\Mnm\\PriceTypeCodeType',
            'ProcessReasonCodeType' => '\\Mnm\\ProcessReasonCodeType',
            'ProcurementSubTypeCodeType' => '\\Mnm\\ProcurementSubTypeCodeType',
            'ProcedureCodeType' => '\\Mnm\\ProcedureCodeType',
            'PricingCurrencyCodeType' => '\\Mnm\\PricingCurrencyCodeType',
            'PrivacyCodeType' => '\\Mnm\\PrivacyCodeType',
            'ShortageActionCodeType' => '\\Mnm\\ShortageActionCodeType',
            'SizeTypeCodeType' => '\\Mnm\\SizeTypeCodeType',
            'ShippingPriorityLevelCodeType' => '\\Mnm\\ShippingPriorityLevelCodeType',
            'ServiceInformationPreferenceCodeType' => '\\Mnm\\ServiceInformationPreferenceCodeType',
            'ServiceTypeCodeType' => '\\Mnm\\ServiceTypeCodeType',
            'SourceCurrencyCodeType' => '\\Mnm\\SourceCurrencyCodeType',
            'StatusReasonCodeType' => '\\Mnm\\StatusReasonCodeType',
            'SubcontractingConditionsCodeType' => '\\Mnm\\SubcontractingConditionsCodeType',
            'StatusCodeType' => '\\Mnm\\StatusCodeType',
            'SpecificationTypeCodeType' => '\\Mnm\\SpecificationTypeCodeType',
            'StatementTypeCodeType' => '\\Mnm\\StatementTypeCodeType',
            'ResolutionCodeType' => '\\Mnm\\ResolutionCodeType',
            'ResponseCodeType' => '\\Mnm\\ResponseCodeType',
            'ResidenceTypeCodeType' => '\\Mnm\\ResidenceTypeCodeType',
            'ReminderTypeCodeType' => '\\Mnm\\ReminderTypeCodeType',
            'RequestedInvoiceCurrencyCodeType' => '\\Mnm\\RequestedInvoiceCurrencyCodeType',
            'RetailEventStatusCodeType' => '\\Mnm\\RetailEventStatusCodeType',
            'SealStatusCodeType' => '\\Mnm\\SealStatusCodeType',
            'SecurityClassificationCodeType' => '\\Mnm\\SecurityClassificationCodeType',
            'SealIssuerTypeCodeType' => '\\Mnm\\SealIssuerTypeCodeType',
            'RevisionStatusCodeType' => '\\Mnm\\RevisionStatusCodeType',
            'RoleCodeType' => '\\Mnm\\RoleCodeType',
            'NoteType' => '\\Mnm\\NoteType',
            'OtherNameType' => '\\Mnm\\OtherNameType',
            'RegistrationNameType' => '\\Mnm\\RegistrationNameType',
            'HolderNameType' => '\\Mnm\\HolderNameType',
            'MiddleNameType' => '\\Mnm\\MiddleNameType',
            'ModelNameType' => '\\Mnm\\ModelNameType',
            'StreetNameType' => '\\Mnm\\StreetNameType',
            'TechnicalNameType' => '\\Mnm\\TechnicalNameType',
            'VesselNameType' => '\\Mnm\\VesselNameType',
            'RetailEventNameType' => '\\Mnm\\RetailEventNameType',
            'RoamingPartnerNameType' => '\\Mnm\\RoamingPartnerNameType',
            'ServiceNameType' => '\\Mnm\\ServiceNameType',
            'AdditionalStreetNameType' => '\\Mnm\\AdditionalStreetNameType',
            'AliasNameType' => '\\Mnm\\AliasNameType',
            'BlockNameType' => '\\Mnm\\BlockNameType',
            'BrandNameType' => '\\Mnm\\BrandNameType',
            'FamilyNameType' => '\\Mnm\\FamilyNameType',
            'FileNameType' => '\\Mnm\\FileNameType',
            'FirstNameType' => '\\Mnm\\FirstNameType',
            'CitySubdivisionNameType' => '\\Mnm\\CitySubdivisionNameType',
            'CategoryNameType' => '\\Mnm\\CategoryNameType',
            'BuildingNameType' => '\\Mnm\\BuildingNameType',
            'CityNameType' => '\\Mnm\\CityNameType',
            'RoomType' => '\\Mnm\\RoomType',
            'RoleDescriptionType' => '\\Mnm\\RoleDescriptionType',
            'ResolutionType' => '\\Mnm\\ResolutionType',
            'ServiceTypeType' => '\\Mnm\\ServiceTypeType',
            'ServiceNumberCalledType' => '\\Mnm\\ServiceNumberCalledType',
            'SealingPartyTypeType' => '\\Mnm\\SealingPartyTypeType',
            'ResidenceTypeType' => '\\Mnm\\ResidenceTypeType',
            'RejectReasonType' => '\\Mnm\\RejectReasonType',
            'RegulatoryDomainType' => '\\Mnm\\RegulatoryDomainType',
            'RegistrationNationalityType' => '\\Mnm\\RegistrationNationalityType',
            'ReplenishmentOwnerDescriptionType' => '\\Mnm\\ReplenishmentOwnerDescriptionType',
            'RemarksType' => '\\Mnm\\RemarksType',
            'RejectionNoteType' => '\\Mnm\\RejectionNoteType',
            'SummaryDescriptionType' => '\\Mnm\\SummaryDescriptionType',
            'SubscriberTypeType' => '\\Mnm\\SubscriberTypeType',
            'StatusReasonType' => '\\Mnm\\StatusReasonType',
            'TechnicalCommitteeDescriptionType' => '\\Mnm\\TechnicalCommitteeDescriptionType',
            'TaxExemptionReasonType' => '\\Mnm\\TaxExemptionReasonType',
            'TariffDescriptionType' => '\\Mnm\\TariffDescriptionType',
            'SpecialTransportRequirementsType' => '\\Mnm\\SpecialTransportRequirementsType',
            'ShipsRequirementsType' => '\\Mnm\\ShipsRequirementsType',
            'ShippingMarksType' => '\\Mnm\\ShippingMarksType',
            'SpecialTermsType' => '\\Mnm\\SpecialTermsType',
            'SpecialServiceInstructionsType' => '\\Mnm\\SpecialServiceInstructionsType',
            'SpecialInstructionsType' => '\\Mnm\\SpecialInstructionsType',
            'RegionType' => '\\Mnm\\RegionType',
            'PlacardEndorsementType' => '\\Mnm\\PlacardEndorsementType',
            'PhoneNumberType' => '\\Mnm\\PhoneNumberType',
            'PersonalSituationType' => '\\Mnm\\PersonalSituationType',
            'PostalZoneType' => '\\Mnm\\PostalZoneType',
            'PlotIdentificationType' => '\\Mnm\\PlotIdentificationType',
            'PlacardNotationType' => '\\Mnm\\PlacardNotationType',
            'PaymentOrderReferenceType' => '\\Mnm\\PaymentOrderReferenceType',
            'PayPerViewType' => '\\Mnm\\PayPerViewType',
            'PasswordType' => '\\Mnm\\PasswordType',
            'PartyTypeType' => '\\Mnm\\PartyTypeType',
            'PaymentNoteType' => '\\Mnm\\PaymentNoteType',
            'PaymentDescriptionType' => '\\Mnm\\PaymentDescriptionType',
            'PayerReferenceType' => '\\Mnm\\PayerReferenceType',
            'ProcessReasonType' => '\\Mnm\\ProcessReasonType',
            'ProcessDescriptionType' => '\\Mnm\\ProcessDescriptionType',
            'PrizeDescriptionType' => '\\Mnm\\PrizeDescriptionType',
            'RankType' => '\\Mnm\\RankType',
            'PurposeType' => '\\Mnm\\PurposeType',
            'PriorityType' => '\\Mnm\\PriorityType',
            'PriceChangeReasonType' => '\\Mnm\\PriceChangeReasonType',
            'PreviousMeterReadingMethodType' => '\\Mnm\\PreviousMeterReadingMethodType',
            'PostboxType' => '\\Mnm\\PostboxType',
            'PrintQualifierType' => '\\Mnm\\PrintQualifierType',
            'PriceTypeType' => '\\Mnm\\PriceTypeType',
            'PriceRevisionFormulaDescriptionType' => '\\Mnm\\PriceRevisionFormulaDescriptionType',
            'TelecommunicationsServiceCallType' => '\\Mnm\\TelecommunicationsServiceCallType',
            'TimingComplaintType' => '\\Mnm\\TimingComplaintType',
            'TimezoneOffsetType' => '\\Mnm\\TimezoneOffsetType',
            'TimeAmountType' => '\\Mnm\\TimeAmountType',
            'TransportServiceProviderRemarksType' => '\\Mnm\\TransportServiceProviderRemarksType',
            'TradingRestrictionsType' => '\\Mnm\\TradingRestrictionsType',
            'TitleType' => '\\Mnm\\TitleType',
            'TierRangeType' => '\\Mnm\\TierRangeType',
            'TelefaxType' => '\\Mnm\\TelefaxType',
            'TelecommunicationsSupplyTypeType' => '\\Mnm\\TelecommunicationsSupplyTypeType',
            'TelecommunicationsServiceCategoryType' => '\\Mnm\\TelecommunicationsServiceCategoryType',
            'TestMethodType' => '\\Mnm\\TestMethodType',
            'TelephoneType' => '\\Mnm\\TelephoneType',
            'WarrantyInformationType' => '\\Mnm\\WarrantyInformationType',
            'ValueQualifierType' => '\\Mnm\\ValueQualifierType',
            'XPathType' => '\\Mnm\\XPathType',
            'WorkPhaseType' => '\\Mnm\\WorkPhaseType',
            'WeightType' => '\\Mnm\\WeightType',
            'ValidateToolVersionType' => '\\Mnm\\ValidateToolVersionType',
            'TransportUserSpecialTermsType' => '\\Mnm\\TransportUserSpecialTermsType',
            'TransportUserRemarksType' => '\\Mnm\\TransportUserRemarksType',
            'TransportServiceProviderSpecialTermsType' => '\\Mnm\\TransportServiceProviderSpecialTermsType',
            'ValidateToolType' => '\\Mnm\\ValidateToolType',
            'ValidateProcessType' => '\\Mnm\\ValidateProcessType',
            'TransportationServiceDescriptionType' => '\\Mnm\\TransportationServiceDescriptionType',
            'ContractSubdivisionType' => '\\Mnm\\ContractSubdivisionType',
            'ContractNameType' => '\\Mnm\\ContractNameType',
            'ContentType' => '\\Mnm\\ContentType',
            'CountrySubentityType' => '\\Mnm\\CountrySubentityType',
            'CorrectionTypeType' => '\\Mnm\\CorrectionTypeType',
            'ContractTypeType' => '\\Mnm\\ContractTypeType',
            'ConsumptionTypeType' => '\\Mnm\\ConsumptionTypeType',
            'ConditionsDescriptionType' => '\\Mnm\\ConditionsDescriptionType',
            'ConditionType' => '\\Mnm\\ConditionType',
            'CompanyLegalFormType' => '\\Mnm\\CompanyLegalFormType',
            'ConsumptionLevelType' => '\\Mnm\\ConsumptionLevelType',
            'ConsumersEnergyLevelType' => '\\Mnm\\ConsumersEnergyLevelType',
            'ConditionsType' => '\\Mnm\\ConditionsType',
            'CurrentChargeTypeType' => '\\Mnm\\CurrentChargeTypeType',
            'DocumentDescriptionType' => '\\Mnm\\DocumentDescriptionType',
            'DistrictType' => '\\Mnm\\DistrictType',
            'DescriptionType' => '\\Mnm\\DescriptionType',
            'DocumentTypeType' => '\\Mnm\\DocumentTypeType',
            'DocumentStatusReasonDescriptionType' => '\\Mnm\\DocumentStatusReasonDescriptionType',
            'DocumentHashType' => '\\Mnm\\DocumentHashType',
            'DepartmentType' => '\\Mnm\\DepartmentType',
            'DamageRemarksType' => '\\Mnm\\DamageRemarksType',
            'CustomsClearanceServiceInstructionsType' => '\\Mnm\\CustomsClearanceServiceInstructionsType',
            'CustomerReferenceType' => '\\Mnm\\CustomerReferenceType',
            'DemurrageInstructionsType' => '\\Mnm\\DemurrageInstructionsType',
            'DeliveryInstructionsType' => '\\Mnm\\DeliveryInstructionsType',
            'DataSendingCapabilityType' => '\\Mnm\\DataSendingCapabilityType',
            'CommentType' => '\\Mnm\\CommentType',
            'AgencyNameType' => '\\Mnm\\AgencyNameType',
            'AdditionalInformationType' => '\\Mnm\\AdditionalInformationType',
            'AdditionalConditionsType' => '\\Mnm\\AdditionalConditionsType',
            'AwardingCriterionDescriptionType' => '\\Mnm\\AwardingCriterionDescriptionType',
            'ApprovalStatusType' => '\\Mnm\\ApprovalStatusType',
            'AllowanceChargeReasonType' => '\\Mnm\\AllowanceChargeReasonType',
            'ActivityTypeType' => '\\Mnm\\ActivityTypeType',
            'AccountingCostType' => '\\Mnm\\AccountingCostType',
            'AcceptedVariantsDescriptionType' => '\\Mnm\\AcceptedVariantsDescriptionType',
            'BackorderReasonType' => '\\Mnm\\BackorderReasonType',
            'ChangeConditionsType' => '\\Mnm\\ChangeConditionsType',
            'CertificateTypeType' => '\\Mnm\\CertificateTypeType',
            'CarrierServiceInstructionsType' => '\\Mnm\\CarrierServiceInstructionsType',
            'CodeValueType' => '\\Mnm\\CodeValueType',
            'CharacteristicsType' => '\\Mnm\\CharacteristicsType',
            'ChannelType' => '\\Mnm\\ChannelType',
            'BuyerReferenceType' => '\\Mnm\\BuyerReferenceType',
            'BuildingNumberType' => '\\Mnm\\BuildingNumberType',
            'BirthplaceNameType' => '\\Mnm\\BirthplaceNameType',
            'CandidateStatementType' => '\\Mnm\\CandidateStatementType',
            'CancellationNoteType' => '\\Mnm\\CancellationNoteType',
            'CalculationExpressionType' => '\\Mnm\\CalculationExpressionType',
            'DutyType' => '\\Mnm\\DutyType',
            'MeterNameType' => '\\Mnm\\MeterNameType',
            'MeterConstantType' => '\\Mnm\\MeterConstantType',
            'MaximumValueType' => '\\Mnm\\MaximumValueType',
            'MeterReadingTypeType' => '\\Mnm\\MeterReadingTypeType',
            'MeterReadingCommentsType' => '\\Mnm\\MeterReadingCommentsType',
            'MeterNumberType' => '\\Mnm\\MeterNumberType',
            'MarkCareType' => '\\Mnm\\MarkCareType',
            'LoginType' => '\\Mnm\\LoginType',
            'LocationType' => '\\Mnm\\LocationType',
            'ListValueType' => '\\Mnm\\ListValueType',
            'MarkAttentionType' => '\\Mnm\\MarkAttentionType',
            'LowTendersDescriptionType' => '\\Mnm\\LowTendersDescriptionType',
            'LossRiskType' => '\\Mnm\\LossRiskType',
            'MinimumImprovementBidType' => '\\Mnm\\MinimumImprovementBidType',
            'OrganizationDepartmentType' => '\\Mnm\\OrganizationDepartmentType',
            'OrderableUnitType' => '\\Mnm\\OrderableUnitType',
            'OptionsDescriptionType' => '\\Mnm\\OptionsDescriptionType',
            'OtherInstructionType' => '\\Mnm\\OtherInstructionType',
            'OutstandingReasonType' => '\\Mnm\\OutstandingReasonType',
            'PackingMaterialType' => '\\Mnm\\PackingMaterialType',
            'OneTimeChargeTypeType' => '\\Mnm\\OneTimeChargeTypeType',
            'MovieTitleType' => '\\Mnm\\MovieTitleType',
            'MonetaryScopeType' => '\\Mnm\\MonetaryScopeType',
            'MinimumValueType' => '\\Mnm\\MinimumValueType',
            'NegotiationDescriptionType' => '\\Mnm\\NegotiationDescriptionType',
            'NameSuffixType' => '\\Mnm\\NameSuffixType',
            'LineType' => '\\Mnm\\LineType',
            'FrequencyType' => '\\Mnm\\FrequencyType',
            'ForwarderServiceInstructionsType' => '\\Mnm\\ForwarderServiceInstructionsType',
            'FloorType' => '\\Mnm\\FloorType',
            'HashAlgorithmMethodType' => '\\Mnm\\HashAlgorithmMethodType',
            'HandlingInstructionsType' => '\\Mnm\\HandlingInstructionsType',
            'FundingProgramType' => '\\Mnm\\FundingProgramType',
            'FeeDescriptionType' => '\\Mnm\\FeeDescriptionType',
            'ExclusionReasonType' => '\\Mnm\\ExclusionReasonType',
            'ElectronicMailType' => '\\Mnm\\ElectronicMailType',
            'ElectronicDeviceDescriptionType' => '\\Mnm\\ElectronicDeviceDescriptionType',
            'ExtensionType' => '\\Mnm\\ExtensionType',
            'ExpressionType' => '\\Mnm\\ExpressionType',
            'ExemptionReasonType' => '\\Mnm\\ExemptionReasonType',
            'HaulageInstructionsType' => '\\Mnm\\HaulageInstructionsType',
            'LimitationDescriptionType' => '\\Mnm\\LimitationDescriptionType',
            'JustificationType' => '\\Mnm\\JustificationType',
            'JustificationDescriptionType' => '\\Mnm\\JustificationDescriptionType',
            'KeywordType' => '\\Mnm\\KeywordType',
            'LatestMeterReadingMethodType' => '\\Mnm\\LatestMeterReadingMethodType',
            'LegalReferenceType' => '\\Mnm\\LegalReferenceType',
            'JobTitleType' => '\\Mnm\\JobTitleType',
            'InhouseMailType' => '\\Mnm\\InhouseMailType',
            'InformationType' => '\\Mnm\\InformationType',
            'HeatingTypeType' => '\\Mnm\\HeatingTypeType',
            'InvoicingPartyReferenceType' => '\\Mnm\\InvoicingPartyReferenceType',
            'InstructionsType' => '\\Mnm\\InstructionsType',
            'InstructionNoteType' => '\\Mnm\\InstructionNoteType',
            'LineCountNumericType' => '\\Mnm\\LineCountNumericType',
            'SourceCurrencyBaseRateType' => '\\Mnm\\SourceCurrencyBaseRateType',
            'CalculationRateType' => '\\Mnm\\CalculationRateType',
            'AmountRateType' => '\\Mnm\\AmountRateType',
            'OrderableUnitFactorRateType' => '\\Mnm\\OrderableUnitFactorRateType',
            'TargetCurrencyBaseRateType' => '\\Mnm\\TargetCurrencyBaseRateType',
            'TargetServicePercentType' => '\\Mnm\\TargetServicePercentType',
            'PaymentPercentType' => '\\Mnm\\PaymentPercentType',
            'TierRatePercentType' => '\\Mnm\\TierRatePercentType',
            'ReliabilityPercentType' => '\\Mnm\\ReliabilityPercentType',
            'SettlementDiscountPercentType' => '\\Mnm\\SettlementDiscountPercentType',
            'ProgressPercentType' => '\\Mnm\\ProgressPercentType',
            'PenaltySurchargePercentType' => '\\Mnm\\PenaltySurchargePercentType',
            'ParticipationPercentType' => '\\Mnm\\ParticipationPercentType',
            'HumidityPercentType' => '\\Mnm\\HumidityPercentType',
            'AirFlowPercentType' => '\\Mnm\\AirFlowPercentType',
            'MaximumPercentType' => '\\Mnm\\MaximumPercentType',
            'PartecipationPercentType' => '\\Mnm\\PartecipationPercentType',
            'MinimumPercentType' => '\\Mnm\\MinimumPercentType',
            'ReminderSequenceNumericType' => '\\Mnm\\ReminderSequenceNumericType',
            'ResidentOccupantsNumericType' => '\\Mnm\\ResidentOccupantsNumericType',
            'SequenceNumericType' => '\\Mnm\\SequenceNumericType',
            'OrderQuantityIncrementNumericType' => '\\Mnm\\OrderQuantityIncrementNumericType',
            'PackSizeNumericType' => '\\Mnm\\PackSizeNumericType',
            'WeightNumericType' => '\\Mnm\\WeightNumericType',
            'BudgetYearNumericType' => '\\Mnm\\BudgetYearNumericType',
            'CalculationSequenceNumericType' => '\\Mnm\\CalculationSequenceNumericType',
            'MinimumNumberNumericType' => '\\Mnm\\MinimumNumberNumericType',
            'FrozenPeriodDaysNumericType' => '\\Mnm\\FrozenPeriodDaysNumericType',
            'MaximumPaymentInstructionsNumericType' => '\\Mnm\\MaximumPaymentInstructionsNumericType',
            'MultiplierFactorNumericType' => '\\Mnm\\MultiplierFactorNumericType',
            'OrderIntervalDaysNumericType' => '\\Mnm\\OrderIntervalDaysNumericType',
            'MaximumNumberNumericType' => '\\Mnm\\MaximumNumberNumericType',
            'LineNumberNumericType' => '\\Mnm\\LineNumberNumericType',
            'MaximumCopiesNumericType' => '\\Mnm\\MaximumCopiesNumericType',
            'DurationMeasureType' => '\\Mnm\\DurationMeasureType',
            'MinimumMeasureType' => '\\Mnm\\MinimumMeasureType',
            'NetNetWeightMeasureType' => '\\Mnm\\NetNetWeightMeasureType',
            'MaximumMeasureType' => '\\Mnm\\MaximumMeasureType',
            'LoadingLengthMeasureType' => '\\Mnm\\LoadingLengthMeasureType',
            'LongitudeDegreesMeasureType' => '\\Mnm\\LongitudeDegreesMeasureType',
            'LongitudeMinutesMeasureType' => '\\Mnm\\LongitudeMinutesMeasureType',
            'NetTonnageMeasureType' => '\\Mnm\\NetTonnageMeasureType',
            'TareWeightMeasureType' => '\\Mnm\\TareWeightMeasureType',
            'ValueMeasureType' => '\\Mnm\\ValueMeasureType',
            'SourceValueMeasureType' => '\\Mnm\\SourceValueMeasureType',
            'NetWeightMeasureType' => '\\Mnm\\NetWeightMeasureType',
            'PostEventNotificationDurationMeasureType' => '\\Mnm\\PostEventNotificationDurationMeasureType',
            'PreEventNotificationDurationMeasureType' => '\\Mnm\\PreEventNotificationDurationMeasureType',
            'AltitudeMeasureType' => '\\Mnm\\AltitudeMeasureType',
            'ChargeableWeightMeasureType' => '\\Mnm\\ChargeableWeightMeasureType',
            'BaseUnitMeasureType' => '\\Mnm\\BaseUnitMeasureType',
            'NetVolumeMeasureType' => '\\Mnm\\NetVolumeMeasureType',
            'GrossWeightMeasureType' => '\\Mnm\\GrossWeightMeasureType',
            'GrossVolumeMeasureType' => '\\Mnm\\GrossVolumeMeasureType',
            'LeadTimeMeasureType' => '\\Mnm\\LeadTimeMeasureType',
            'LatitudeMinutesMeasureType' => '\\Mnm\\LatitudeMinutesMeasureType',
            'ComparedValueMeasureType' => '\\Mnm\\ComparedValueMeasureType',
            'LatitudeDegreesMeasureType' => '\\Mnm\\LatitudeDegreesMeasureType',
            'GrossTonnageMeasureType' => '\\Mnm\\GrossTonnageMeasureType',
            'EmbeddedDocumentBinaryObjectType' => '\\Mnm\\EmbeddedDocumentBinaryObjectType',
            'CorporateStockAmountType' => '\\Mnm\\CorporateStockAmountType',
            'PerUnitAmountType' => '\\Mnm\\PerUnitAmountType',
            'PrepaidAmountType' => '\\Mnm\\PrepaidAmountType',
            'PenaltyAmountType' => '\\Mnm\\PenaltyAmountType',
            'PayableRoundingAmountType' => '\\Mnm\\PayableRoundingAmountType',
            'RoundingAmountType' => '\\Mnm\\RoundingAmountType',
            'SettlementDiscountAmountType' => '\\Mnm\\SettlementDiscountAmountType',
            'PriceAmountType' => '\\Mnm\\PriceAmountType',
            'RequiredFeeAmountType' => '\\Mnm\\RequiredFeeAmountType',
            'PayableAmountType' => '\\Mnm\\PayableAmountType',
            'PartyCapacityAmountType' => '\\Mnm\\PartyCapacityAmountType',
            'PayableAlternativeAmountType' => '\\Mnm\\PayableAlternativeAmountType',
            'MinimumAmountType' => '\\Mnm\\MinimumAmountType',
            'PaidAmountType' => '\\Mnm\\PaidAmountType',
            'DeclaredCarriageValueAmountType' => '\\Mnm\\DeclaredCarriageValueAmountType',
            'DeclaredCustomsValueAmountType' => '\\Mnm\\DeclaredCustomsValueAmountType',
            'CreditLineAmountType' => '\\Mnm\\CreditLineAmountType',
            'DebitLineAmountType' => '\\Mnm\\DebitLineAmountType',
            'TaxAmountType' => '\\Mnm\\TaxAmountType',
            'TotalInvoiceAmountType' => '\\Mnm\\TotalInvoiceAmountType',
            'TotalPaymentAmountType' => '\\Mnm\\TotalPaymentAmountType',
            'TotalCreditAmountType' => '\\Mnm\\TotalCreditAmountType',
            'TotalDebitAmountType' => '\\Mnm\\TotalDebitAmountType',
            'TotalTaskAmountType' => '\\Mnm\\TotalTaskAmountType',
            'ValueAmountType' => '\\Mnm\\ValueAmountType',
            'TotalTaxAmountType' => '\\Mnm\\TotalTaxAmountType',
            'TransactionCurrencyTaxAmountType' => '\\Mnm\\TransactionCurrencyTaxAmountType',
            'TaxEnergyOnAccountAmountType' => '\\Mnm\\TaxEnergyOnAccountAmountType',
            'TaxExclusiveAmountType' => '\\Mnm\\TaxExclusiveAmountType',
            'TaxEnergyAmountType' => '\\Mnm\\TaxEnergyAmountType',
            'TaxEnergyBalanceAmountType' => '\\Mnm\\TaxEnergyBalanceAmountType',
            'TaxInclusiveAmountType' => '\\Mnm\\TaxInclusiveAmountType',
            'TotalAmountType' => '\\Mnm\\TotalAmountType',
            'TotalBalanceAmountType' => '\\Mnm\\TotalBalanceAmountType',
            'TaxableAmountType' => '\\Mnm\\TaxableAmountType',
            'ThresholdAmountType' => '\\Mnm\\ThresholdAmountType',
            'InsurancePremiumAmountType' => '\\Mnm\\InsurancePremiumAmountType',
            'InsuranceValueAmountType' => '\\Mnm\\InsuranceValueAmountType',
            'AnnualAverageAmountType' => '\\Mnm\\AnnualAverageAmountType',
            'AdvertisementAmountType' => '\\Mnm\\AdvertisementAmountType',
            'AllowanceTotalAmountType' => '\\Mnm\\AllowanceTotalAmountType',
            'EstimatedAmountType' => '\\Mnm\\EstimatedAmountType',
            'EstimatedOverallContractAmountType' => '\\Mnm\\EstimatedOverallContractAmountType',
            'DeclaredStatisticsValueAmountType' => '\\Mnm\\DeclaredStatisticsValueAmountType',
            'DocumentationFeeAmountType' => '\\Mnm\\DocumentationFeeAmountType',
            'FaceValueAmountType' => '\\Mnm\\FaceValueAmountType',
            'HigherTenderAmountType' => '\\Mnm\\HigherTenderAmountType',
            'FeeAmountType' => '\\Mnm\\FeeAmountType',
            'FreeOnBoardValueAmountType' => '\\Mnm\\FreeOnBoardValueAmountType',
            'CorrectionAmountType' => '\\Mnm\\CorrectionAmountType',
            'CorrectionUnitAmountType' => '\\Mnm\\CorrectionUnitAmountType',
            'ChargeTotalAmountType' => '\\Mnm\\ChargeTotalAmountType',
            'LowerTenderAmountType' => '\\Mnm\\LowerTenderAmountType',
            'MaximumAmountType' => '\\Mnm\\MaximumAmountType',
            'MaximumPaidAmountType' => '\\Mnm\\MaximumPaidAmountType',
            'MarketValueAmountType' => '\\Mnm\\MarketValueAmountType',
            'MaximumAdvertisementAmountType' => '\\Mnm\\MaximumAdvertisementAmountType',
            'AverageSubsequentContractAmountType' => '\\Mnm\\AverageSubsequentContractAmountType',
            'BalanceAmountType' => '\\Mnm\\BalanceAmountType',
            'InventoryValueAmountType' => '\\Mnm\\InventoryValueAmountType',
            'AverageAmountType' => '\\Mnm\\AverageAmountType',
            'BaseAmountType' => '\\Mnm\\BaseAmountType',
            'LineExtensionAmountType' => '\\Mnm\\LineExtensionAmountType',
            'CallExtensionAmountType' => '\\Mnm\\CallExtensionAmountType',
            'CallBaseAmountType' => '\\Mnm\\CallBaseAmountType',
            'LiabilityAmountType' => '\\Mnm\\LiabilityAmountType',
            'DeclaredForCarriageValueAmountType' => '\\Mnm\\DeclaredForCarriageValueAmountType',
            'TotalConsumedQuantityType' => '\\Mnm\\TotalConsumedQuantityType',
            'TimeDeltaDaysQuantityType' => '\\Mnm\\TimeDeltaDaysQuantityType',
            'TotalGoodsItemQuantityType' => '\\Mnm\\TotalGoodsItemQuantityType',
            'TotalDeliveredQuantityType' => '\\Mnm\\TotalDeliveredQuantityType',
            'ThresholdQuantityType' => '\\Mnm\\ThresholdQuantityType',
            'MinimumOrderQuantityType' => '\\Mnm\\MinimumOrderQuantityType',
            'MinimumQuantityType' => '\\Mnm\\MinimumQuantityType',
            'TargetInventoryQuantityType' => '\\Mnm\\TargetInventoryQuantityType',
            'MinimumInventoryQuantityType' => '\\Mnm\\MinimumInventoryQuantityType',
            'VarianceQuantityType' => '\\Mnm\\VarianceQuantityType',
            'MaximumVariantQuantityType' => '\\Mnm\\MaximumVariantQuantityType',
            'MinimumBackorderQuantityType' => '\\Mnm\\MinimumBackorderQuantityType',
            'ValueQuantityType' => '\\Mnm\\ValueQuantityType',
            'TotalPackageQuantityType' => '\\Mnm\\TotalPackageQuantityType',
            'TotalMeteredQuantityType' => '\\Mnm\\TotalMeteredQuantityType',
            'TotalTransportHandlingUnitQuantityType' => '\\Mnm\\TotalTransportHandlingUnitQuantityType',
            'TotalPackagesQuantityType' => '\\Mnm\\TotalPackagesQuantityType',
            'ReceivedForeignTenderQuantityType' => '\\Mnm\\ReceivedForeignTenderQuantityType',
            'ShortQuantityType' => '\\Mnm\\ShortQuantityType',
            'ReceivedElectronicTenderQuantityType' => '\\Mnm\\ReceivedElectronicTenderQuantityType',
            'SharesNumberQuantityType' => '\\Mnm\\SharesNumberQuantityType',
            'ReceivedTenderQuantityType' => '\\Mnm\\ReceivedTenderQuantityType',
            'ReceivedQuantityType' => '\\Mnm\\ReceivedQuantityType',
            'ReturnableQuantityType' => '\\Mnm\\ReturnableQuantityType',
            'RejectedQuantityType' => '\\Mnm\\RejectedQuantityType',
            'OperatingYearsQuantityType' => '\\Mnm\\OperatingYearsQuantityType',
            'OutstandingQuantityType' => '\\Mnm\\OutstandingQuantityType',
            'MultipleOrderQuantityType' => '\\Mnm\\MultipleOrderQuantityType',
            'NormalTemperatureReductionQuantityType' => '\\Mnm\\NormalTemperatureReductionQuantityType',
            'OversupplyQuantityType' => '\\Mnm\\OversupplyQuantityType',
            'PerformanceValueQuantityType' => '\\Mnm\\PerformanceValueQuantityType',
            'PreviousMeterQuantityType' => '\\Mnm\\PreviousMeterQuantityType',
            'PackQuantityType' => '\\Mnm\\PackQuantityType',
            'PassengerQuantityType' => '\\Mnm\\PassengerQuantityType',
            'ConsignmentQuantityType' => '\\Mnm\\ConsignmentQuantityType',
            'ConsumerUnitQuantityType' => '\\Mnm\\ConsumerUnitQuantityType',
            'ChargeableQuantityType' => '\\Mnm\\ChargeableQuantityType',
            'ChildConsignmentQuantityType' => '\\Mnm\\ChildConsignmentQuantityType',
            'ContentUnitQuantityType' => '\\Mnm\\ContentUnitQuantityType',
            'CreditedQuantityType' => '\\Mnm\\CreditedQuantityType',
            'ConsumptionEnergyQuantityType' => '\\Mnm\\ConsumptionEnergyQuantityType',
            'ConsumptionWaterQuantityType' => '\\Mnm\\ConsumptionWaterQuantityType',
            'BatchQuantityType' => '\\Mnm\\BatchQuantityType',
            'BaseQuantityType' => '\\Mnm\\BaseQuantityType',
            'BasicConsumedQuantityType' => '\\Mnm\\BasicConsumedQuantityType',
            'ActualTemperatureReductionQuantityType' => '\\Mnm\\ActualTemperatureReductionQuantityType',
            'BackorderQuantityType' => '\\Mnm\\BackorderQuantityType',
            'InvoicedQuantityType' => '\\Mnm\\InvoicedQuantityType',
            'LatestMeterQuantityType' => '\\Mnm\\LatestMeterQuantityType',
            'ExpectedQuantityType' => '\\Mnm\\ExpectedQuantityType',
            'GasPressureQuantityType' => '\\Mnm\\GasPressureQuantityType',
            'MaximumOrderQuantityType' => '\\Mnm\\MaximumOrderQuantityType',
            'MaximumQuantityType' => '\\Mnm\\MaximumQuantityType',
            'MaximumBackorderQuantityType' => '\\Mnm\\MaximumBackorderQuantityType',
            'MaximumOperatorQuantityType' => '\\Mnm\\MaximumOperatorQuantityType',
            'ExpectedOperatorQuantityType' => '\\Mnm\\ExpectedOperatorQuantityType',
            'DebitedQuantityType' => '\\Mnm\\DebitedQuantityType',
            'DeliveredQuantityType' => '\\Mnm\\DeliveredQuantityType',
            'CrewQuantityType' => '\\Mnm\\CrewQuantityType',
            'CustomsTariffQuantityType' => '\\Mnm\\CustomsTariffQuantityType',
            'EstimatedConsumedQuantityType' => '\\Mnm\\EstimatedConsumedQuantityType',
            'EstimatedOverallContractQuantityType' => '\\Mnm\\EstimatedOverallContractQuantityType',
            'DifferenceTemperatureReductionQuantityType' => '\\Mnm\\DifferenceTemperatureReductionQuantityType',
            'EmployeeQuantityType' => '\\Mnm\\EmployeeQuantityType',
            'PeriodType' => '\\Mnm\\PeriodType',
            'OrderReferenceType' => '\\Mnm\\OrderReferenceType',
            'DocumentReferenceType' => '\\Mnm\\DocumentReferenceType',
            'AttachmentType' => '\\Mnm\\AttachmentType',
            'ExternalReferenceType' => '\\Mnm\\ExternalReferenceType',
            'PartyType' => '\\Mnm\\PartyType',
            'PartyIdentificationType' => '\\Mnm\\PartyIdentificationType',
            'PartyNameType' => '\\Mnm\\PartyNameType',
            'AddressType' => '\\Mnm\\AddressType',
            'CountryType' => '\\Mnm\\CountryType',
            'PartyTaxSchemeType' => '\\Mnm\\PartyTaxSchemeType',
            'TaxSchemeType' => '\\Mnm\\TaxSchemeType',
            'PartyLegalEntityType' => '\\Mnm\\PartyLegalEntityType',
            'CorporateRegistrationSchemeType' => '\\Mnm\\CorporateRegistrationSchemeType',
            'ContactType' => '\\Mnm\\ContactType',
            'CommunicationType' => '\\Mnm\\CommunicationType',
            'PersonType' => '\\Mnm\\PersonType',
            'FinancialAccountType' => '\\Mnm\\FinancialAccountType',
            'BranchType' => '\\Mnm\\BranchType',
            'FinancialInstitutionType' => '\\Mnm\\FinancialInstitutionType',
            'BillingReferenceType' => '\\Mnm\\BillingReferenceType',
            'BillingReferenceLineType' => '\\Mnm\\BillingReferenceLineType',
            'AllowanceChargeType' => '\\Mnm\\AllowanceChargeType',
            'SupplierPartyType' => '\\Mnm\\SupplierPartyType',
            'CustomerPartyType' => '\\Mnm\\CustomerPartyType',
            'DeliveryType' => '\\Mnm\\DeliveryType',
            'DespatchType' => '\\Mnm\\DespatchType',
            'DeliveryTermsType' => '\\Mnm\\DeliveryTermsType',
            'ShipmentType' => '\\Mnm\\ShipmentType',
            'GoodsItemType' => '\\Mnm\\GoodsItemType',
            'ItemType' => '\\Mnm\\ItemType',
            'ItemIdentificationType' => '\\Mnm\\ItemIdentificationType',
            'CommodityClassificationType' => '\\Mnm\\CommodityClassificationType',
            'ItemInstanceType' => '\\Mnm\\ItemInstanceType',
            'ItemPropertyType' => '\\Mnm\\ItemPropertyType',
            'ItemPropertyGroupType' => '\\Mnm\\ItemPropertyGroupType',
            'DimensionType' => '\\Mnm\\DimensionType',
            'ItemPropertyRangeType' => '\\Mnm\\ItemPropertyRangeType',
            'LotIdentificationType' => '\\Mnm\\LotIdentificationType',
            'InvoiceLineType' => '\\Mnm\\InvoiceLineType',
            'OrderLineReferenceType' => '\\Mnm\\OrderLineReferenceType',
            'LineReferenceType' => '\\Mnm\\LineReferenceType',
            'TaxTotalType' => '\\Mnm\\TaxTotalType',
            'TaxSubtotalType' => '\\Mnm\\TaxSubtotalType',
            'TaxCategoryType' => '\\Mnm\\TaxCategoryType',
            'PriceType' => '\\Mnm\\PriceType',
            'TemperatureType' => '\\Mnm\\TemperatureType',
            'ShipmentStageType' => '\\Mnm\\ShipmentStageType',
            'TransportMeansType' => '\\Mnm\\TransportMeansType',
            'StowageType' => '\\Mnm\\StowageType',
            'AirTransportType' => '\\Mnm\\AirTransportType',
            'RoadTransportType' => '\\Mnm\\RoadTransportType',
            'RailTransportType' => '\\Mnm\\RailTransportType',
            'MaritimeTransportType' => '\\Mnm\\MaritimeTransportType',
            'TransportHandlingUnitType' => '\\Mnm\\TransportHandlingUnitType',
            'PackageType' => '\\Mnm\\PackageType',
            'TransportEquipmentType' => '\\Mnm\\TransportEquipmentType',
            'HazardousGoodsTransitType' => '\\Mnm\\HazardousGoodsTransitType',
            'CustomsDeclarationType' => '\\Mnm\\CustomsDeclarationType',
            'PaymentMeansType' => '\\Mnm\\PaymentMeansType',
            'PaymentTermsType' => '\\Mnm\\PaymentTermsType',
            'ExchangeRateType' => '\\Mnm\\ExchangeRateType',
            'MonetaryTotalType' => '\\Mnm\\MonetaryTotalType',
            'InvoiceType' => '\\Mnm\\InvoiceType',
            'GetSystemDate' => '\\Mnm\\GetSystemDate',
            'UserInformation' => '\\Mnm\\UserInformation',
            'GetSystemDateResponse' => '\\Mnm\\GetSystemDateResponse',
            'DateResponse' => '\\Mnm\\DateResponse',
            'Response' => '\\Mnm\\Response',
            'GetSystemDateWithFormat' => '\\Mnm\\GetSystemDateWithFormat',
            'GetSystemDateWithFormatResponse' => '\\Mnm\\GetSystemDateWithFormatResponse',
            'StringResponse' => '\\Mnm\\StringResponse',
            'IsEInvoiceUser' => '\\Mnm\\IsEInvoiceUser',
            'IsEInvoiceUserResponse' => '\\Mnm\\IsEInvoiceUserResponse',
            'FlagResponse' => '\\Mnm\\FlagResponse',
            'GetEInvoiceUsers' => '\\Mnm\\GetEInvoiceUsers',
            'PagedQueryContext' => '\\Mnm\\PagedQueryContext',
            'GetEInvoiceUsersResponse' => '\\Mnm\\GetEInvoiceUsersResponse',
            'SystemUsersResponse' => '\\Mnm\\SystemUsersResponse',
            'PagedResponseOfSystemUser' => '\\Mnm\\PagedResponseOfSystemUser',
            'SystemUser' => '\\Mnm\\SystemUser',
            'EntityUpdatedHistory' => '\\Mnm\\EntityUpdatedHistory',
            'EntityCreateHistory' => '\\Mnm\\EntityCreateHistory',
            'EntityBaseInt' => '\\Mnm\\EntityBaseInt',
            'EntityBase' => '\\Mnm\\EntityBase',
            'FilterEInvoiceUsers' => '\\Mnm\\FilterEInvoiceUsers',
            'SystemUserFilterContext' => '\\Mnm\\SystemUserFilterContext',
            'FilterablePagedQueryContext' => '\\Mnm\\FilterablePagedQueryContext',
            'FilterEInvoiceUsersResponse' => '\\Mnm\\FilterEInvoiceUsersResponse',
            'GetUserAliasses' => '\\Mnm\\GetUserAliasses',
            'GetUserAliassesResponse' => '\\Mnm\\GetUserAliassesResponse',
            'UserAliassesResponse' => '\\Mnm\\UserAliassesResponse',
            'SystemUserWithAlias' => '\\Mnm\\SystemUserWithAlias',
            'SystemUserDefinition' => '\\Mnm\\SystemUserDefinition',
            'SystemUserAlias' => '\\Mnm\\SystemUserAlias',
            'SetXsltView' => '\\Mnm\\SetXsltView',
            'SetXsltViewResponse' => '\\Mnm\\SetXsltViewResponse',
            'GetXsltView' => '\\Mnm\\GetXsltView',
            'GetXsltViewResponse' => '\\Mnm\\GetXsltViewResponse',
            'StringElementResponse' => '\\Mnm\\StringElementResponse',
            'ValidateInvoice' => '\\Mnm\\ValidateInvoice',
            'ValidateInvoiceResponse' => '\\Mnm\\ValidateInvoiceResponse',
            'GetInboxInvoices' => '\\Mnm\\GetInboxInvoices',
            'InboxInvoiceQueryModel' => '\\Mnm\\InboxInvoiceQueryModel',
            'InvoiceQueryModel' => '\\Mnm\\InvoiceQueryModel',
            'GetInboxInvoicesResponse' => '\\Mnm\\GetInboxInvoicesResponse',
            'InvoicesResponse' => '\\Mnm\\InvoicesResponse',
            'PagedResponseOfInvoiceInfo' => '\\Mnm\\PagedResponseOfInvoiceInfo',
            'InvoiceInfo' => '\\Mnm\\InvoiceInfo',
            'CustomerInfo' => '\\Mnm\\CustomerInfo',
            'EArchiveInvoiceInformation' => '\\Mnm\\EArchiveInvoiceInformation',
            'NewGenerationPaymentRecorderInformation' => '\\Mnm\\NewGenerationPaymentRecorderInformation',
            'InternetSalesInformation' => '\\Mnm\\InternetSalesInformation',
            'ShipmentInformation' => '\\Mnm\\ShipmentInformation',
            'ShipmentCarier' => '\\Mnm\\ShipmentCarier',
            'EArchiveWithHoldingInformation' => '\\Mnm\\EArchiveWithHoldingInformation',
            'NotificationInformation' => '\\Mnm\\NotificationInformation',
            'MailingInformation' => '\\Mnm\\MailingInformation',
            'MailAttachmentInformation' => '\\Mnm\\MailAttachmentInformation',
            'SmsMessageInformation' => '\\Mnm\\SmsMessageInformation',
            'GetInboxInvoiceList' => '\\Mnm\\GetInboxInvoiceList',
            'InboxInvoiceListQueryModel' => '\\Mnm\\InboxInvoiceListQueryModel',
            'InvoiceListQueryModel' => '\\Mnm\\InvoiceListQueryModel',
            'GetInboxInvoiceListResponse' => '\\Mnm\\GetInboxInvoiceListResponse',
            'InboxInvoiceListResponse' => '\\Mnm\\InboxInvoiceListResponse',
            'PagedResponseOfInboxInvoiceListItem' => '\\Mnm\\PagedResponseOfInboxInvoiceListItem',
            'InboxInvoiceListItem' => '\\Mnm\\InboxInvoiceListItem',
            'InvoiceListItemBase' => '\\Mnm\\InvoiceListItemBase',
            'GetInboxInvoice' => '\\Mnm\\GetInboxInvoice',
            'GetInboxInvoiceResponse' => '\\Mnm\\GetInboxInvoiceResponse',
            'InvoiceResponse' => '\\Mnm\\InvoiceResponse',
            'QueryInboxInvoiceStatus' => '\\Mnm\\QueryInboxInvoiceStatus',
            'ArrayOfString' => '\\Mnm\\ArrayOfString',
            'QueryInboxInvoiceStatusResponse' => '\\Mnm\\QueryInboxInvoiceStatusResponse',
            'InvoiceStatusResponse' => '\\Mnm\\InvoiceStatusResponse',
            'InvoiceStatusInfo' => '\\Mnm\\InvoiceStatusInfo',
            'SetInvoicesTaken' => '\\Mnm\\SetInvoicesTaken',
            'SetInvoicesTakenResponse' => '\\Mnm\\SetInvoicesTakenResponse',
            'SendDocumentResponse' => '\\Mnm\\SendDocumentResponse',
            'ArrayOfDocumentResponseInfo' => '\\Mnm\\ArrayOfDocumentResponseInfo',
            'DocumentResponseInfo' => '\\Mnm\\DocumentResponseInfo',
            'ArrayOfLineResponseInfo' => '\\Mnm\\ArrayOfLineResponseInfo',
            'LineResponseInfo' => '\\Mnm\\LineResponseInfo',
            'SendDocumentResponseResponse' => '\\Mnm\\SendDocumentResponseResponse',
            'QueryDocumentResponseStatus' => '\\Mnm\\QueryDocumentResponseStatus',
            'QueryDocumentResponseStatusResponse' => '\\Mnm\\QueryDocumentResponseStatusResponse',
            'DocumentResponseStatusResponse' => '\\Mnm\\DocumentResponseStatusResponse',
            'DocumentResponseStatusInfo' => '\\Mnm\\DocumentResponseStatusInfo',
            'GetOutboxInvoices' => '\\Mnm\\GetOutboxInvoices',
            'GetOutboxInvoicesResponse' => '\\Mnm\\GetOutboxInvoicesResponse',
            'GetOutboxInvoiceList' => '\\Mnm\\GetOutboxInvoiceList',
            'OutboxInvoiceListQueryModel' => '\\Mnm\\OutboxInvoiceListQueryModel',
            'GetOutboxInvoiceListResponse' => '\\Mnm\\GetOutboxInvoiceListResponse',
            'OutboxInvoiceListResponse' => '\\Mnm\\OutboxInvoiceListResponse',
            'PagedResponseOfOutboxInvoiceListItem' => '\\Mnm\\PagedResponseOfOutboxInvoiceListItem',
            'OutboxInvoiceListItem' => '\\Mnm\\OutboxInvoiceListItem',
            'GetOutboxInvoice' => '\\Mnm\\GetOutboxInvoice',
            'GetOutboxInvoiceResponse' => '\\Mnm\\GetOutboxInvoiceResponse',
            'GetOutboxInvoicesData' => '\\Mnm\\GetOutboxInvoicesData',
            'GetOutboxInvoicesDataResponse' => '\\Mnm\\GetOutboxInvoicesDataResponse',
            'InvoicesDataResponse' => '\\Mnm\\InvoicesDataResponse',
            'PagedResponseOfInvoiceData' => '\\Mnm\\PagedResponseOfInvoiceData',
            'InvoiceData' => '\\Mnm\\InvoiceData',
            'GetOutboxInvoiceData' => '\\Mnm\\GetOutboxInvoiceData',
            'GetOutboxInvoiceDataResponse' => '\\Mnm\\GetOutboxInvoiceDataResponse',
            'InvoiceDataResponse' => '\\Mnm\\InvoiceDataResponse',
            'GetInboxInvoicesData' => '\\Mnm\\GetInboxInvoicesData',
            'GetInboxInvoicesDataResponse' => '\\Mnm\\GetInboxInvoicesDataResponse',
            'GetInboxInvoiceData' => '\\Mnm\\GetInboxInvoiceData',
            'GetInboxInvoiceDataResponse' => '\\Mnm\\GetInboxInvoiceDataResponse',
            'QueryOutboxInvoiceStatus' => '\\Mnm\\QueryOutboxInvoiceStatus',
            'QueryOutboxInvoiceStatusResponse' => '\\Mnm\\QueryOutboxInvoiceStatusResponse',
            'QueryInvoiceGtbResponses' => '\\Mnm\\QueryInvoiceGtbResponses',
            'QueryInvoiceGtbResponsesResponse' => '\\Mnm\\QueryInvoiceGtbResponsesResponse',
            'InvoiceGtbInfoResponse' => '\\Mnm\\InvoiceGtbInfoResponse',
            'InvoiceExportGtbInformation' => '\\Mnm\\InvoiceExportGtbInformation',
            'SaveAsDraft' => '\\Mnm\\SaveAsDraft',
            'ArrayOfInvoiceInfo' => '\\Mnm\\ArrayOfInvoiceInfo',
            'SaveAsDraftResponse' => '\\Mnm\\SaveAsDraftResponse',
            'InvoiceIdentitiesResponse' => '\\Mnm\\InvoiceIdentitiesResponse',
            'InvoiceIdentity' => '\\Mnm\\InvoiceIdentity',
            'SendInvoice' => '\\Mnm\\SendInvoice',
            'SendInvoiceResponse' => '\\Mnm\\SendInvoiceResponse',
            'CompressedSaveAsDraft' => '\\Mnm\\CompressedSaveAsDraft',
            'BinaryRequestData' => '\\Mnm\\BinaryRequestData',
            'CompressedSaveAsDraftResponse' => '\\Mnm\\CompressedSaveAsDraftResponse',
            'CompressedSendInvoice' => '\\Mnm\\CompressedSendInvoice',
            'CompressedSendInvoiceResponse' => '\\Mnm\\CompressedSendInvoiceResponse',
            'SendDraft' => '\\Mnm\\SendDraft',
            'SendDraftResponse' => '\\Mnm\\SendDraftResponse',
            'CancelDraft' => '\\Mnm\\CancelDraft',
            'CancelDraftResponse' => '\\Mnm\\CancelDraftResponse',
            'GetInboxInvoiceView' => '\\Mnm\\GetInboxInvoiceView',
            'GetInboxInvoiceViewResponse' => '\\Mnm\\GetInboxInvoiceViewResponse',
            'InvoiceViewResponse' => '\\Mnm\\InvoiceViewResponse',
            'ViewResult' => '\\Mnm\\ViewResult',
            'VerificationResult' => '\\Mnm\\VerificationResult',
            'GetOutboxInvoiceView' => '\\Mnm\\GetOutboxInvoiceView',
            'GetOutboxInvoiceViewResponse' => '\\Mnm\\GetOutboxInvoiceViewResponse',
            'GetOutboxInvoiceResponseView' => '\\Mnm\\GetOutboxInvoiceResponseView',
            'GetOutboxInvoiceResponseViewResponse' => '\\Mnm\\GetOutboxInvoiceResponseViewResponse',
            'GetInboxInvoiceStatusWithLogs' => '\\Mnm\\GetInboxInvoiceStatusWithLogs',
            'GetInboxInvoiceStatusWithLogsResponse' => '\\Mnm\\GetInboxInvoiceStatusWithLogsResponse',
            'InvoiceStatusWithLogResponse' => '\\Mnm\\InvoiceStatusWithLogResponse',
            'InvoiceStatusWithLogInfo' => '\\Mnm\\InvoiceStatusWithLogInfo',
            'InvoiceLogItem' => '\\Mnm\\InvoiceLogItem',
            'LogRecordItem' => '\\Mnm\\LogRecordItem',
            'GetOutboxInvoiceStatusWithLogs' => '\\Mnm\\GetOutboxInvoiceStatusWithLogs',
            'GetOutboxInvoiceStatusWithLogsResponse' => '\\Mnm\\GetOutboxInvoiceStatusWithLogsResponse',
            'RetrySendInvoices' => '\\Mnm\\RetrySendInvoices',
            'RetrySendInvoicesResponse' => '\\Mnm\\RetrySendInvoicesResponse',
            'CloneInvoices' => '\\Mnm\\CloneInvoices',
            'CloneInvoicesResponse' => '\\Mnm\\CloneInvoicesResponse',
            'CloneInvoiceServiceResponse' => '\\Mnm\\CloneInvoiceServiceResponse',
            'ClonedInvoiceInfo' => '\\Mnm\\ClonedInvoiceInfo',
            'CancelEArchiveInvoice' => '\\Mnm\\CancelEArchiveInvoice',
            'EArchiveCancelInvoiceContext' => '\\Mnm\\EArchiveCancelInvoiceContext',
            'CancelEArchiveInvoiceResponse' => '\\Mnm\\CancelEArchiveInvoiceResponse',
            'GetInboxInvoicePdf' => '\\Mnm\\GetInboxInvoicePdf',
            'GetInboxInvoicePdfResponse' => '\\Mnm\\GetInboxInvoicePdfResponse',
            'GetOutboxInvoicePdf' => '\\Mnm\\GetOutboxInvoicePdf',
            'GetOutboxInvoicePdfResponse' => '\\Mnm\\GetOutboxInvoicePdfResponse',
            'ChangeInvoiceArchiveStatus' => '\\Mnm\\ChangeInvoiceArchiveStatus',
            'ChangeInvoiceArchiveStatusResponse' => '\\Mnm\\ChangeInvoiceArchiveStatusResponse',
            'GetSystemUsersCompressedList' => '\\Mnm\\GetSystemUsersCompressedList',
            'GetSystemUsersCompressedListResponse' => '\\Mnm\\GetSystemUsersCompressedListResponse',
            'ByteArrayResponse' => '\\Mnm\\ByteArrayResponse',
            'GetSystemUsersCompressedListOld' => '\\Mnm\\GetSystemUsersCompressedListOld',
            'GetSystemUsersCompressedListOldResponse' => '\\Mnm\\GetSystemUsersCompressedListOldResponse',
            'ImportExistingInvoice' => '\\Mnm\\ImportExistingInvoice',
            'FileUploadRequest' => '\\Mnm\\FileUploadRequest',
            'ImportExistingInvoiceResponse' => '\\Mnm\\ImportExistingInvoiceResponse',
            'QueueInvoiceNotification' => '\\Mnm\\QueueInvoiceNotification',
            'QueueInvoiceNotificationRequest' => '\\Mnm\\QueueInvoiceNotificationRequest',
            'QueueInvoiceNotificationResponse' => '\\Mnm\\QueueInvoiceNotificationResponse',
            'GetInvoiceEnvelope' => '\\Mnm\\GetInvoiceEnvelope',
            'GetInvoiceEnvelopeResponse' => '\\Mnm\\GetInvoiceEnvelopeResponse',
            'EnvelopeResponse' => '\\Mnm\\EnvelopeResponse',
            'ResponseOfEnvelopeData' => '\\Mnm\\ResponseOfEnvelopeData',
            'EnvelopeData' => '\\Mnm\\EnvelopeData',
            'TestConnection' => '\\Mnm\\TestConnection',
            'TestConnectionResponse' => '\\Mnm\\TestConnectionResponse',
            'GetSummaryReport' => '\\Mnm\\GetSummaryReport',
            'GetSummaryReportResponse' => '\\Mnm\\GetSummaryReportResponse',
            'SummaryReportResponse' => '\\Mnm\\SummaryReportResponse',
            'CustomerSummaryUsageReport' => '\\Mnm\\CustomerSummaryUsageReport',
            'Last10DaysReport' => '\\Mnm\\Last10DaysReport',
            'MonthlyReportItem' => '\\Mnm\\MonthlyReportItem',
            'WhoAmI' => '\\Mnm\\WhoAmI',
            'WhoAmIResponse' => '\\Mnm\\WhoAmIResponse',
            'ResponseOfWhoAmIInfo' => '\\Mnm\\ResponseOfWhoAmIInfo',
            'WhoAmIInfo' => '\\Mnm\\WhoAmIInfo',
            'UserShortInfo' => '\\Mnm\\UserShortInfo',
            'CustomerWithoutServiceInformation' => '\\Mnm\\CustomerWithoutServiceInformation',
            'ReferencedSignatureIDType' => '\\Mnm\\ReferencedSignatureIDType',
        );
    }
}
