<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillingReferenceType StructType
 * @subpackage Structs
 */
class BillingReferenceType extends AbstractStructBase
{
    /**
     * The InvoiceDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\DocumentReferenceType
     */
    public $InvoiceDocumentReference;
    /**
     * The SelfBilledInvoiceDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\DocumentReferenceType
     */
    public $SelfBilledInvoiceDocumentReference;
    /**
     * The CreditNoteDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\DocumentReferenceType
     */
    public $CreditNoteDocumentReference;
    /**
     * The SelfBilledCreditNoteDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\DocumentReferenceType
     */
    public $SelfBilledCreditNoteDocumentReference;
    /**
     * The DebitNoteDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\DocumentReferenceType
     */
    public $DebitNoteDocumentReference;
    /**
     * The ReminderDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\DocumentReferenceType
     */
    public $ReminderDocumentReference;
    /**
     * The AdditionalDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Mnm\DocumentReferenceType
     */
    public $AdditionalDocumentReference;
    /**
     * The BillingReferenceLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\BillingReferenceLineType[]
     */
    public $BillingReferenceLine;
    /**
     * Constructor method for BillingReferenceType
     * @uses BillingReferenceType::setInvoiceDocumentReference()
     * @uses BillingReferenceType::setSelfBilledInvoiceDocumentReference()
     * @uses BillingReferenceType::setCreditNoteDocumentReference()
     * @uses BillingReferenceType::setSelfBilledCreditNoteDocumentReference()
     * @uses BillingReferenceType::setDebitNoteDocumentReference()
     * @uses BillingReferenceType::setReminderDocumentReference()
     * @uses BillingReferenceType::setAdditionalDocumentReference()
     * @uses BillingReferenceType::setBillingReferenceLine()
     * @param \Mnm\DocumentReferenceType $invoiceDocumentReference
     * @param \Mnm\DocumentReferenceType $selfBilledInvoiceDocumentReference
     * @param \Mnm\DocumentReferenceType $creditNoteDocumentReference
     * @param \Mnm\DocumentReferenceType $selfBilledCreditNoteDocumentReference
     * @param \Mnm\DocumentReferenceType $debitNoteDocumentReference
     * @param \Mnm\DocumentReferenceType $reminderDocumentReference
     * @param \Mnm\DocumentReferenceType $additionalDocumentReference
     * @param \Mnm\BillingReferenceLineType[] $billingReferenceLine
     */
    public function __construct(\Mnm\DocumentReferenceType $invoiceDocumentReference = null, \Mnm\DocumentReferenceType $selfBilledInvoiceDocumentReference = null, \Mnm\DocumentReferenceType $creditNoteDocumentReference = null, \Mnm\DocumentReferenceType $selfBilledCreditNoteDocumentReference = null, \Mnm\DocumentReferenceType $debitNoteDocumentReference = null, \Mnm\DocumentReferenceType $reminderDocumentReference = null, \Mnm\DocumentReferenceType $additionalDocumentReference = null, array $billingReferenceLine = array())
    {
        $this
            ->setInvoiceDocumentReference($invoiceDocumentReference)
            ->setSelfBilledInvoiceDocumentReference($selfBilledInvoiceDocumentReference)
            ->setCreditNoteDocumentReference($creditNoteDocumentReference)
            ->setSelfBilledCreditNoteDocumentReference($selfBilledCreditNoteDocumentReference)
            ->setDebitNoteDocumentReference($debitNoteDocumentReference)
            ->setReminderDocumentReference($reminderDocumentReference)
            ->setAdditionalDocumentReference($additionalDocumentReference)
            ->setBillingReferenceLine($billingReferenceLine);
    }
    /**
     * Get InvoiceDocumentReference value
     * @return \Mnm\DocumentReferenceType|null
     */
    public function getInvoiceDocumentReference()
    {
        return $this->InvoiceDocumentReference;
    }
    /**
     * Set InvoiceDocumentReference value
     * @param \Mnm\DocumentReferenceType $invoiceDocumentReference
     * @return \Mnm\BillingReferenceType
     */
    public function setInvoiceDocumentReference(\Mnm\DocumentReferenceType $invoiceDocumentReference = null)
    {
        $this->InvoiceDocumentReference = $invoiceDocumentReference;
        return $this;
    }
    /**
     * Get SelfBilledInvoiceDocumentReference value
     * @return \Mnm\DocumentReferenceType|null
     */
    public function getSelfBilledInvoiceDocumentReference()
    {
        return $this->SelfBilledInvoiceDocumentReference;
    }
    /**
     * Set SelfBilledInvoiceDocumentReference value
     * @param \Mnm\DocumentReferenceType $selfBilledInvoiceDocumentReference
     * @return \Mnm\BillingReferenceType
     */
    public function setSelfBilledInvoiceDocumentReference(\Mnm\DocumentReferenceType $selfBilledInvoiceDocumentReference = null)
    {
        $this->SelfBilledInvoiceDocumentReference = $selfBilledInvoiceDocumentReference;
        return $this;
    }
    /**
     * Get CreditNoteDocumentReference value
     * @return \Mnm\DocumentReferenceType|null
     */
    public function getCreditNoteDocumentReference()
    {
        return $this->CreditNoteDocumentReference;
    }
    /**
     * Set CreditNoteDocumentReference value
     * @param \Mnm\DocumentReferenceType $creditNoteDocumentReference
     * @return \Mnm\BillingReferenceType
     */
    public function setCreditNoteDocumentReference(\Mnm\DocumentReferenceType $creditNoteDocumentReference = null)
    {
        $this->CreditNoteDocumentReference = $creditNoteDocumentReference;
        return $this;
    }
    /**
     * Get SelfBilledCreditNoteDocumentReference value
     * @return \Mnm\DocumentReferenceType|null
     */
    public function getSelfBilledCreditNoteDocumentReference()
    {
        return $this->SelfBilledCreditNoteDocumentReference;
    }
    /**
     * Set SelfBilledCreditNoteDocumentReference value
     * @param \Mnm\DocumentReferenceType $selfBilledCreditNoteDocumentReference
     * @return \Mnm\BillingReferenceType
     */
    public function setSelfBilledCreditNoteDocumentReference(\Mnm\DocumentReferenceType $selfBilledCreditNoteDocumentReference = null)
    {
        $this->SelfBilledCreditNoteDocumentReference = $selfBilledCreditNoteDocumentReference;
        return $this;
    }
    /**
     * Get DebitNoteDocumentReference value
     * @return \Mnm\DocumentReferenceType|null
     */
    public function getDebitNoteDocumentReference()
    {
        return $this->DebitNoteDocumentReference;
    }
    /**
     * Set DebitNoteDocumentReference value
     * @param \Mnm\DocumentReferenceType $debitNoteDocumentReference
     * @return \Mnm\BillingReferenceType
     */
    public function setDebitNoteDocumentReference(\Mnm\DocumentReferenceType $debitNoteDocumentReference = null)
    {
        $this->DebitNoteDocumentReference = $debitNoteDocumentReference;
        return $this;
    }
    /**
     * Get ReminderDocumentReference value
     * @return \Mnm\DocumentReferenceType|null
     */
    public function getReminderDocumentReference()
    {
        return $this->ReminderDocumentReference;
    }
    /**
     * Set ReminderDocumentReference value
     * @param \Mnm\DocumentReferenceType $reminderDocumentReference
     * @return \Mnm\BillingReferenceType
     */
    public function setReminderDocumentReference(\Mnm\DocumentReferenceType $reminderDocumentReference = null)
    {
        $this->ReminderDocumentReference = $reminderDocumentReference;
        return $this;
    }
    /**
     * Get AdditionalDocumentReference value
     * @return \Mnm\DocumentReferenceType|null
     */
    public function getAdditionalDocumentReference()
    {
        return $this->AdditionalDocumentReference;
    }
    /**
     * Set AdditionalDocumentReference value
     * @param \Mnm\DocumentReferenceType $additionalDocumentReference
     * @return \Mnm\BillingReferenceType
     */
    public function setAdditionalDocumentReference(\Mnm\DocumentReferenceType $additionalDocumentReference = null)
    {
        $this->AdditionalDocumentReference = $additionalDocumentReference;
        return $this;
    }
    /**
     * Get BillingReferenceLine value
     * @return \Mnm\BillingReferenceLineType[]|null
     */
    public function getBillingReferenceLine()
    {
        return $this->BillingReferenceLine;
    }
    /**
     * Set BillingReferenceLine value
     * @param \Mnm\BillingReferenceLineType[] $billingReferenceLine
     * @return \Mnm\BillingReferenceType
     */
    public function setBillingReferenceLine(array $billingReferenceLine = array())
    {
        $this->BillingReferenceLine = $billingReferenceLine;
        return $this;
    }
    /**
     * Add item to BillingReferenceLine value
     * @throws \InvalidArgumentException
     * @param \Mnm\BillingReferenceLineType $item
     * @return \Mnm\BillingReferenceType
     */
    public function addToBillingReferenceLine(\Mnm\BillingReferenceLineType $item)
    {
        $this->BillingReferenceLine[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\BillingReferenceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
