<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillingReferenceLineType StructType
 * @subpackage Structs
 */
class BillingReferenceLineType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q72:ID
     * @var \Mnm\IDType
     */
    public $ID;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q73:Amount
     * @var \Mnm\AmountType
     */
    public $Amount;
    /**
     * The AllowanceCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Mnm\AllowanceChargeType[]
     */
    public $AllowanceCharge;
    /**
     * Constructor method for BillingReferenceLineType
     * @uses BillingReferenceLineType::setID()
     * @uses BillingReferenceLineType::setAmount()
     * @uses BillingReferenceLineType::setAllowanceCharge()
     * @param \Mnm\IDType $iD
     * @param \Mnm\AmountType $amount
     * @param \Mnm\AllowanceChargeType[] $allowanceCharge
     */
    public function __construct(\Mnm\IDType $iD = null, \Mnm\AmountType $amount = null, array $allowanceCharge = array())
    {
        $this
            ->setID($iD)
            ->setAmount($amount)
            ->setAllowanceCharge($allowanceCharge);
    }
    /**
     * Get ID value
     * @return \Mnm\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Mnm\IDType $iD
     * @return \Mnm\BillingReferenceLineType
     */
    public function setID(\Mnm\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Amount value
     * @return \Mnm\AmountType|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \Mnm\AmountType $amount
     * @return \Mnm\BillingReferenceLineType
     */
    public function setAmount(\Mnm\AmountType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get AllowanceCharge value
     * @return \Mnm\AllowanceChargeType[]|null
     */
    public function getAllowanceCharge()
    {
        return $this->AllowanceCharge;
    }
    /**
     * Set AllowanceCharge value
     * @param \Mnm\AllowanceChargeType[] $allowanceCharge
     * @return \Mnm\BillingReferenceLineType
     */
    public function setAllowanceCharge(array $allowanceCharge = array())
    {
        $this->AllowanceCharge = $allowanceCharge;
        return $this;
    }
    /**
     * Add item to AllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \Mnm\AllowanceChargeType $item
     * @return \Mnm\BillingReferenceLineType
     */
    public function addToAllowanceCharge(\Mnm\AllowanceChargeType $item)
    {
        $this->AllowanceCharge[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\BillingReferenceLineType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
