<?php

namespace Mnm;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDocumentResponseInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfDocumentResponseInfo extends AbstractStructArrayBase
{
    /**
     * The DocumentResponseInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Mnm\DocumentResponseInfo[]
     */
    public $DocumentResponseInfo;
    /**
     * Constructor method for ArrayOfDocumentResponseInfo
     * @uses ArrayOfDocumentResponseInfo::setDocumentResponseInfo()
     * @param \Mnm\DocumentResponseInfo[] $documentResponseInfo
     */
    public function __construct(array $documentResponseInfo = array())
    {
        $this
            ->setDocumentResponseInfo($documentResponseInfo);
    }
    /**
     * Get DocumentResponseInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Mnm\DocumentResponseInfo[]|null
     */
    public function getDocumentResponseInfo()
    {
        return isset($this->DocumentResponseInfo) ? $this->DocumentResponseInfo : null;
    }
    /**
     * Set DocumentResponseInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Mnm\DocumentResponseInfo[] $documentResponseInfo
     * @return \Mnm\ArrayOfDocumentResponseInfo
     */
    public function setDocumentResponseInfo(array $documentResponseInfo = array())
    {
        if (is_null($documentResponseInfo) || (is_array($documentResponseInfo) && empty($documentResponseInfo))) {
            unset($this->DocumentResponseInfo);
        } else {
            $this->DocumentResponseInfo = $documentResponseInfo;
        }
        return $this;
    }
    /**
     * Add item to DocumentResponseInfo value
     * @throws \InvalidArgumentException
     * @param \Mnm\DocumentResponseInfo $item
     * @return \Mnm\ArrayOfDocumentResponseInfo
     */
    public function addToDocumentResponseInfo(\Mnm\DocumentResponseInfo $item)
    {
        $this->DocumentResponseInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Mnm\DocumentResponseInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Mnm\DocumentResponseInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Mnm\DocumentResponseInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Mnm\DocumentResponseInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Mnm\DocumentResponseInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DocumentResponseInfo
     */
    public function getAttributeName()
    {
        return 'DocumentResponseInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Mnm\ArrayOfDocumentResponseInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
