<?php

namespace Mnm;

/**
 * This class stands for AliasType EnumType
 * @subpackage Enumerations
 */
class AliasType
{
    /**
     * Constant for value 'InvoiceReceiverbox'
     * @return string 'InvoiceReceiverbox'
     */
    const VALUE_INVOICE_RECEIVERBOX = 'InvoiceReceiverbox';
    /**
     * Constant for value 'InvoiceSenderbox'
     * @return string 'InvoiceSenderbox'
     */
    const VALUE_INVOICE_SENDERBOX = 'InvoiceSenderbox';
    /**
     * Constant for value 'DespatchReceiverbox'
     * @return string 'DespatchReceiverbox'
     */
    const VALUE_DESPATCH_RECEIVERBOX = 'DespatchReceiverbox';
    /**
     * Constant for value 'DespatchSenderbox'
     * @return string 'DespatchSenderbox'
     */
    const VALUE_DESPATCH_SENDERBOX = 'DespatchSenderbox';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INVOICE_RECEIVERBOX
     * @uses self::VALUE_INVOICE_SENDERBOX
     * @uses self::VALUE_DESPATCH_RECEIVERBOX
     * @uses self::VALUE_DESPATCH_SENDERBOX
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INVOICE_RECEIVERBOX,
            self::VALUE_INVOICE_SENDERBOX,
            self::VALUE_DESPATCH_RECEIVERBOX,
            self::VALUE_DESPATCH_SENDERBOX,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
