<?php

namespace EnumType;

/**
 * This class stands for uiszczaOplateType EnumType
 * @subpackage Enumerations
 */
class UiszczaOplateType
{
    /**
     * Constant for value 'NADAWCA'
     * @return string 'NADAWCA'
     */
    const VALUE_NADAWCA = 'NADAWCA';
    /**
     * Constant for value 'ADRESAT'
     * @return string 'ADRESAT'
     */
    const VALUE_ADRESAT = 'ADRESAT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NADAWCA
     * @uses self::VALUE_ADRESAT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NADAWCA,
            self::VALUE_ADRESAT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
