<?php

namespace EnumType;

/**
 * This class stands for terminRodzajPlusType EnumType
 * @subpackage Enumerations
 */
class TerminRodzajPlusType
{
    /**
     * Constant for value 'PORANEK'
     * @return string 'PORANEK'
     */
    const VALUE_PORANEK = 'PORANEK';
    /**
     * Constant for value 'POLUDNIE'
     * @return string 'POLUDNIE'
     */
    const VALUE_POLUDNIE = 'POLUDNIE';
    /**
     * Constant for value 'STANDARD'
     * @return string 'STANDARD'
     */
    const VALUE_STANDARD = 'STANDARD';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PORANEK
     * @uses self::VALUE_POLUDNIE
     * @uses self::VALUE_STANDARD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PORANEK,
            self::VALUE_POLUDNIE,
            self::VALUE_STANDARD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
