<?php

namespace EnumType;

/**
 * This class stands for sposobPobraniaType EnumType
 * @subpackage Enumerations
 */
class SposobPobraniaType
{
    /**
     * Constant for value 'PRZEKAZ'
     * @return string 'PRZEKAZ'
     */
    const VALUE_PRZEKAZ = 'PRZEKAZ';
    /**
     * Constant for value 'RACHUNEK_BANKOWY'
     * @return string 'RACHUNEK_BANKOWY'
     */
    const VALUE_RACHUNEK_BANKOWY = 'RACHUNEK_BANKOWY';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PRZEKAZ
     * @uses self::VALUE_RACHUNEK_BANKOWY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PRZEKAZ,
            self::VALUE_RACHUNEK_BANKOWY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
