<?php

namespace EnumType;

/**
 * This class stands for sposobNadaniaType EnumType
 * @subpackage Enumerations
 */
class SposobNadaniaType
{
    /**
     * Constant for value 'WERYFIKACJA_WEZEL_DOCELOWY'
     * @return string 'WERYFIKACJA_WEZEL_DOCELOWY'
     */
    const VALUE_WERYFIKACJA_WEZEL_DOCELOWY = 'WERYFIKACJA_WEZEL_DOCELOWY';
    /**
     * Constant for value 'WERYFIKACJA_WEZEL_NADAWCZY'
     * @return string 'WERYFIKACJA_WEZEL_NADAWCZY'
     */
    const VALUE_WERYFIKACJA_WEZEL_NADAWCZY = 'WERYFIKACJA_WEZEL_NADAWCZY';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_WERYFIKACJA_WEZEL_DOCELOWY
     * @uses self::VALUE_WERYFIKACJA_WEZEL_NADAWCZY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WERYFIKACJA_WEZEL_DOCELOWY,
            self::VALUE_WERYFIKACJA_WEZEL_NADAWCZY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
