<?php

namespace EnumType;

/**
 * This class stands for miejscaPozostawieniaAwizoEnum EnumType
 * @subpackage Enumerations
 */
class MiejscaPozostawieniaAwizoEnum
{
    /**
     * Constant for value 'SKRZYNKA_ODDAWCZA'
     * @return string 'SKRZYNKA_ODDAWCZA'
     */
    const VALUE_SKRZYNKA_ODDAWCZA = 'SKRZYNKA_ODDAWCZA';
    /**
     * Constant for value 'DRZWI_MIESZKANIA'
     * @return string 'DRZWI_MIESZKANIA'
     */
    const VALUE_DRZWI_MIESZKANIA = 'DRZWI_MIESZKANIA';
    /**
     * Constant for value 'DRZWI_INNEGO_POMIESZCZENIA'
     * @return string 'DRZWI_INNEGO_POMIESZCZENIA'
     */
    const VALUE_DRZWI_INNEGO_POMIESZCZENIA = 'DRZWI_INNEGO_POMIESZCZENIA';
    /**
     * Constant for value 'PRZY_WEJSCIU_NA_POSESJE'
     * @return string 'PRZY_WEJSCIU_NA_POSESJE'
     */
    const VALUE_PRZY_WEJSCIU_NA_POSESJE = 'PRZY_WEJSCIU_NA_POSESJE';
    /**
     * Constant for value 'SKRYTKA_POCZTOWA'
     * @return string 'SKRYTKA_POCZTOWA'
     */
    const VALUE_SKRYTKA_POCZTOWA = 'SKRYTKA_POCZTOWA';
    /**
     * Constant for value 'INNE_WIDOCZNE_MIEJSCE'
     * @return string 'INNE_WIDOCZNE_MIEJSCE'
     */
    const VALUE_INNE_WIDOCZNE_MIEJSCE = 'INNE_WIDOCZNE_MIEJSCE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SKRZYNKA_ODDAWCZA
     * @uses self::VALUE_DRZWI_MIESZKANIA
     * @uses self::VALUE_DRZWI_INNEGO_POMIESZCZENIA
     * @uses self::VALUE_PRZY_WEJSCIU_NA_POSESJE
     * @uses self::VALUE_SKRYTKA_POCZTOWA
     * @uses self::VALUE_INNE_WIDOCZNE_MIEJSCE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SKRZYNKA_ODDAWCZA,
            self::VALUE_DRZWI_MIESZKANIA,
            self::VALUE_DRZWI_INNEGO_POMIESZCZENIA,
            self::VALUE_PRZY_WEJSCIU_NA_POSESJE,
            self::VALUE_SKRYTKA_POCZTOWA,
            self::VALUE_INNE_WIDOCZNE_MIEJSCE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
