<?php

namespace EnumType;

/**
 * This class stands for gabarytType EnumType
 * @subpackage Enumerations
 */
class GabarytType
{
    /**
     * Constant for value 'GABARYT_A'
     * @return string 'GABARYT_A'
     */
    const VALUE_GABARYT_A = 'GABARYT_A';
    /**
     * Constant for value 'GABARYT_B'
     * @return string 'GABARYT_B'
     */
    const VALUE_GABARYT_B = 'GABARYT_B';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GABARYT_A
     * @uses self::VALUE_GABARYT_B
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GABARYT_A,
            self::VALUE_GABARYT_B,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
