<?php

namespace EnumType;

/**
 * This class stands for eZwrotTypZgodyType EnumType
 * @subpackage Enumerations
 */
class EZwrotTypZgodyType
{
    /**
     * Constant for value 'ZGODA_BRAK'
     * @return string 'ZGODA_BRAK'
     */
    const VALUE_ZGODA_BRAK = 'ZGODA_BRAK';
    /**
     * Constant for value 'ZGODA_AUTOMATYCZNA'
     * @return string 'ZGODA_AUTOMATYCZNA'
     */
    const VALUE_ZGODA_AUTOMATYCZNA = 'ZGODA_AUTOMATYCZNA';
    /**
     * Constant for value 'ZGODA_INDYWIDUALNA'
     * @return string 'ZGODA_INDYWIDUALNA'
     */
    const VALUE_ZGODA_INDYWIDUALNA = 'ZGODA_INDYWIDUALNA';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ZGODA_BRAK
     * @uses self::VALUE_ZGODA_AUTOMATYCZNA
     * @uses self::VALUE_ZGODA_INDYWIDUALNA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ZGODA_BRAK,
            self::VALUE_ZGODA_AUTOMATYCZNA,
            self::VALUE_ZGODA_INDYWIDUALNA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
