<?php

namespace EuVies;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Approx ServiceType
 * @subpackage Services
 */
class Approx extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named checkVatApprox
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \EuVies\CheckVatApprox $parameters
     * @return \EuVies\CheckVatApproxResponse|bool
     */
    public function checkVatApprox(\EuVies\CheckVatApprox $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->checkVatApprox($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \EuVies\CheckVatApproxResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
