<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DadosAdesao StructType
 * @subpackage Structs
 */
class DadosAdesao extends AbstractStructBase
{
    /**
     * The Agencia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Agencia;
    /**
     * The DataNascimento
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DataNascimento;
    /**
     * The DataInicio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DataInicio;
    /**
     * The DataTermo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DataTermo;
    /**
     * The DataAdesao
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DataAdesao;
    /**
     * The CodigoSeguroGrupo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CodigoSeguroGrupo;
    /**
     * The ValorViagem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ValorViagem;
    /**
     * The DtInicioInicial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DtInicioInicial;
    /**
     * The DtTermoInicial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DtTermoInicial;
    /**
     * The Reagendada
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Reagendada;
    /**
     * The Anulado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Anulado;
    /**
     * The NomeAgencia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NomeAgencia;
    /**
     * The IdRegisto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IdRegisto;
    /**
     * The Segurado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Segurado;
    /**
     * The Morada
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Morada;
    /**
     * The Localidade
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Localidade;
    /**
     * The CodigoPostal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoPostal;
    /**
     * The LocalidadePostal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocalidadePostal;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The NumeroIdentificacao
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumeroIdentificacao;
    /**
     * The NIF
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NIF;
    /**
     * The Destino
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Destino;
    /**
     * The Benificiario
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Benificiario;
    /**
     * The ListaCoberturas
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDadosCobertura
     */
    public $ListaCoberturas;
    /**
     * The ProcessoCompanhia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProcessoCompanhia;
    /**
     * The Passaporte
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Passaporte;
    /**
     * The Observacoes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Observacoes;
    /**
     * The CodigoVoo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoVoo;
    /**
     * The UltimoDossierAssistencia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UltimoDossierAssistencia;
    /**
     * Constructor method for DadosAdesao
     * @uses DadosAdesao::setAgencia()
     * @uses DadosAdesao::setDataNascimento()
     * @uses DadosAdesao::setDataInicio()
     * @uses DadosAdesao::setDataTermo()
     * @uses DadosAdesao::setDataAdesao()
     * @uses DadosAdesao::setCodigoSeguroGrupo()
     * @uses DadosAdesao::setValorViagem()
     * @uses DadosAdesao::setDtInicioInicial()
     * @uses DadosAdesao::setDtTermoInicial()
     * @uses DadosAdesao::setReagendada()
     * @uses DadosAdesao::setAnulado()
     * @uses DadosAdesao::setNomeAgencia()
     * @uses DadosAdesao::setIdRegisto()
     * @uses DadosAdesao::setSegurado()
     * @uses DadosAdesao::setMorada()
     * @uses DadosAdesao::setLocalidade()
     * @uses DadosAdesao::setCodigoPostal()
     * @uses DadosAdesao::setLocalidadePostal()
     * @uses DadosAdesao::setEmail()
     * @uses DadosAdesao::setNumeroIdentificacao()
     * @uses DadosAdesao::setNIF()
     * @uses DadosAdesao::setDestino()
     * @uses DadosAdesao::setBenificiario()
     * @uses DadosAdesao::setListaCoberturas()
     * @uses DadosAdesao::setProcessoCompanhia()
     * @uses DadosAdesao::setPassaporte()
     * @uses DadosAdesao::setObservacoes()
     * @uses DadosAdesao::setCodigoVoo()
     * @uses DadosAdesao::setUltimoDossierAssistencia()
     * @param int $agencia
     * @param string $dataNascimento
     * @param string $dataInicio
     * @param string $dataTermo
     * @param string $dataAdesao
     * @param int $codigoSeguroGrupo
     * @param float $valorViagem
     * @param string $dtInicioInicial
     * @param string $dtTermoInicial
     * @param bool $reagendada
     * @param bool $anulado
     * @param string $nomeAgencia
     * @param string $idRegisto
     * @param string $segurado
     * @param string $morada
     * @param string $localidade
     * @param string $codigoPostal
     * @param string $localidadePostal
     * @param string $email
     * @param string $numeroIdentificacao
     * @param string $nIF
     * @param string $destino
     * @param string $benificiario
     * @param \ArrayType\ArrayOfDadosCobertura $listaCoberturas
     * @param string $processoCompanhia
     * @param string $passaporte
     * @param string $observacoes
     * @param string $codigoVoo
     * @param string $ultimoDossierAssistencia
     */
    public function __construct($agencia = null, $dataNascimento = null, $dataInicio = null, $dataTermo = null, $dataAdesao = null, $codigoSeguroGrupo = null, $valorViagem = null, $dtInicioInicial = null, $dtTermoInicial = null, $reagendada = null, $anulado = null, $nomeAgencia = null, $idRegisto = null, $segurado = null, $morada = null, $localidade = null, $codigoPostal = null, $localidadePostal = null, $email = null, $numeroIdentificacao = null, $nIF = null, $destino = null, $benificiario = null, \ArrayType\ArrayOfDadosCobertura $listaCoberturas = null, $processoCompanhia = null, $passaporte = null, $observacoes = null, $codigoVoo = null, $ultimoDossierAssistencia = null)
    {
        $this
            ->setAgencia($agencia)
            ->setDataNascimento($dataNascimento)
            ->setDataInicio($dataInicio)
            ->setDataTermo($dataTermo)
            ->setDataAdesao($dataAdesao)
            ->setCodigoSeguroGrupo($codigoSeguroGrupo)
            ->setValorViagem($valorViagem)
            ->setDtInicioInicial($dtInicioInicial)
            ->setDtTermoInicial($dtTermoInicial)
            ->setReagendada($reagendada)
            ->setAnulado($anulado)
            ->setNomeAgencia($nomeAgencia)
            ->setIdRegisto($idRegisto)
            ->setSegurado($segurado)
            ->setMorada($morada)
            ->setLocalidade($localidade)
            ->setCodigoPostal($codigoPostal)
            ->setLocalidadePostal($localidadePostal)
            ->setEmail($email)
            ->setNumeroIdentificacao($numeroIdentificacao)
            ->setNIF($nIF)
            ->setDestino($destino)
            ->setBenificiario($benificiario)
            ->setListaCoberturas($listaCoberturas)
            ->setProcessoCompanhia($processoCompanhia)
            ->setPassaporte($passaporte)
            ->setObservacoes($observacoes)
            ->setCodigoVoo($codigoVoo)
            ->setUltimoDossierAssistencia($ultimoDossierAssistencia);
    }
    /**
     * Get Agencia value
     * @return int
     */
    public function getAgencia()
    {
        return $this->Agencia;
    }
    /**
     * Set Agencia value
     * @param int $agencia
     * @return \StructType\DadosAdesao
     */
    public function setAgencia($agencia = null)
    {
        // validation for constraint: int
        if (!is_null($agencia) && !(is_int($agencia) || ctype_digit($agencia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($agencia, true), gettype($agencia)), __LINE__);
        }
        $this->Agencia = $agencia;
        return $this;
    }
    /**
     * Get DataNascimento value
     * @return string
     */
    public function getDataNascimento()
    {
        return $this->DataNascimento;
    }
    /**
     * Set DataNascimento value
     * @param string $dataNascimento
     * @return \StructType\DadosAdesao
     */
    public function setDataNascimento($dataNascimento = null)
    {
        // validation for constraint: string
        if (!is_null($dataNascimento) && !is_string($dataNascimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataNascimento, true), gettype($dataNascimento)), __LINE__);
        }
        $this->DataNascimento = $dataNascimento;
        return $this;
    }
    /**
     * Get DataInicio value
     * @return string
     */
    public function getDataInicio()
    {
        return $this->DataInicio;
    }
    /**
     * Set DataInicio value
     * @param string $dataInicio
     * @return \StructType\DadosAdesao
     */
    public function setDataInicio($dataInicio = null)
    {
        // validation for constraint: string
        if (!is_null($dataInicio) && !is_string($dataInicio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataInicio, true), gettype($dataInicio)), __LINE__);
        }
        $this->DataInicio = $dataInicio;
        return $this;
    }
    /**
     * Get DataTermo value
     * @return string
     */
    public function getDataTermo()
    {
        return $this->DataTermo;
    }
    /**
     * Set DataTermo value
     * @param string $dataTermo
     * @return \StructType\DadosAdesao
     */
    public function setDataTermo($dataTermo = null)
    {
        // validation for constraint: string
        if (!is_null($dataTermo) && !is_string($dataTermo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataTermo, true), gettype($dataTermo)), __LINE__);
        }
        $this->DataTermo = $dataTermo;
        return $this;
    }
    /**
     * Get DataAdesao value
     * @return string
     */
    public function getDataAdesao()
    {
        return $this->DataAdesao;
    }
    /**
     * Set DataAdesao value
     * @param string $dataAdesao
     * @return \StructType\DadosAdesao
     */
    public function setDataAdesao($dataAdesao = null)
    {
        // validation for constraint: string
        if (!is_null($dataAdesao) && !is_string($dataAdesao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataAdesao, true), gettype($dataAdesao)), __LINE__);
        }
        $this->DataAdesao = $dataAdesao;
        return $this;
    }
    /**
     * Get CodigoSeguroGrupo value
     * @return int
     */
    public function getCodigoSeguroGrupo()
    {
        return $this->CodigoSeguroGrupo;
    }
    /**
     * Set CodigoSeguroGrupo value
     * @param int $codigoSeguroGrupo
     * @return \StructType\DadosAdesao
     */
    public function setCodigoSeguroGrupo($codigoSeguroGrupo = null)
    {
        // validation for constraint: int
        if (!is_null($codigoSeguroGrupo) && !(is_int($codigoSeguroGrupo) || ctype_digit($codigoSeguroGrupo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoSeguroGrupo, true), gettype($codigoSeguroGrupo)), __LINE__);
        }
        $this->CodigoSeguroGrupo = $codigoSeguroGrupo;
        return $this;
    }
    /**
     * Get ValorViagem value
     * @return float
     */
    public function getValorViagem()
    {
        return $this->ValorViagem;
    }
    /**
     * Set ValorViagem value
     * @param float $valorViagem
     * @return \StructType\DadosAdesao
     */
    public function setValorViagem($valorViagem = null)
    {
        // validation for constraint: float
        if (!is_null($valorViagem) && !(is_float($valorViagem) || is_numeric($valorViagem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorViagem, true), gettype($valorViagem)), __LINE__);
        }
        $this->ValorViagem = $valorViagem;
        return $this;
    }
    /**
     * Get DtInicioInicial value
     * @return string
     */
    public function getDtInicioInicial()
    {
        return $this->DtInicioInicial;
    }
    /**
     * Set DtInicioInicial value
     * @param string $dtInicioInicial
     * @return \StructType\DadosAdesao
     */
    public function setDtInicioInicial($dtInicioInicial = null)
    {
        // validation for constraint: string
        if (!is_null($dtInicioInicial) && !is_string($dtInicioInicial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dtInicioInicial, true), gettype($dtInicioInicial)), __LINE__);
        }
        $this->DtInicioInicial = $dtInicioInicial;
        return $this;
    }
    /**
     * Get DtTermoInicial value
     * @return string
     */
    public function getDtTermoInicial()
    {
        return $this->DtTermoInicial;
    }
    /**
     * Set DtTermoInicial value
     * @param string $dtTermoInicial
     * @return \StructType\DadosAdesao
     */
    public function setDtTermoInicial($dtTermoInicial = null)
    {
        // validation for constraint: string
        if (!is_null($dtTermoInicial) && !is_string($dtTermoInicial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dtTermoInicial, true), gettype($dtTermoInicial)), __LINE__);
        }
        $this->DtTermoInicial = $dtTermoInicial;
        return $this;
    }
    /**
     * Get Reagendada value
     * @return bool
     */
    public function getReagendada()
    {
        return $this->Reagendada;
    }
    /**
     * Set Reagendada value
     * @param bool $reagendada
     * @return \StructType\DadosAdesao
     */
    public function setReagendada($reagendada = null)
    {
        // validation for constraint: boolean
        if (!is_null($reagendada) && !is_bool($reagendada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reagendada, true), gettype($reagendada)), __LINE__);
        }
        $this->Reagendada = $reagendada;
        return $this;
    }
    /**
     * Get Anulado value
     * @return bool
     */
    public function getAnulado()
    {
        return $this->Anulado;
    }
    /**
     * Set Anulado value
     * @param bool $anulado
     * @return \StructType\DadosAdesao
     */
    public function setAnulado($anulado = null)
    {
        // validation for constraint: boolean
        if (!is_null($anulado) && !is_bool($anulado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($anulado, true), gettype($anulado)), __LINE__);
        }
        $this->Anulado = $anulado;
        return $this;
    }
    /**
     * Get NomeAgencia value
     * @return string|null
     */
    public function getNomeAgencia()
    {
        return $this->NomeAgencia;
    }
    /**
     * Set NomeAgencia value
     * @param string $nomeAgencia
     * @return \StructType\DadosAdesao
     */
    public function setNomeAgencia($nomeAgencia = null)
    {
        // validation for constraint: string
        if (!is_null($nomeAgencia) && !is_string($nomeAgencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeAgencia, true), gettype($nomeAgencia)), __LINE__);
        }
        $this->NomeAgencia = $nomeAgencia;
        return $this;
    }
    /**
     * Get IdRegisto value
     * @return string|null
     */
    public function getIdRegisto()
    {
        return $this->IdRegisto;
    }
    /**
     * Set IdRegisto value
     * @param string $idRegisto
     * @return \StructType\DadosAdesao
     */
    public function setIdRegisto($idRegisto = null)
    {
        // validation for constraint: string
        if (!is_null($idRegisto) && !is_string($idRegisto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idRegisto, true), gettype($idRegisto)), __LINE__);
        }
        $this->IdRegisto = $idRegisto;
        return $this;
    }
    /**
     * Get Segurado value
     * @return string|null
     */
    public function getSegurado()
    {
        return $this->Segurado;
    }
    /**
     * Set Segurado value
     * @param string $segurado
     * @return \StructType\DadosAdesao
     */
    public function setSegurado($segurado = null)
    {
        // validation for constraint: string
        if (!is_null($segurado) && !is_string($segurado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($segurado, true), gettype($segurado)), __LINE__);
        }
        $this->Segurado = $segurado;
        return $this;
    }
    /**
     * Get Morada value
     * @return string|null
     */
    public function getMorada()
    {
        return $this->Morada;
    }
    /**
     * Set Morada value
     * @param string $morada
     * @return \StructType\DadosAdesao
     */
    public function setMorada($morada = null)
    {
        // validation for constraint: string
        if (!is_null($morada) && !is_string($morada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($morada, true), gettype($morada)), __LINE__);
        }
        $this->Morada = $morada;
        return $this;
    }
    /**
     * Get Localidade value
     * @return string|null
     */
    public function getLocalidade()
    {
        return $this->Localidade;
    }
    /**
     * Set Localidade value
     * @param string $localidade
     * @return \StructType\DadosAdesao
     */
    public function setLocalidade($localidade = null)
    {
        // validation for constraint: string
        if (!is_null($localidade) && !is_string($localidade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localidade, true), gettype($localidade)), __LINE__);
        }
        $this->Localidade = $localidade;
        return $this;
    }
    /**
     * Get CodigoPostal value
     * @return string|null
     */
    public function getCodigoPostal()
    {
        return $this->CodigoPostal;
    }
    /**
     * Set CodigoPostal value
     * @param string $codigoPostal
     * @return \StructType\DadosAdesao
     */
    public function setCodigoPostal($codigoPostal = null)
    {
        // validation for constraint: string
        if (!is_null($codigoPostal) && !is_string($codigoPostal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoPostal, true), gettype($codigoPostal)), __LINE__);
        }
        $this->CodigoPostal = $codigoPostal;
        return $this;
    }
    /**
     * Get LocalidadePostal value
     * @return string|null
     */
    public function getLocalidadePostal()
    {
        return $this->LocalidadePostal;
    }
    /**
     * Set LocalidadePostal value
     * @param string $localidadePostal
     * @return \StructType\DadosAdesao
     */
    public function setLocalidadePostal($localidadePostal = null)
    {
        // validation for constraint: string
        if (!is_null($localidadePostal) && !is_string($localidadePostal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localidadePostal, true), gettype($localidadePostal)), __LINE__);
        }
        $this->LocalidadePostal = $localidadePostal;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\DadosAdesao
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get NumeroIdentificacao value
     * @return string|null
     */
    public function getNumeroIdentificacao()
    {
        return $this->NumeroIdentificacao;
    }
    /**
     * Set NumeroIdentificacao value
     * @param string $numeroIdentificacao
     * @return \StructType\DadosAdesao
     */
    public function setNumeroIdentificacao($numeroIdentificacao = null)
    {
        // validation for constraint: string
        if (!is_null($numeroIdentificacao) && !is_string($numeroIdentificacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroIdentificacao, true), gettype($numeroIdentificacao)), __LINE__);
        }
        $this->NumeroIdentificacao = $numeroIdentificacao;
        return $this;
    }
    /**
     * Get NIF value
     * @return string|null
     */
    public function getNIF()
    {
        return $this->NIF;
    }
    /**
     * Set NIF value
     * @param string $nIF
     * @return \StructType\DadosAdesao
     */
    public function setNIF($nIF = null)
    {
        // validation for constraint: string
        if (!is_null($nIF) && !is_string($nIF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nIF, true), gettype($nIF)), __LINE__);
        }
        $this->NIF = $nIF;
        return $this;
    }
    /**
     * Get Destino value
     * @return string|null
     */
    public function getDestino()
    {
        return $this->Destino;
    }
    /**
     * Set Destino value
     * @param string $destino
     * @return \StructType\DadosAdesao
     */
    public function setDestino($destino = null)
    {
        // validation for constraint: string
        if (!is_null($destino) && !is_string($destino)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destino, true), gettype($destino)), __LINE__);
        }
        $this->Destino = $destino;
        return $this;
    }
    /**
     * Get Benificiario value
     * @return string|null
     */
    public function getBenificiario()
    {
        return $this->Benificiario;
    }
    /**
     * Set Benificiario value
     * @param string $benificiario
     * @return \StructType\DadosAdesao
     */
    public function setBenificiario($benificiario = null)
    {
        // validation for constraint: string
        if (!is_null($benificiario) && !is_string($benificiario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($benificiario, true), gettype($benificiario)), __LINE__);
        }
        $this->Benificiario = $benificiario;
        return $this;
    }
    /**
     * Get ListaCoberturas value
     * @return \ArrayType\ArrayOfDadosCobertura|null
     */
    public function getListaCoberturas()
    {
        return $this->ListaCoberturas;
    }
    /**
     * Set ListaCoberturas value
     * @param \ArrayType\ArrayOfDadosCobertura $listaCoberturas
     * @return \StructType\DadosAdesao
     */
    public function setListaCoberturas(\ArrayType\ArrayOfDadosCobertura $listaCoberturas = null)
    {
        $this->ListaCoberturas = $listaCoberturas;
        return $this;
    }
    /**
     * Get ProcessoCompanhia value
     * @return string|null
     */
    public function getProcessoCompanhia()
    {
        return $this->ProcessoCompanhia;
    }
    /**
     * Set ProcessoCompanhia value
     * @param string $processoCompanhia
     * @return \StructType\DadosAdesao
     */
    public function setProcessoCompanhia($processoCompanhia = null)
    {
        // validation for constraint: string
        if (!is_null($processoCompanhia) && !is_string($processoCompanhia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processoCompanhia, true), gettype($processoCompanhia)), __LINE__);
        }
        $this->ProcessoCompanhia = $processoCompanhia;
        return $this;
    }
    /**
     * Get Passaporte value
     * @return string|null
     */
    public function getPassaporte()
    {
        return $this->Passaporte;
    }
    /**
     * Set Passaporte value
     * @param string $passaporte
     * @return \StructType\DadosAdesao
     */
    public function setPassaporte($passaporte = null)
    {
        // validation for constraint: string
        if (!is_null($passaporte) && !is_string($passaporte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passaporte, true), gettype($passaporte)), __LINE__);
        }
        $this->Passaporte = $passaporte;
        return $this;
    }
    /**
     * Get Observacoes value
     * @return string|null
     */
    public function getObservacoes()
    {
        return $this->Observacoes;
    }
    /**
     * Set Observacoes value
     * @param string $observacoes
     * @return \StructType\DadosAdesao
     */
    public function setObservacoes($observacoes = null)
    {
        // validation for constraint: string
        if (!is_null($observacoes) && !is_string($observacoes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($observacoes, true), gettype($observacoes)), __LINE__);
        }
        $this->Observacoes = $observacoes;
        return $this;
    }
    /**
     * Get CodigoVoo value
     * @return string|null
     */
    public function getCodigoVoo()
    {
        return $this->CodigoVoo;
    }
    /**
     * Set CodigoVoo value
     * @param string $codigoVoo
     * @return \StructType\DadosAdesao
     */
    public function setCodigoVoo($codigoVoo = null)
    {
        // validation for constraint: string
        if (!is_null($codigoVoo) && !is_string($codigoVoo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoVoo, true), gettype($codigoVoo)), __LINE__);
        }
        $this->CodigoVoo = $codigoVoo;
        return $this;
    }
    /**
     * Get UltimoDossierAssistencia value
     * @return string|null
     */
    public function getUltimoDossierAssistencia()
    {
        return $this->UltimoDossierAssistencia;
    }
    /**
     * Set UltimoDossierAssistencia value
     * @param string $ultimoDossierAssistencia
     * @return \StructType\DadosAdesao
     */
    public function setUltimoDossierAssistencia($ultimoDossierAssistencia = null)
    {
        // validation for constraint: string
        if (!is_null($ultimoDossierAssistencia) && !is_string($ultimoDossierAssistencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ultimoDossierAssistencia, true), gettype($ultimoDossierAssistencia)), __LINE__);
        }
        $this->UltimoDossierAssistencia = $ultimoDossierAssistencia;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DadosAdesao
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
