<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DadosCobertura StructType
 * @subpackage Structs
 */
class DadosCobertura extends AbstractStructBase
{
    /**
     * The PremioTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PremioTotal;
    /**
     * The ValorVenda
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ValorVenda;
    /**
     * The Produto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Produto;
    /**
     * The NomeProduto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NomeProduto;
    /**
     * The Seguradora
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Seguradora;
    /**
     * The Apolice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Apolice;
    /**
     * The SociedadeGabinete
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SociedadeGabinete;
    /**
     * The AgenciaGabinete
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgenciaGabinete;
    /**
     * The ProdutoGabinete
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProdutoGabinete;
    /**
     * Constructor method for DadosCobertura
     * @uses DadosCobertura::setPremioTotal()
     * @uses DadosCobertura::setValorVenda()
     * @uses DadosCobertura::setProduto()
     * @uses DadosCobertura::setNomeProduto()
     * @uses DadosCobertura::setSeguradora()
     * @uses DadosCobertura::setApolice()
     * @uses DadosCobertura::setSociedadeGabinete()
     * @uses DadosCobertura::setAgenciaGabinete()
     * @uses DadosCobertura::setProdutoGabinete()
     * @param float $premioTotal
     * @param float $valorVenda
     * @param string $produto
     * @param string $nomeProduto
     * @param string $seguradora
     * @param string $apolice
     * @param string $sociedadeGabinete
     * @param string $agenciaGabinete
     * @param string $produtoGabinete
     */
    public function __construct($premioTotal = null, $valorVenda = null, $produto = null, $nomeProduto = null, $seguradora = null, $apolice = null, $sociedadeGabinete = null, $agenciaGabinete = null, $produtoGabinete = null)
    {
        $this
            ->setPremioTotal($premioTotal)
            ->setValorVenda($valorVenda)
            ->setProduto($produto)
            ->setNomeProduto($nomeProduto)
            ->setSeguradora($seguradora)
            ->setApolice($apolice)
            ->setSociedadeGabinete($sociedadeGabinete)
            ->setAgenciaGabinete($agenciaGabinete)
            ->setProdutoGabinete($produtoGabinete);
    }
    /**
     * Get PremioTotal value
     * @return float
     */
    public function getPremioTotal()
    {
        return $this->PremioTotal;
    }
    /**
     * Set PremioTotal value
     * @param float $premioTotal
     * @return \StructType\DadosCobertura
     */
    public function setPremioTotal($premioTotal = null)
    {
        // validation for constraint: float
        if (!is_null($premioTotal) && !(is_float($premioTotal) || is_numeric($premioTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($premioTotal, true), gettype($premioTotal)), __LINE__);
        }
        $this->PremioTotal = $premioTotal;
        return $this;
    }
    /**
     * Get ValorVenda value
     * @return float
     */
    public function getValorVenda()
    {
        return $this->ValorVenda;
    }
    /**
     * Set ValorVenda value
     * @param float $valorVenda
     * @return \StructType\DadosCobertura
     */
    public function setValorVenda($valorVenda = null)
    {
        // validation for constraint: float
        if (!is_null($valorVenda) && !(is_float($valorVenda) || is_numeric($valorVenda))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorVenda, true), gettype($valorVenda)), __LINE__);
        }
        $this->ValorVenda = $valorVenda;
        return $this;
    }
    /**
     * Get Produto value
     * @return string|null
     */
    public function getProduto()
    {
        return $this->Produto;
    }
    /**
     * Set Produto value
     * @param string $produto
     * @return \StructType\DadosCobertura
     */
    public function setProduto($produto = null)
    {
        // validation for constraint: string
        if (!is_null($produto) && !is_string($produto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($produto, true), gettype($produto)), __LINE__);
        }
        $this->Produto = $produto;
        return $this;
    }
    /**
     * Get NomeProduto value
     * @return string|null
     */
    public function getNomeProduto()
    {
        return $this->NomeProduto;
    }
    /**
     * Set NomeProduto value
     * @param string $nomeProduto
     * @return \StructType\DadosCobertura
     */
    public function setNomeProduto($nomeProduto = null)
    {
        // validation for constraint: string
        if (!is_null($nomeProduto) && !is_string($nomeProduto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeProduto, true), gettype($nomeProduto)), __LINE__);
        }
        $this->NomeProduto = $nomeProduto;
        return $this;
    }
    /**
     * Get Seguradora value
     * @return string|null
     */
    public function getSeguradora()
    {
        return $this->Seguradora;
    }
    /**
     * Set Seguradora value
     * @param string $seguradora
     * @return \StructType\DadosCobertura
     */
    public function setSeguradora($seguradora = null)
    {
        // validation for constraint: string
        if (!is_null($seguradora) && !is_string($seguradora)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seguradora, true), gettype($seguradora)), __LINE__);
        }
        $this->Seguradora = $seguradora;
        return $this;
    }
    /**
     * Get Apolice value
     * @return string|null
     */
    public function getApolice()
    {
        return $this->Apolice;
    }
    /**
     * Set Apolice value
     * @param string $apolice
     * @return \StructType\DadosCobertura
     */
    public function setApolice($apolice = null)
    {
        // validation for constraint: string
        if (!is_null($apolice) && !is_string($apolice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apolice, true), gettype($apolice)), __LINE__);
        }
        $this->Apolice = $apolice;
        return $this;
    }
    /**
     * Get SociedadeGabinete value
     * @return string|null
     */
    public function getSociedadeGabinete()
    {
        return $this->SociedadeGabinete;
    }
    /**
     * Set SociedadeGabinete value
     * @param string $sociedadeGabinete
     * @return \StructType\DadosCobertura
     */
    public function setSociedadeGabinete($sociedadeGabinete = null)
    {
        // validation for constraint: string
        if (!is_null($sociedadeGabinete) && !is_string($sociedadeGabinete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sociedadeGabinete, true), gettype($sociedadeGabinete)), __LINE__);
        }
        $this->SociedadeGabinete = $sociedadeGabinete;
        return $this;
    }
    /**
     * Get AgenciaGabinete value
     * @return string|null
     */
    public function getAgenciaGabinete()
    {
        return $this->AgenciaGabinete;
    }
    /**
     * Set AgenciaGabinete value
     * @param string $agenciaGabinete
     * @return \StructType\DadosCobertura
     */
    public function setAgenciaGabinete($agenciaGabinete = null)
    {
        // validation for constraint: string
        if (!is_null($agenciaGabinete) && !is_string($agenciaGabinete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agenciaGabinete, true), gettype($agenciaGabinete)), __LINE__);
        }
        $this->AgenciaGabinete = $agenciaGabinete;
        return $this;
    }
    /**
     * Get ProdutoGabinete value
     * @return string|null
     */
    public function getProdutoGabinete()
    {
        return $this->ProdutoGabinete;
    }
    /**
     * Set ProdutoGabinete value
     * @param string $produtoGabinete
     * @return \StructType\DadosCobertura
     */
    public function setProdutoGabinete($produtoGabinete = null)
    {
        // validation for constraint: string
        if (!is_null($produtoGabinete) && !is_string($produtoGabinete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($produtoGabinete, true), gettype($produtoGabinete)), __LINE__);
        }
        $this->ProdutoGabinete = $produtoGabinete;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DadosCobertura
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
