<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the Autenticacao SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Autenticacao $autenticacao
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAutenticacao(\StructType\Autenticacao $autenticacao, $nameSpace = 'https://segurosdeviagem.rna.com.pt/Webservices/ViagensV2.asmx/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Autenticacao', $autenticacao, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named getDadosViagem
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Autenticacao
     * - SOAPHeaderNamespaces: https://segurosdeviagem.rna.com.pt/Webservices/ViagensV2.asmx/
     * - SOAPHeaderTypes: \StructType\Autenticacao
     * - SOAPHeaders: required
     * - documentation: Obtém dados de seguro viagem.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDadosViagem $parameters
     * @return \StructType\GetDadosViagemResponse|bool
     */
    public function getDadosViagem(\StructType\GetDadosViagem $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getDadosViagem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetDadosViagemResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
