<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://test.alu-verkauf.de/com/wsdl.php?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://test.alu-verkauf.de/com/wsdl.php?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \wsdl\ClassMap::get(),
);
/**
 * Samples for Auth ServiceType
 */
$auth = new \wsdl\ServiceType\Auth($options);
/**
 * Sample call for auth operation/method
 */
if ($auth->auth($Benutzer, $Passwort) !== false) {
    print_r($auth->getResult());
} else {
    print_r($auth->getLastError());
}
/**
 * Samples for Produkte ServiceType
 */
$produkte = new \wsdl\ServiceType\Produkte($options);
/**
 * Sample call for ProdukteAktualisieren operation/method
 */
if ($produkte->ProdukteAktualisieren($AuthCode, $Produkte) !== false) {
    print_r($produkte->getResult());
} else {
    print_r($produkte->getLastError());
}
/**
 * Samples for Bestellungen ServiceType
 */
$bestellungen = new \wsdl\ServiceType\Bestellungen($options);
/**
 * Sample call for Bestellungen operation/method
 */
if ($bestellungen->Bestellungen($AuthCode, $Zeit) !== false) {
    print_r($bestellungen->getResult());
} else {
    print_r($bestellungen->getLastError());
}
/**
 * Samples for Status ServiceType
 */
$status = new \wsdl\ServiceType\Status($options);
/**
 * Sample call for StatusAktualisieren operation/method
 */
if ($status->StatusAktualisieren($AuthCode, $StatusIDs) !== false) {
    print_r($status->getResult());
} else {
    print_r($status->getLastError());
}
/**
 * Samples for Bestellstatus ServiceType
 */
$bestellstatus = new \wsdl\ServiceType\Bestellstatus($options);
/**
 * Sample call for BestellstatusAktualisieren operation/method
 */
if ($bestellstatus->BestellstatusAktualisieren($AuthCode, $Bestellstatus) !== false) {
    print_r($bestellstatus->getResult());
} else {
    print_r($bestellstatus->getLastError());
}
